/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.content.ContentDownload;
import com.biglybt.core.content.ContentFile;
import com.biglybt.core.content.ContentFilter;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.impl.DeviceContentDirectoryImpl;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceInternetGatewayImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceMediaRendererImpl;
import com.biglybt.core.devices.impl.DeviceUPnPImpl;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.UUIDGenerator;
import com.biglybt.net.upnp.UPnP;
import com.biglybt.net.upnp.UPnPAdapter;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.net.upnp.UPnPFactory;
import com.biglybt.net.upnp.UPnPListener;
import com.biglybt.net.upnp.UPnPRootDevice;
import com.biglybt.net.upnp.UPnPRootDeviceListener;
import com.biglybt.net.upnp.UPnPSSDPListener;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.services.UPnPWANConnection;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.utils.UTTimer;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.ipc.IPCInterfaceImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeviceManagerUPnPImpl {
    private static final Object KEY_ROOT_DEVICE = new Object();
    DeviceManagerImpl manager;
    PluginInterface plugin_interface;
    private UPnP upnp;
    private TorrentAttribute ta_category;
    volatile IPCInterface upnpav_ipc;
    Map<InetAddress, String> unassociated_devices = new HashMap<InetAddress, String>();
    Set<String> access_logs = new HashSet<String>();

    protected DeviceManagerUPnPImpl(DeviceManagerImpl _manager) {
        this.manager = _manager;
    }

    protected void initialise() {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                new AEThread2("DMUPnPAsyncStart", true){

                    @Override
                    public void run() {
                        DeviceManagerUPnPImpl.this.startUp();
                    }
                }.start();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    protected DeviceManagerImpl getManager() {
        return this.manager;
    }

    protected TorrentAttribute getCategoryAttibute() {
        return this.ta_category;
    }

    protected void startUp() {
        UPnPAdapter adapter = new UPnPAdapter(){

            @Override
            public SimpleXMLParserDocument parseXML(String data) throws SimpleXMLParserDocumentException {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data);
            }

            @Override
            public ResourceDownloaderFactory getResourceDownloaderFactory() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            }

            @Override
            public UTTimer createTimer(String name) {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().createTimer(name);
            }

            @Override
            public void createThread(String name, Runnable runnable) {
                DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().createThread(name, runnable);
            }

            @Override
            public Comparator getAlphanumericComparator() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
            }

            @Override
            public void log(Throwable e) {
                Debug.printStackTrace(e);
            }

            @Override
            public void trace(String str) {
            }

            @Override
            public void log(String str) {
            }

            @Override
            public String getTraceDir() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getPluginDirectoryName();
            }
        };
        try {
            this.upnp = UPnPFactory.getSingleton(adapter, null);
            this.upnp.addRootDeviceListener(new UPnPListener(){

                @Override
                public boolean deviceDiscovered(String USN, URL location) {
                    return true;
                }

                @Override
                public void rootDeviceFound(UPnPRootDevice device) {
                    DeviceManagerUPnPImpl.this.handleDevice(device, true);
                }
            });
            this.upnp.getSSDP().addListener(new UPnPSSDPListener(){
                private Map<InetAddress, Boolean> liveness_map = new HashMap<InetAddress, Boolean>();

                @Override
                public void receivedResult(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String USN, URL location, String ST, String AL) {
                }

                @Override
                public void receivedNotify(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String USN, URL location, String NT, String NTS) {
                    this.alive(originator, !NTS.contains("byebye"));
                }

                @Override
                public String[] receivedSearch(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String ST) {
                    this.alive(originator, true);
                    return null;
                }

                @Override
                public void interfaceChanged(NetworkInterface network_interface) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void alive(InetAddress address, boolean alive) {
                    DeviceImpl[] devices;
                    Map<InetAddress, Boolean> map = this.liveness_map;
                    synchronized (map) {
                        Boolean b = this.liveness_map.get(address);
                        if (b != null && b == alive) {
                            return;
                        }
                        this.liveness_map.put(address, alive);
                    }
                    DeviceImpl[] deviceImplArray = devices = DeviceManagerUPnPImpl.this.manager.getDevices();
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DeviceMediaRendererImpl r;
                        InetAddress device_address;
                        DeviceImpl d = deviceImplArray[n2];
                        if (d instanceof DeviceMediaRendererImpl && (device_address = (r = (DeviceMediaRendererImpl)d).getAddress()) != null && device_address.equals(address) && r.isAlive() != alive) {
                            if (alive) {
                                r.alive();
                            } else {
                                r.dead();
                            }
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (Throwable e) {
            this.manager.log("UPnP device manager failed", e);
        }
        try {
            this.plugin_interface.addEventListener(new PluginEventListener(){

                @Override
                public void handleEvent(PluginEvent ev) {
                    PluginInterface pi;
                    int type = ev.getType();
                    if ((type == 8 || type == 9) && (pi = (PluginInterface)ev.getValue()).getPluginID().equals("azupnpav")) {
                        if (type == 8) {
                            DeviceManagerUPnPImpl.this.upnpav_ipc = pi.getIPC();
                            DeviceManagerUPnPImpl.this.addListener(pi);
                        } else {
                            DeviceManagerUPnPImpl.this.upnpav_ipc = null;
                        }
                    }
                }
            });
            PluginInterface pi = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
            if (pi == null) {
                this.manager.log("No UPnPAV plugin found");
            } else {
                this.upnpav_ipc = pi.getIPC();
                this.addListener(pi);
            }
        }
        catch (Throwable e) {
            this.manager.log("Failed to hook into UPnPAV", e);
        }
        this.manager.UPnPManagerStarted();
    }

    protected void addListener(PluginInterface pi) {
        try {
            IPCInterfaceImpl my_ipc = new IPCInterfaceImpl(new Object(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Map<String, Object> browseReceived(TrackerWebPageRequest request2, Map<String, Object> browser_args) {
                    String source;
                    Map headers = request2.getHeaders();
                    String user_agent = (String)headers.get("user-agent");
                    String client_info = (String)headers.get("x-av-client-info");
                    InetSocketAddress client_address = request2.getClientAddress2();
                    DeviceMediaRenderer explicit_renderer = null;
                    boolean handled = false;
                    if (user_agent != null) {
                        String lc_agent = user_agent.toLowerCase();
                        if (lc_agent.contains("playstation 3")) {
                            DeviceManagerUPnPImpl.this.handlePS3(client_address);
                            handled = true;
                        } else if (lc_agent.contains("xbox")) {
                            DeviceManagerUPnPImpl.this.handleXBox(client_address);
                            handled = true;
                        } else if (lc_agent.contains("nintendo wii")) {
                            DeviceManagerUPnPImpl.this.handleWii(client_address);
                            handled = true;
                        }
                    }
                    if (client_info != null) {
                        String lc_info = client_info.toLowerCase();
                        if (lc_info.contains("playstation 3")) {
                            DeviceManagerUPnPImpl.this.handlePS3(client_address);
                            handled = true;
                        } else if (lc_info.contains("azureus") || lc_info.contains("vuze") || lc_info.contains("biglybt")) {
                            explicit_renderer = DeviceManagerUPnPImpl.this.handleVuzeMSBrowser(client_address, client_info);
                            handled = true;
                        }
                    }
                    if (!handled) {
                        handled = DeviceManagerUPnPImpl.this.manager.browseReceived(request2, browser_args);
                    }
                    if (!handled && (source = (String)browser_args.get("source")) != null && source.equalsIgnoreCase("http")) {
                        DeviceManagerUPnPImpl.this.handleBrowser(client_address);
                        handled = true;
                    }
                    DeviceImpl[] devices = DeviceManagerUPnPImpl.this.manager.getDevices();
                    final ArrayList<DeviceMediaRendererImpl> browse_devices = new ArrayList<DeviceMediaRendererImpl>();
                    boolean restrict_access = false;
                    DeviceImpl[] deviceImplArray = devices;
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block38: {
                            DeviceImpl device = deviceImplArray[n2];
                            if (device instanceof DeviceMediaRendererImpl) {
                                DeviceMediaRendererImpl renderer = (DeviceMediaRendererImpl)device;
                                if (explicit_renderer == null || renderer == explicit_renderer) {
                                    InetAddress device_address = renderer.getAddress();
                                    try {
                                        String restriction;
                                        if (device_address == null || !device_address.equals(client_address.getAddress()) || !renderer.canFilterFilesView()) break block38;
                                        boolean skip = false;
                                        if (renderer.canRestrictAccess() && (restriction = renderer.getAccessRestriction().trim()).length() > 0) {
                                            String[] ips;
                                            String x = client_address.getAddress().getHostAddress();
                                            skip = true;
                                            String[] stringArray = ips = restriction.split(",");
                                            int n3 = ips.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                String ip = stringArray[n4];
                                                if (ip.startsWith("-")) {
                                                    if ((ip = ip.substring(1)).equals(x)) {
                                                        break;
                                                    }
                                                } else {
                                                    if (ip.startsWith("+")) {
                                                        ip = ip.substring(1);
                                                    }
                                                    if (ip.equals(x)) {
                                                        skip = false;
                                                        break;
                                                    }
                                                }
                                                ++n4;
                                            }
                                        }
                                        if (skip) {
                                            restrict_access = true;
                                            String host = client_address.getAddress().getHostAddress();
                                            Set<String> set = DeviceManagerUPnPImpl.this.access_logs;
                                            synchronized (set) {
                                                if (!DeviceManagerUPnPImpl.this.access_logs.contains(host)) {
                                                    DeviceManagerUPnPImpl.this.access_logs.add(host);
                                                    DeviceManagerUPnPImpl.this.manager.log("Ignoring browse from " + host + " due to access restriction for '" + renderer.getName() + "'");
                                                }
                                            }
                                        }
                                        browse_devices.add(renderer);
                                        renderer.browseReceived();
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    if (browse_devices.size() > 0) {
                        Map<InetAddress, String> map = DeviceManagerUPnPImpl.this.unassociated_devices;
                        synchronized (map) {
                            DeviceManagerUPnPImpl.this.unassociated_devices.remove(client_address.getAddress());
                        }
                        final boolean f_restrict_access = restrict_access;
                        result.put("filter", new ContentFilter(){

                            @Override
                            public boolean isVisible(ContentDownload download, Map<String, Object> browse_args) {
                                if (f_restrict_access) {
                                    return false;
                                }
                                boolean visible = false;
                                for (DeviceUPnPImpl device : browse_devices) {
                                    if (!device.isVisible(download)) continue;
                                    visible = true;
                                }
                                return visible;
                            }

                            @Override
                            public boolean isVisible(ContentFile file, Map<String, Object> browse_args) {
                                if (f_restrict_access) {
                                    return false;
                                }
                                boolean visible = false;
                                for (DeviceUPnPImpl device : browse_devices) {
                                    if (!device.isVisible(file)) continue;
                                    visible = true;
                                }
                                return visible;
                            }
                        });
                    } else if (request2.getHeader().substring(0, 4).equalsIgnoreCase("POST")) {
                        Map<InetAddress, String> map = DeviceManagerUPnPImpl.this.unassociated_devices;
                        synchronized (map) {
                            DeviceManagerUPnPImpl.this.unassociated_devices.put(client_address.getAddress(), user_agent);
                        }
                    }
                    return result;
                }
            });
            if (this.upnpav_ipc.canInvoke("addBrowseListener", new Object[]{my_ipc})) {
                DeviceImpl[] devices;
                DeviceImpl[] deviceImplArray = devices = this.manager.getDevices();
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    DeviceImpl device = deviceImplArray[n2];
                    if (device instanceof DeviceUPnPImpl) {
                        DeviceUPnPImpl u_d = (DeviceUPnPImpl)device;
                        u_d.resetUPNPAV();
                    }
                    ++n2;
                }
                this.upnpav_ipc.invoke("addBrowseListener", new Object[]{my_ipc});
            } else {
                this.manager.log("UPnPAV plugin needs upgrading");
            }
        }
        catch (Throwable e) {
            this.manager.log("Failed to hook into UPnPAV", e);
        }
    }

    protected void injectDiscoveryCache(Map cache) {
        try {
            this.upnp.injectDiscoveryCache(cache);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        HashMap<InetAddress, String> ud;
        ArrayList<7> result = new ArrayList<7>();
        Map<InetAddress, String> map = this.unassociated_devices;
        synchronized (map) {
            ud = new HashMap<InetAddress, String>(this.unassociated_devices);
        }
        DeviceImpl[] devices = this.manager.getDevices();
        for (final Map.Entry entry : ud.entrySet()) {
            InetAddress address = (InetAddress)entry.getKey();
            boolean already_assoc = false;
            DeviceImpl[] deviceImplArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceImpl d = deviceImplArray[n2];
                if (d instanceof DeviceMediaRendererImpl) {
                    DeviceMediaRendererImpl r = (DeviceMediaRendererImpl)d;
                    InetAddress device_address = r.getAddress();
                    if (d.isAlive() && device_address != null && device_address.equals(address)) {
                        already_assoc = true;
                        break;
                    }
                }
                ++n2;
            }
            if (already_assoc) continue;
            result.add(new DeviceManager.UnassociatedDevice(){

                @Override
                public InetAddress getAddress() {
                    return (InetAddress)entry.getKey();
                }

                @Override
                public String getDescription() {
                    return (String)entry.getValue();
                }
            });
        }
        return result.toArray(new DeviceManager.UnassociatedDevice[result.size()]);
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected IPCInterface getUPnPAVIPC() {
        return this.upnpav_ipc;
    }

    public void search() {
        if (this.upnp != null) {
            UPnPRootDevice[] devices;
            UPnPRootDevice[] uPnPRootDeviceArray = devices = this.upnp.getRootDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                UPnPRootDevice device = uPnPRootDeviceArray[n2];
                this.handleDevice(device, false);
                ++n2;
            }
            String[] STs = new String[]{"upnp:rootdevice", "urn:schemas-upnp-org:device:MediaRenderer:1", "urn:schemas-upnp-org:service:ContentDirectory:1"};
            this.upnp.search(STs);
        }
    }

    protected void handleXBox(InetSocketAddress address) {
        DeviceImpl[] devices = this.manager.getDevices();
        boolean found = false;
        DeviceImpl[] deviceImplArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceImpl device = deviceImplArray[n2];
            if (device instanceof DeviceMediaRendererImpl) {
                DeviceMediaRendererImpl renderer = (DeviceMediaRendererImpl)device;
                if (device.getRendererSpecies() == 2) {
                    found = true;
                    if (!device.isAlive()) {
                        renderer.setAddress(address.getAddress());
                        device.alive();
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            this.manager.addDevice(new DeviceMediaRendererImpl(this.manager, "Xbox 360"));
        }
    }

    protected void handlePS3(InetSocketAddress address) {
        this.handleGeneric(address, "ps3", "PS3");
    }

    protected void handleWii(InetSocketAddress address) {
        this.handleGeneric(address, "wii", "Wii");
    }

    protected void handleBrowser(InetSocketAddress address) {
        this.handleGeneric(address, "browser", "Browser");
    }

    protected DeviceMediaRenderer handleVuzeMSBrowser(InetSocketAddress address, String info) {
        String[] bits = info.split(";");
        String client = "";
        String[] stringArray = bits;
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String bit = stringArray[n2];
            String[] temp = bit.split("=");
            if (temp.length == 2 && temp[0].trim().equalsIgnoreCase("mn")) {
                client = temp[1].trim();
                if (client.startsWith("\"")) {
                    client = client.substring(1);
                }
                if (client.endsWith("\"")) {
                    client = client.substring(0, client.length() - 1);
                }
            }
            ++n2;
        }
        if (client.length() == 0) {
            client = "Vuze on " + address.getAddress().getHostAddress();
        }
        DeviceMediaRenderer result = this.handleGeneric(address, "vuze-ms-browser." + client, client);
        result.setTranscodeRequirement(1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceMediaRenderer handleGeneric(InetSocketAddress address, String unique_name, String display_name) {
        String uid;
        DeviceManagerUPnPImpl deviceManagerUPnPImpl = this;
        synchronized (deviceManagerUPnPImpl) {
            String un_key;
            try {
                un_key = Base32.encode(unique_name.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                un_key = Base32.encode(unique_name.getBytes());
            }
            String new_key = "devices.upnp.uid2." + un_key;
            uid = COConfigurationManager.getStringParameter(new_key, "");
            if (uid.length() == 0) {
                String old_key = "devices.upnp.uid." + unique_name;
                uid = COConfigurationManager.getStringParameter(old_key, "");
                if (uid.length() > 0) {
                    COConfigurationManager.setParameter(new_key, uid);
                    COConfigurationManager.removeParameter(old_key);
                } else {
                    uid = UUIDGenerator.generateUUIDString();
                    COConfigurationManager.setParameter(new_key, uid);
                    COConfigurationManager.save();
                }
            }
        }
        DeviceMediaRendererImpl newDevice = new DeviceMediaRendererImpl(this.manager, uid, unique_name, false, display_name);
        DeviceMediaRendererImpl device = (DeviceMediaRendererImpl)this.manager.addDevice(newDevice);
        device.setPersistentBooleanProperty("rend_no_ah", true);
        device.setAddress(address.getAddress());
        device.alive();
        return device;
    }

    protected void handleDevice(UPnPRootDevice root_device, boolean update_if_found) {
        if (!this.manager.getAutoSearch() && !this.manager.isExplicitSearch()) {
            return;
        }
        this.handleDevice(root_device.getDevice(), update_if_found);
    }

    protected void handleDevice(UPnPDevice device, boolean update_if_found) {
        UPnPService[] services = device.getServices();
        ArrayList<DeviceUPnPImpl> new_devices = new ArrayList<DeviceUPnPImpl>();
        ArrayList<UPnPWANConnection> igd_services = new ArrayList<UPnPWANConnection>();
        Object[] objectArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            UPnPService service = objectArray[n2];
            String service_type = service.getServiceType();
            if (GeneralUtils.startsWithIgnoreCase(service_type, "urn:schemas-upnp-org:service:WANIPConnection:") || GeneralUtils.startsWithIgnoreCase(service_type, "urn:schemas-upnp-org:service:WANPPPConnection:")) {
                UPnPWANConnection wan_service = (UPnPWANConnection)service.getSpecificService();
                igd_services.add(wan_service);
            } else if (GeneralUtils.startsWithIgnoreCase(service_type, "urn:schemas-upnp-org:service:ContentDirectory:")) {
                new_devices.add(new DeviceContentDirectoryImpl(this.manager, device, service));
            }
            ++n2;
        }
        if (igd_services.size() > 0) {
            new_devices.add(new DeviceInternetGatewayImpl(this.manager, device, igd_services));
        }
        if (GeneralUtils.startsWithIgnoreCase(device.getDeviceType(), "urn:schemas-upnp-org:device:MediaRenderer:")) {
            new_devices.add(new DeviceMediaRendererImpl(this.manager, device));
        }
        for (DeviceUPnPImpl new_device : new_devices) {
            UPnPRootDevice existing_root;
            DeviceImpl existing = this.manager.getDevice(new_device.getID());
            final DeviceImpl actual_device = !update_if_found && existing != null ? existing : this.manager.addDevice(new_device);
            UPnPRootDevice current_root = device.getRootDevice();
            if (current_root == (existing_root = (UPnPRootDevice)actual_device.getTransientProperty(KEY_ROOT_DEVICE))) continue;
            actual_device.setTransientProperty(KEY_ROOT_DEVICE, current_root);
            current_root.addListener(new UPnPRootDeviceListener(){

                @Override
                public void lost(UPnPRootDevice root, boolean replaced) {
                    if (!replaced) {
                        actual_device.dead();
                    }
                }
            });
        }
        objectArray = device.getSubDevices();
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object d = objectArray[n3];
            this.handleDevice((UPnPDevice)d, update_if_found);
            ++n3;
        }
    }
}

