/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceManagerListener;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.DeviceTemplate;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceMediaRendererManual;
import com.biglybt.core.drivedetector.DriveDetectedInfo;
import com.biglybt.core.drivedetector.DriveDetectedListener;
import com.biglybt.core.drivedetector.DriveDetectorFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DeviceDriveManager
implements DriveDetectedListener {
    private DeviceManagerImpl manager;
    Map<String, DeviceMediaRendererManual> device_map = new HashMap<String, DeviceMediaRendererManual>();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();
    boolean listener_added;

    protected DeviceDriveManager(DeviceManagerImpl _manager) {
        this.manager = _manager;
        this.manager.addListener(new DeviceManagerListener(){

            @Override
            public void deviceAdded(Device device) {
            }

            @Override
            public void deviceChanged(Device device) {
            }

            @Override
            public void deviceAttentionRequest(Device device) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deviceRemoved(Device device) {
                Map<String, DeviceMediaRendererManual> map = DeviceDriveManager.this.device_map;
                synchronized (map) {
                    Iterator<Map.Entry<String, DeviceMediaRendererManual>> it = DeviceDriveManager.this.device_map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, DeviceMediaRendererManual> entry = it.next();
                        if (entry.getValue() != device) continue;
                        it.remove();
                    }
                }
            }

            @Override
            public void deviceManagerLoaded() {
            }
        });
        if (this.manager.getAutoSearch()) {
            this.listener_added = true;
            DriveDetectorFactory.getDeviceDetector().addListener(this);
        }
    }

    protected void search() {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                if (DeviceDriveManager.this.listener_added) {
                    DriveDetectedInfo[] info;
                    DriveDetectedInfo[] driveDetectedInfoArray = info = DriveDetectorFactory.getDeviceDetector().getDetectedDriveInfo();
                    int n = info.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DriveDetectedInfo i = driveDetectedInfoArray[n2];
                        DeviceDriveManager.this.driveRemoved(i);
                        DeviceDriveManager.this.driveDetected(i);
                        ++n2;
                    }
                    return;
                }
                try {
                    DriveDetectorFactory.getDeviceDetector().addListener(DeviceDriveManager.this);
                }
                finally {
                    DriveDetectorFactory.getDeviceDetector().removeListener(DeviceDriveManager.this);
                }
            }
        });
    }

    @Override
    public void driveDetected(final DriveDetectedInfo info) {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                File[] folders;
                Map<String, Object> infoMap = info.getInfoMap();
                boolean isWritableUSB = MapUtils.getMapBoolean(infoMap, "isWritableUSB", false);
                File root = info.getLocation();
                String sProdID = MapUtils.getMapString(infoMap, "ProductID", MapUtils.getMapString(infoMap, "Product Name", "")).trim();
                String sVendor = MapUtils.getMapString(infoMap, "VendorID", MapUtils.getMapString(infoMap, "Vendor Name", "")).trim();
                if (sVendor.equalsIgnoreCase("htc") && sProdID.equalsIgnoreCase("android phone") || sVendor.toLowerCase().contains("motorola") && sProdID.length() > 0 || sVendor.equalsIgnoreCase("samsung")) {
                    String name;
                    if (isWritableUSB && sVendor.equalsIgnoreCase("samsung")) {
                        isWritableUSB = !sProdID.startsWith("Y") && sProdID.matches(".*[A-Z]-.*");
                    }
                    String string = name = sProdID.startsWith(sVendor) ? "" : sVendor;
                    if (sVendor.length() > 0) {
                        name = String.valueOf(name) + " ";
                    }
                    name = String.valueOf(name) + sProdID;
                    String id = "android.";
                    id = String.valueOf(id) + sProdID.replaceAll(" ", ".").toLowerCase();
                    if (sVendor.length() > 0) {
                        id = String.valueOf(id) + "." + sVendor.replaceAll(" ", ".").toLowerCase();
                    }
                    if (isWritableUSB) {
                        DeviceDriveManager.this.addDevice(name, id, root, new File(root, "videos"), true);
                    } else {
                        DeviceMediaRenderer existingDevice = DeviceDriveManager.this.getDeviceMediaRendererByClassification(id);
                        if (existingDevice != null) {
                            existingDevice.remove();
                        }
                    }
                    return;
                }
                if (isWritableUSB && sVendor.toLowerCase().equals("rim")) {
                    DeviceMediaRendererManual device;
                    String name = sVendor;
                    if (name.length() > 0) {
                        name = String.valueOf(name) + " ";
                    }
                    name = String.valueOf(name) + sProdID;
                    String id = "";
                    id = String.valueOf(id) + sProdID.replaceAll(" ", ".").toLowerCase();
                    if (sVendor.length() > 0) {
                        id = String.valueOf(id) + "." + sVendor.replaceAll(" ", ".").toLowerCase();
                    }
                    if ((device = DeviceDriveManager.this.addDevice(name, id, root, new File(root, "videos"), false)) != null) {
                        device.setImageID("bb");
                    }
                    return;
                }
                if (!isWritableUSB) {
                    return;
                }
                if (root.exists() && (folders = root.listFiles()) != null) {
                    HashSet<String> names = new HashSet<String>();
                    File[] fileArray = folders;
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        names.add(file.getName().toLowerCase());
                        ++n2;
                    }
                    if (names.contains("psp") && names.contains("video")) {
                        DeviceDriveManager.this.addDevice("PSP", "sony.PSP", root, new File(root, "VIDEO"), false);
                        return;
                    }
                }
                String pid = MapUtils.getMapString(infoMap, "PID", null);
                String vid = MapUtils.getMapString(infoMap, "VID", null);
                if (pid != null && vid != null) {
                    String name;
                    String string = name = sProdID.startsWith(sVendor) ? "" : sVendor;
                    if (name.length() > 0) {
                        name = String.valueOf(name) + " ";
                    }
                    name = String.valueOf(name) + sProdID;
                    String id = "";
                    id = String.valueOf(id) + sProdID.replaceAll(" ", ".").toLowerCase();
                    id = String.valueOf(id) + "." + pid.toLowerCase();
                    if (sVendor.length() > 0) {
                        id = String.valueOf(id) + "." + sVendor.replaceAll(" ", ".").toLowerCase();
                    }
                    if (((id = String.valueOf(id) + "." + vid.toLowerCase()).equals("\"psp\".ms.02d2.sony.054c") || id.equals("\"psp\".ms.0381.sony.054c")) && DeviceDriveManager.this.addDevice("PSP", "sony.PSP", root, new File(root, "VIDEO"), false) != null) {
                        return;
                    }
                    DeviceDriveManager.this.addDevice(name, id, root, new File(root, "video"), true);
                }
            }
        });
    }

    protected DeviceMediaRenderer getDeviceMediaRendererByClassification(String target_classification) {
        DeviceImpl[] devices;
        DeviceImpl[] deviceImplArray = devices = this.manager.getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceMediaRenderer renderer;
            String classification;
            DeviceImpl device = deviceImplArray[n2];
            if (device instanceof DeviceMediaRenderer && (classification = (renderer = (DeviceMediaRenderer)((Object)device)).getClassification()).equalsIgnoreCase(target_classification)) {
                return renderer;
            }
            ++n2;
        }
        return null;
    }

    protected DeviceMediaRendererManual addDevice(String target_name, String target_classification, File root, File target_directory, boolean generic) {
        DeviceMediaRenderer existingDevice = this.getDeviceMediaRendererByClassification(target_classification);
        if (existingDevice instanceof DeviceMediaRendererManual) {
            this.mapDevice((DeviceMediaRendererManual)existingDevice, root, target_directory);
            existingDevice.setGenericUSB(generic);
            return (DeviceMediaRendererManual)existingDevice;
        }
        DeviceTemplate[] templates = this.manager.getDeviceTemplates(3);
        DeviceMediaRendererManual renderer = null;
        DeviceTemplate[] deviceTemplateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTemplate template = deviceTemplateArray[n2];
            if (template.getClassification().equalsIgnoreCase(target_classification)) {
                try {
                    renderer = (DeviceMediaRendererManual)template.createInstance(target_name);
                    break;
                }
                catch (Throwable e) {
                    this.log("Failed to add device", e);
                }
            }
            ++n2;
        }
        if (renderer == null) {
            try {
                renderer = (DeviceMediaRendererManual)this.manager.createDevice(3, null, target_classification, target_name, true);
            }
            catch (Throwable e) {
                this.log("Failed to add device", e);
            }
        }
        if (renderer != null) {
            try {
                renderer.setAutoCopyToFolder(true);
                renderer.setGenericUSB(generic);
                this.mapDevice(renderer, root, target_directory);
                return renderer;
            }
            catch (Throwable e) {
                this.log("Failed to add device", e);
            }
        }
        return renderer;
    }

    @Override
    public void driveRemoved(final DriveDetectedInfo info) {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                DeviceDriveManager.this.unMapDevice(info.getLocation());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapDevice(DeviceMediaRendererManual renderer, File root, File copy_to) {
        DeviceMediaRendererManual existing;
        Map<String, DeviceMediaRendererManual> map = this.device_map;
        synchronized (map) {
            existing = this.device_map.put(root.getAbsolutePath(), renderer);
        }
        if (existing != null && existing != renderer) {
            this.log("Unmapped " + existing.getName() + " from " + root);
            existing.setCopyToFolder(null);
        }
        this.log("Mapped " + renderer.getName() + " to " + root);
        renderer.setCopyToFolder(copy_to);
        renderer.setLivenessDetectable(true);
        renderer.alive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unMapDevice(File root) {
        DeviceMediaRendererManual existing;
        Map<String, DeviceMediaRendererManual> map = this.device_map;
        synchronized (map) {
            existing = this.device_map.remove(root.getAbsolutePath());
        }
        if (existing != null) {
            this.log("Unmapped " + existing.getName() + " from " + root);
            existing.setCopyToFolder(null);
            existing.dead();
        }
    }

    protected void log(String str) {
        this.manager.log("DriveMan: " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("DriveMan: " + str, e);
    }
}

