/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.content;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.content.ContentException;
import com.biglybt.core.content.RelatedAttributeLookupListener;
import com.biglybt.core.content.RelatedContent;
import com.biglybt.core.content.RelatedContentLookupListener;
import com.biglybt.core.content.RelatedContentManagerListener;
import com.biglybt.core.content.RelatedContentSearcher;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateFactory;
import com.biglybt.core.proxy.impl.AEPluginProxyHandler;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FeatureAvailability;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.ddb.DistributedDatabaseTransferType;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.utils.search.SearchException;
import com.biglybt.pif.utils.search.SearchInstance;
import com.biglybt.pif.utils.search.SearchObserver;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.ddb.DDBaseImpl;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginInterface;
import com.biglybt.plugin.dht.DHTPluginOperationListener;
import com.biglybt.plugin.dht.DHTPluginValue;
import com.biglybt.util.MapUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RelatedContentManager {
    public static final long FILE_ASSOC_MIN_SIZE = 0x3200000L;
    public static final int RCM_SEARCH_PROPERTY_TRACKER_KEYS = 50001;
    public static final int RCM_SEARCH_PROPERTY_WEB_SEED_KEYS = 50002;
    public static final int RCM_SEARCH_PROPERTY_TAGS = 50003;
    public static final int RCM_SEARCH_PROPERTY_NETWORKS = 50004;
    private static final boolean TRACE = false;
    private static final int MAX_HISTORY = 16;
    private static final int MAX_TITLE_LENGTH = 80;
    private static final int MAX_CONCURRENT_PUBLISH;
    private static final boolean DISABLE_PUBLISHING;
    private static boolean prefer_i2p;
    private static final int TEMPORARY_SPACE_DELTA = 50;
    private static final int MAX_RANK = 100;
    private static final String CONFIG_FILE = "rcm.config";
    private static final String PERSIST_DEL_FILE = "rcmx.config";
    private static final String CONFIG_TOTAL_UNREAD = "rcm.numunread.cache";
    private static RelatedContentManager singleton;
    private static Core core;
    protected static final int TIMER_PERIOD = 30000;
    private static final int CONFIG_SAVE_CHECK_PERIOD = 60000;
    private static final int CONFIG_SAVE_PERIOD = 300000;
    private static final int CONFIG_SAVE_CHECK_TICKS = 2;
    private static final int CONFIG_SAVE_TICKS = 10;
    private static final int PUBLISH_CHECK_PERIOD = 30000;
    private static final int PUBLISH_CHECK_TICKS = 1;
    private static final int PUBLISH_SLEEPING_CHECK_PERIOD = 300000;
    private static final int PUBLISH_SLEEPING_CHECK_TICKS = 10;
    private static final int SECONDARY_LOOKUP_PERIOD = 900000;
    private static final int SECONDARY_LOOKUP_TICKS = 30;
    private static final int REPUBLISH_PERIOD = 28800000;
    private static final int REPUBLISH_TICKS = 960;
    private static final int I2P_SEARCHER_CHECK_PERIOD = 600000;
    private static final int I2P_SEARCHER_CHECK_TICKS = 20;
    private static final int INITIAL_PUBLISH_DELAY = 180000;
    private static final int INITIAL_PUBLISH_TICKS = 6;
    private static final int CONFIG_DISCARD_MILLIS = 60000;
    protected static final byte NET_NONE = 0;
    protected static final byte NET_PUBLIC = 1;
    protected static final byte NET_I2P = 2;
    protected static final byte NET_TOR = 4;
    private static final String[] NET_PUBLIC_ARRAY;
    private static final String[] NET_I2P_ARRAY;
    private static final String[] NET_TOR_ARRAY;
    private static final String[] NET_PUBLIC_AND_I2P_ARRAY;
    protected final Object rcm_lock = new Object();
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_category;
    private DHTPluginInterface public_dht_plugin;
    private volatile Map<Byte, DHTPluginInterface> i2p_dht_plugin_map = new HashMap<Byte, DHTPluginInterface>();
    private TagManager tag_manager;
    private long global_random_id = -1L;
    private LinkedList<DownloadInfo> pub_download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> pub_download_infos2 = new LinkedList();
    private LinkedList<DownloadInfo> non_pub_download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> non_pub_download_infos2 = new LinkedList();
    private ByteArrayHashMapEx<DownloadInfo> download_info_map = new ByteArrayHashMapEx();
    private Set<String> download_priv_set = new HashSet<String>();
    private final boolean enabled;
    private int max_search_level;
    private int max_results;
    private boolean global_filter_active_only;
    private AtomicInteger temporary_space = new AtomicInteger();
    private int publishing_count = 0;
    CopyOnWriteList<RelatedContentManagerListener> listeners = new CopyOnWriteList();
    AESemaphore initialisation_complete_sem = new AESemaphore("RCM:init");
    private ContentCache content_cache_ref;
    private WeakReference<ContentCache> content_cache;
    private boolean content_dirty;
    private long last_config_access;
    private int content_discard_ticks;
    private AtomicInteger total_unread = new AtomicInteger(COConfigurationManager.getIntParameter("rcm.numunread.cache", 0));
    private AsyncDispatcher content_change_dispatcher = new AsyncDispatcher();
    private static final int SECONDARY_LOOKUP_CACHE_MAX = 10;
    LinkedList<SecondaryLookup> secondary_lookups = new LinkedList();
    boolean secondary_lookup_in_progress;
    long secondary_lookup_complete_time;
    RCMSearchXFer transfer_type = new RCMSearchXFer();
    final CopyOnWriteList<RelatedContentSearcher> searchers = new CopyOnWriteList();
    private boolean added_i2p_searcher;
    private RelatedContentSearcher mix_searcher;
    private static final int MAX_TRANSIENT_CACHE = 256;
    protected static Map<String, DownloadInfo> transient_info_cache;
    boolean persist;
    private boolean last_pub_was_pub;
    private static final int MAX_TAG_LENGTH = 20;
    private static final int MAX_TAGS_TOTAL_LENGTH = 64;
    private static final int PD_BLOOM_INITIAL_SIZE = 1000;
    private static final int PD_BLOOM_INCREMENT_SIZE = 1000;
    private BloomFilter persist_del_bloom;

    static {
        int max_conc_pub = 2;
        DISABLE_PUBLISHING = System.getProperty(SystemProperties.SYSPROP_RCM_PUBLISH_DISABLE, "0").equals("1");
        try {
            max_conc_pub = Integer.parseInt(System.getProperty(SystemProperties.SYSPROP_RCM_MAX_CONCURRENT_PUBLISH, "" + max_conc_pub));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        MAX_CONCURRENT_PUBLISH = max_conc_pub;
        COConfigurationManager.addAndFireParameterListener("Plugin.DHT.dht.prefer.i2p", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                prefer_i2p = COConfigurationManager.getBooleanParameter(name, false);
            }
        });
        NET_PUBLIC_ARRAY = new String[]{"Public"};
        NET_I2P_ARRAY = new String[]{"I2P"};
        NET_TOR_ARRAY = new String[]{"Tor"};
        NET_PUBLIC_AND_I2P_ARRAY = new String[]{"Public", "I2P"};
        transient_info_cache = new LinkedHashMap<String, DownloadInfo>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, DownloadInfo> eldest) {
                return this.size() > 256;
            }
        };
    }

    public static synchronized void preInitialise(Core _core) {
        core = _core;
    }

    public static synchronized RelatedContentManager getSingleton() throws ContentException {
        if (singleton == null) {
            singleton = new RelatedContentManager();
        }
        return singleton;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RelatedContentManager() throws ContentException {
        COConfigurationManager.addAndFireParameterListener("rcm.persist", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                COConfigurationManager.getBooleanParameter("rcm.persist");
                RelatedContentManager.this.persist = true;
            }
        });
        COConfigurationManager.removeParameter("rcm.dlinfo.history");
        COConfigurationManager.addAndFireParameterListeners(new String[]{"rcm.ui.enabled", "rcm.max_search_level", "rcm.max_results", "rcm.global.filter.active_only"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                RelatedContentManager.this.max_search_level = COConfigurationManager.getIntParameter("rcm.max_search_level", 3);
                RelatedContentManager.this.max_results = COConfigurationManager.getIntParameter("rcm.max_results", 500);
                RelatedContentManager.this.global_filter_active_only = COConfigurationManager.getBooleanParameter("rcm.global.filter.active_only", false);
            }
        });
        if (!FeatureAvailability.isRCMEnabled() || !COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true)) {
            this.enabled = false;
            this.deleteRelatedContent();
            this.initialisation_complete_sem.releaseForever();
            return;
        }
        this.enabled = true;
        try {
            if (core == null) {
                throw new ContentException("getSingleton called before pre-initialisation");
            }
            while (true) {
                if (this.global_random_id != -1L) {
                    this.plugin_interface = core.getPluginManager().getDefaultPluginInterface();
                    this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
                    this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
                    this.tag_manager = TagManagerFactory.getTagManager();
                    this.plugin_interface.getUtilities().createDelayedTask(new AERunnable(){

                        @Override
                        public void runSupport() {
                            SimpleTimer.addEvent("rcm.delay.init", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                                @Override
                                public void perform(TimerEvent event2) {
                                    RelatedContentManager.this.delayedInit();
                                }
                            });
                        }
                    }).queue();
                    return;
                }
                this.global_random_id = COConfigurationManager.getLongParameter("rcm.random.id", -1L);
                if (this.global_random_id != -1L) continue;
                this.global_random_id = RandomUtils.nextLong();
                COConfigurationManager.setParameter("rcm.random.id", this.global_random_id);
            }
        }
        catch (Throwable e) {
            this.initialisation_complete_sem.releaseForever();
            if (!(e instanceof ContentException)) throw new ContentException("Initialisation failed", e);
            throw (ContentException)e;
        }
    }

    void delayedInit() {
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                if (!RelatedContentManager.this.persist) {
                    RelatedContentManager.this.deleteRelatedContent();
                }
                try {
                    PluginInterface dht_pi = RelatedContentManager.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi != null) {
                        DHTPlugin dp = (DHTPlugin)dht_pi.getPlugin();
                        RelatedContentManager.this.public_dht_plugin = dp;
                        RelatedContentSearcher public_searcher = new RelatedContentSearcher(RelatedContentManager.this, RelatedContentManager.this.transfer_type, dp, true);
                        RelatedContentManager.this.searchers.add(public_searcher);
                        DownloadManager dm = RelatedContentManager.this.plugin_interface.getDownloadManager();
                        Download[] downloads = dm.getDownloads();
                        RelatedContentManager.this.addDownloads(downloads, true);
                        dm.addListener(new DownloadManagerListener(){

                            @Override
                            public void downloadAdded(Download download) {
                                RelatedContentManager.this.addDownloads(new Download[]{download}, false);
                            }

                            @Override
                            public void downloadRemoved(Download download) {
                            }
                        }, false);
                        SimpleTimer.addPeriodicEvent("RCM:publisher", 30000L, new TimerEventPerformer(){
                            private int tick_count;

                            @Override
                            public void perform(TimerEvent event2) {
                                ++this.tick_count;
                                if (this.tick_count == 1 || this.tick_count % 20 == 0) {
                                    RelatedContentManager.this.checkI2PSearcher(false);
                                }
                                if (RelatedContentManager.this.enabled && this.tick_count >= 6) {
                                    if (this.tick_count % (RelatedContentManager.this.public_dht_plugin.isSleeping() ? 10 : 1) == 0) {
                                        RelatedContentManager.this.publish();
                                    }
                                    if (this.tick_count % 30 == 0) {
                                        RelatedContentManager.this.secondaryLookup();
                                    }
                                    if (this.tick_count % 960 == 0) {
                                        RelatedContentManager.this.republish();
                                    }
                                    if (this.tick_count % 2 == 0) {
                                        RelatedContentManager.this.saveRelatedContent(this.tick_count);
                                    }
                                }
                                for (RelatedContentSearcher searcher : (this).RelatedContentManager.this.searchers) {
                                    searcher.timerTick(RelatedContentManager.this.enabled, this.tick_count);
                                }
                            }
                        });
                    }
                }
                finally {
                    RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                }
            }

            @Override
            public void closedownInitiated() {
                RelatedContentManager.this.saveRelatedContent(0);
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkI2PSearcher(boolean force) {
        CopyOnWriteList<RelatedContentSearcher> copyOnWriteList = this.searchers;
        synchronized (copyOnWriteList) {
            if (this.added_i2p_searcher) {
                return;
            }
            if (!force) {
                DownloadManager dm = this.plugin_interface.getDownloadManager();
                Download[] downloads = dm.getDownloads();
                boolean found = false;
                Download[] downloadArray = downloads;
                int n = downloads.length;
                int n2 = 0;
                while (n2 < n) {
                    Download download = downloadArray[n2];
                    String[] nets = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
                    if (nets.length == 1 && nets[0] == "I2P") {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    return;
                }
            }
            List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(new String[]{"I2P"});
            for (DistributedDatabase ddb : ddbs) {
                if (ddb.getNetwork() != "I2P") continue;
                DHTPluginInterface i2p_dht = ddb.getDHTPlugin();
                RelatedContentSearcher i2p_searcher = new RelatedContentSearcher(this, this.transfer_type, i2p_dht, false);
                this.searchers.add(i2p_searcher);
                this.added_i2p_searcher = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelatedContentSearcher checkMixSearcher() {
        CopyOnWriteList<RelatedContentSearcher> copyOnWriteList = this.searchers;
        synchronized (copyOnWriteList) {
            if (this.mix_searcher == null) {
                List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(new String[]{"Public", "I2P"});
                for (DistributedDatabase ddb : ddbs) {
                    if (ddb.getNetwork() != "I2P") continue;
                    DHTPluginInterface i2p_mix_dht = ddb.getDHTPlugin();
                    this.mix_searcher = new RelatedContentSearcher(this, this.transfer_type, i2p_mix_dht, false);
                }
            }
            return this.mix_searcher;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSearchLevel() {
        return this.max_search_level;
    }

    public void setMaxSearchLevel(int _level) {
        COConfigurationManager.setParameter("rcm.max_search_level", _level);
    }

    public int getMaxResults() {
        return this.max_results;
    }

    public void setMaxResults(int _max) {
        COConfigurationManager.setParameter("rcm.max_results", _max);
        this.enforceMaxResults(false);
    }

    public boolean getFilterActiveOnly() {
        return this.global_filter_active_only;
    }

    public void setFilterActiveOnly(boolean b) {
        this.global_filter_active_only = b;
        COConfigurationManager.setParameter("rcm.global.filter.active_only", b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTPluginInterface selectDHT(byte networks) {
        DHTPluginInterface result = null;
        if (!((networks & 1) == 0 || prefer_i2p && (networks & 2) != 0)) {
            result = this.public_dht_plugin;
        } else if ((networks & 2) != 0) {
            Map<Byte, DHTPluginInterface> map = this.i2p_dht_plugin_map;
            synchronized (map) {
                result = this.i2p_dht_plugin_map.get(networks);
                if (result == null && !this.i2p_dht_plugin_map.containsKey(networks)) {
                    try {
                        List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(RelatedContentManager.convertNetworks(networks));
                        for (DistributedDatabase ddb : ddbs) {
                            if (ddb.getNetwork() != "I2P") continue;
                            result = ddb.getDHTPlugin();
                        }
                    }
                    finally {
                        this.i2p_dht_plugin_map.put(networks, result);
                    }
                }
            }
        }
        if (result != null && !result.isEnabled()) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloads(Download[] downloads, boolean initialising) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ArrayList<DownloadInfo> new_info = new ArrayList<DownloadInfo>(downloads.length);
            Download[] downloadArray = downloads;
            int n = downloads.length;
            int n2 = 0;
            while (n2 < n) {
                Download download = downloadArray[n2];
                try {
                    DownloadManagerState state;
                    TOTorrent to_torrent;
                    byte nets;
                    byte[] hash;
                    Torrent torrent;
                    if (!(!download.isPersistent() || (torrent = download.getTorrent()) == null || this.download_info_map.containsKey(hash = torrent.getHash()) || (nets = this.getNetworks(download)) == 0 || TorrentUtils.isReallyPrivate(to_torrent = PluginCoreUtils.unwrap(torrent)) || TorrentUtils.getFlag(to_torrent, 4) || (state = PluginCoreUtils.unwrap(download).getDownloadState()).getFlag(16L) || state.getFlag(512L) || to_torrent.getTorrentType() == 2 && to_torrent.getEffectiveTorrentType() == 3)) {
                        int seeds_leechers;
                        LinkedList<DownloadInfo> download_infos2;
                        LinkedList<DownloadInfo> download_infos1;
                        if ((nets & 1) != 0) {
                            download_infos1 = this.pub_download_infos1;
                            download_infos2 = this.pub_download_infos2;
                        } else {
                            download_infos1 = this.non_pub_download_infos1;
                            download_infos2 = this.non_pub_download_infos2;
                        }
                        int version = 0;
                        long rand = this.global_random_id ^ state.getLongParameter("rand");
                        int[] aggregate_seeds_leechers = DownloadManagerStateFactory.getCachedAggregateScrapeSeedsLeechers(state);
                        if (aggregate_seeds_leechers == null) {
                            long cache = state.getLongAttribute("scrapecache");
                            if (cache == -1L) {
                                seeds_leechers = -1;
                            } else {
                                int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                                int leechers = (int)(cache & 0xFFFFFFL);
                                seeds_leechers = seeds << 16 | leechers & 0xFFFF;
                            }
                        } else {
                            version = 1;
                            int seeds = aggregate_seeds_leechers[0];
                            int leechers = aggregate_seeds_leechers[1];
                            seeds_leechers = seeds << 16 | leechers & 0xFFFF;
                        }
                        byte[][] keys = this.getKeys(download);
                        int first_seen = (int)(state.getLongParameter("stats.download.added.time") / 1000L);
                        DownloadInfo info = new DownloadInfo(version, hash, hash, download.getName(), (int)rand, torrent.isPrivate() ? StringInterner.intern(torrent.getAnnounceURL().getHost()) : null, keys[0], keys[1], this.getTags(download), nets, first_seen, 0, false, torrent.getSize(), (int)(to_torrent.getCreationDate() / 3600L), seeds_leechers);
                        new_info.add(info);
                        if (initialising || download_infos1.size() == 0) {
                            download_infos1.add(info);
                        } else {
                            download_infos1.add(RandomUtils.nextInt(download_infos1.size()), info);
                        }
                        download_infos2.add(info);
                        this.download_info_map.put(hash, info);
                        if (info.getTracker() != null) {
                            this.download_priv_set.add(this.getPrivateInfoKey(info));
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                ++n2;
            }
            List history = COConfigurationManager.getListParameter("rcm.dlinfo.history.privx", new ArrayList());
            if (initialising) {
                int padd = 16 - this.download_info_map.size();
                int i = 0;
                while (i < history.size() && padd > 0) {
                    try {
                        DownloadInfo info = this.deserialiseDI((Map)history.get(i), null);
                        if (info != null && !this.download_info_map.containsKey(info.getHash())) {
                            byte nets;
                            this.download_info_map.put(info.getHash(), info);
                            if (info.getTracker() != null) {
                                this.download_priv_set.add(this.getPrivateInfoKey(info));
                            }
                            if ((nets = info.getNetworksInternal()) != 0) {
                                if ((nets & 1) != 0) {
                                    this.pub_download_infos1.add(info);
                                    this.pub_download_infos2.add(info);
                                } else {
                                    this.non_pub_download_infos1.add(info);
                                    this.non_pub_download_infos2.add(info);
                                }
                                --padd;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
                Collections.shuffle(this.pub_download_infos1);
                Collections.shuffle(this.non_pub_download_infos1);
            } else if (new_info.size() > 0) {
                final ArrayList<String> base32_hashes = new ArrayList<String>();
                for (DownloadInfo info : new_info) {
                    Map<String, Object> map;
                    byte[] hash = info.getHash();
                    if (hash != null) {
                        base32_hashes.add(Base32.encode(hash));
                    }
                    if ((map = this.serialiseDI(info, null)) == null) continue;
                    history.add(map);
                }
                while (history.size() > 16) {
                    history.remove(0);
                }
                COConfigurationManager.setParameter("rcm.dlinfo.history.privx", history);
                if (base32_hashes.size() > 0) {
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void runSupport() {
                            ArrayList<DownloadInfo> to_remove = new ArrayList<DownloadInfo>();
                            Object object = RelatedContentManager.this.rcm_lock;
                            synchronized (object) {
                                ContentCache content_cache = RelatedContentManager.this.loadRelatedContent();
                                for (String h : base32_hashes) {
                                    DownloadInfo di = content_cache.related_content.get(h);
                                    if (di == null) continue;
                                    to_remove.add(di);
                                }
                            }
                            if (to_remove.size() > 0) {
                                RelatedContentManager.this.delete(to_remove.toArray(new RelatedContent[to_remove.size()]));
                            }
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void republish() {
        if (DISABLE_PUBLISHING) {
            return;
        }
        Object object = this.rcm_lock;
        synchronized (object) {
            List list;
            if (this.publishing_count > 0) {
                return;
            }
            if (this.pub_download_infos1.isEmpty() || this.pub_download_infos1.size() == 1 && this.pub_download_infos1.getFirst() == this.pub_download_infos2.getFirst()) {
                this.pub_download_infos1.clear();
                this.pub_download_infos2.clear();
                list = this.download_info_map.values();
                for (DownloadInfo info : list) {
                    if ((info.getNetworksInternal() & 1) == 0) continue;
                    this.pub_download_infos1.add(info);
                    this.pub_download_infos2.add(info);
                }
                Collections.shuffle(this.pub_download_infos1);
            }
            if (this.non_pub_download_infos1.isEmpty() || this.non_pub_download_infos1.size() == 1 && this.non_pub_download_infos1.getFirst() == this.non_pub_download_infos2.getFirst()) {
                this.non_pub_download_infos1.clear();
                this.non_pub_download_infos2.clear();
                list = this.download_info_map.values();
                for (DownloadInfo info : list) {
                    byte nets = info.getNetworksInternal();
                    if (nets == 0 || (nets & 1) != 0) continue;
                    this.non_pub_download_infos1.add(info);
                    this.non_pub_download_infos2.add(info);
                }
                Collections.shuffle(this.non_pub_download_infos1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish() {
        if (DISABLE_PUBLISHING) {
            return;
        }
        while (true) {
            DownloadInfo info1 = null;
            DownloadInfo info2 = null;
            Object object = this.rcm_lock;
            synchronized (object) {
                LinkedList<DownloadInfo> download_infos2;
                LinkedList<DownloadInfo> download_infos1;
                if (this.publishing_count >= MAX_CONCURRENT_PUBLISH) {
                    return;
                }
                if (this.download_info_map.size() == 1) {
                    return;
                }
                boolean pub_ok = false;
                if (!(this.pub_download_infos1.isEmpty() || this.pub_download_infos1.size() == 1 && this.pub_download_infos1.getFirst() == this.pub_download_infos2.getFirst())) {
                    pub_ok = true;
                }
                boolean non_pub_ok = false;
                if (!(this.non_pub_download_infos1.isEmpty() || this.non_pub_download_infos1.size() == 1 && this.non_pub_download_infos1.getFirst() == this.non_pub_download_infos2.getFirst())) {
                    non_pub_ok = true;
                }
                if (!pub_ok && !non_pub_ok) {
                    return;
                }
                if (pub_ok && non_pub_ok) {
                    if (this.last_pub_was_pub) {
                        pub_ok = false;
                    }
                    boolean bl = this.last_pub_was_pub = !this.last_pub_was_pub;
                }
                if (pub_ok) {
                    download_infos1 = this.pub_download_infos1;
                    download_infos2 = this.pub_download_infos2;
                } else {
                    download_infos1 = this.non_pub_download_infos1;
                    download_infos2 = this.non_pub_download_infos2;
                }
                if (download_infos1.isEmpty() || this.download_info_map.size() == 1) {
                    return;
                }
                info1 = download_infos1.removeFirst();
                Iterator it = download_infos2.iterator();
                while (it.hasNext()) {
                    info2 = (DownloadInfo)it.next();
                    if (info1 == info2 && download_infos2.size() != 1) continue;
                    it.remove();
                    break;
                }
                if (info1 == info2) {
                    return;
                }
                ++this.publishing_count;
            }
            try {
                if (this.publish(info1, info2)) continue;
                object = this.rcm_lock;
                synchronized (object) {
                    --this.publishing_count;
                    continue;
                }
            }
            catch (Throwable e) {
                Object object2 = this.rcm_lock;
                synchronized (object2) {
                    --this.publishing_count;
                }
                Debug.out(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishNext() {
        Object object = this.rcm_lock;
        synchronized (object) {
            --this.publishing_count;
            if (this.publishing_count < 0) {
                this.publishing_count = 0;
            }
        }
        this.publish();
    }

    private boolean publish(final DownloadInfo from_info, final DownloadInfo to_info) throws Exception {
        final DHTPluginInterface dht_plugin = this.selectDHT(from_info.getNetworksInternal());
        if (dht_plugin == null) {
            return false;
        }
        final String from_hash = ByteFormatter.encodeString(from_info.getHash());
        final String to_hash = ByteFormatter.encodeString(to_info.getHash());
        final byte[] key_bytes = ("az:rcm:assoc:" + from_hash).getBytes("UTF-8");
        String title = to_info.getTitle();
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("d", title);
        map.put("r", new Long(Math.abs(to_info.getRand() % 1000)));
        String tracker = to_info.getTracker();
        if (tracker == null) {
            map.put("h", to_info.getHash());
        } else {
            map.put("t", tracker);
        }
        if (to_info.getLevel() == 0) {
            try {
                Download to_download = to_info.getRelatedToDownload();
                if (to_download != null) {
                    byte nets;
                    String[] _tags;
                    byte[][] keys;
                    long secs;
                    long hours;
                    int version = 0;
                    Torrent torrent = to_download.getTorrent();
                    if (torrent != null && (hours = (secs = torrent.getCreationDate()) / 3600L) > 0L) {
                        map.put("p", new Long(hours));
                    }
                    DownloadManagerState state = PluginCoreUtils.unwrap(to_download).getDownloadState();
                    int leechers = -1;
                    int seeds = -1;
                    int[] aggregate_seeds_leechers = DownloadManagerStateFactory.getCachedAggregateScrapeSeedsLeechers(state);
                    if (aggregate_seeds_leechers == null) {
                        long cache = state.getLongAttribute("scrapecache");
                        if (cache != -1L) {
                            seeds = (int)(cache >> 32 & 0xFFFFFFL);
                            leechers = (int)(cache & 0xFFFFFFL);
                        }
                    } else {
                        seeds = aggregate_seeds_leechers[0];
                        leechers = aggregate_seeds_leechers[1];
                        version = 1;
                    }
                    if (version > 0) {
                        map.put("v", new Long(version));
                    }
                    if (leechers > 0) {
                        map.put("l", new Long(leechers));
                    }
                    if (seeds > 0) {
                        map.put("z", new Long(seeds));
                    }
                    if ((keys = this.getKeys(to_download))[0] != null) {
                        map.put("k", keys[0]);
                    }
                    if (keys[1] != null) {
                        map.put("w", keys[1]);
                    }
                    if ((_tags = this.getTags(to_download)) != null) {
                        map.put("g", this.encodeTags(_tags));
                    }
                    if ((nets = this.getNetworks(to_download)) != 1) {
                        map.put("o", new Long(nets & 0xFF));
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        final Download from_download = from_info.getRelatedToDownload();
        final HashSet my_tags = new HashSet();
        try {
            String[] _tags;
            if (from_download != null && (_tags = this.getTags(from_download)) != null) {
                map.put("b", from_info.getRand() % 100);
                map.put("m", this.encodeTags(_tags));
                Collections.addAll(my_tags, _tags);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        final HashSet my_tags_original = new HashSet(my_tags);
        long size = to_info.getSize();
        if (size != 0L) {
            map.put("s", new Long(size));
        }
        final byte[] map_bytes = BEncoder.encode(map);
        int max_hits = 30;
        dht_plugin.get(key_bytes, "Content rel test: " + from_hash.substring(0, 16), (byte)0, 30, 30000L, false, false, new DHTPluginOperationListener(){
            private boolean diversified;
            private int hits;
            private Set<String> entries = new HashSet<String>();
            private Set<String> discovered_tags = new HashSet<String>();

            @Override
            public void starts(byte[] key) {
            }

            @Override
            public boolean diversified() {
                this.diversified = true;
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                try {
                    DownloadInfo info;
                    block10: {
                        Map<String, Object> map = BDecoder.decode(value.getValue());
                        info = RelatedContentManager.this.decodeInfo(map, from_info.getHash(), 1, false, this.entries);
                        try {
                            Long b;
                            String[] r_tags = RelatedContentManager.this.decodeTags((byte[])map.get("m"));
                            if (r_tags == null || (b = (Long)map.get("b")) != null && (long)(from_info.getRand() % 100) == b % 100L) break block10;
                            String[] stringArray = r_tags;
                            int n = r_tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String tag = stringArray[n2];
                                Set set = my_tags;
                                synchronized (set) {
                                    my_tags.remove(tag);
                                    if (!my_tags_original.contains(tag)) {
                                        this.discovered_tags.add(tag);
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (info != null) {
                        RelatedContentManager.this.analyseResponse(info, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.hits;
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(byte[] key, boolean timeout_occurred) {
                if (from_download != null) {
                    Set set = my_tags;
                    synchronized (set) {
                        if (!this.discovered_tags.isEmpty()) {
                            HashSet<String> interesting = new HashSet<String>();
                            for (String tag : this.discovered_tags) {
                                if (TagUtils.isInternalTagName(tag)) continue;
                                interesting.add(tag);
                            }
                            if (!interesting.isEmpty()) {
                                try {
                                    DownloadManagerState dms = PluginCoreUtils.unwrap(from_download).getDownloadState();
                                    String[] old = dms.getListAttribute("stag");
                                    if (old == null || old.length == 0) {
                                        dms.setListAttribute("stag", interesting.toArray(new String[0]));
                                    } else if (old.length < 16) {
                                        interesting.addAll(Arrays.asList(old));
                                        if (interesting.size() > old.length) {
                                            dms.setListAttribute("stag", interesting.toArray(new String[0]));
                                        }
                                    }
                                }
                                catch (Throwable dms) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                int f_cutoff = my_tags.size() > 0 ? 20 : 10;
                try {
                    boolean do_it;
                    if (this.diversified || this.hits >= f_cutoff) {
                        do_it = false;
                    } else if (this.hits <= f_cutoff / 2) {
                        do_it = true;
                    } else {
                        boolean bl = do_it = RandomUtils.nextInt(this.hits - f_cutoff / 2 + 1) == 0;
                    }
                    if (do_it) {
                        try {
                            dht_plugin.put(key_bytes, "Content rel: " + from_hash.substring(0, 16) + " -> " + to_hash.substring(0, 16), map_bytes, (byte)16, new DHTPluginOperationListener(){

                                @Override
                                public boolean diversified() {
                                    return true;
                                }

                                @Override
                                public void starts(byte[] key) {
                                }

                                @Override
                                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                }

                                @Override
                                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                }

                                @Override
                                public void complete(byte[] key, boolean timeout_occurred) {
                                    RelatedContentManager.this.publishNext();
                                }
                            });
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            RelatedContentManager.this.publishNext();
                        }
                    } else {
                        RelatedContentManager.this.publishNext();
                    }
                }
                finally {
                    RelatedContentManager.this.checkAlternativePubs(to_info, map_bytes, f_cutoff);
                }
            }
        });
        return true;
    }

    void checkAlternativePubs(DownloadInfo to_info, final byte[] map_bytes, final int f_cutoff) {
        Download dl = to_info.getRelatedToDownload();
        if (dl != null) {
            DiskManagerFileInfo[] files = dl.getDiskManagerFileInfo();
            ArrayList<Long> sizes = new ArrayList<Long>();
            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                long size = file.getLength();
                if (size >= 0x3200000L) {
                    sizes.add(size);
                }
                ++n2;
            }
            final DHTPluginInterface dht_plugin = this.selectDHT(to_info.getNetworksInternal());
            if (dht_plugin != null && sizes.size() > 0) {
                try {
                    final String to_hash = ByteFormatter.encodeString(to_info.getHash());
                    final long selected_size = (Long)sizes.get(new Random().nextInt(sizes.size()));
                    final byte[] key_bytes = ("az:rcm:size:assoc:" + selected_size).getBytes("UTF-8");
                    int max_hits = 30;
                    dht_plugin.get(key_bytes, "Content size rel test: " + to_hash.substring(0, 16), (byte)0, max_hits, 30000L, false, false, new DHTPluginOperationListener(){
                        private boolean diversified;
                        private int hits;
                        private Set<String> entries = new HashSet<String>();

                        @Override
                        public void starts(byte[] key) {
                        }

                        @Override
                        public boolean diversified() {
                            this.diversified = true;
                            return false;
                        }

                        @Override
                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                            ++this.hits;
                        }

                        @Override
                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        @Override
                        public void complete(byte[] key, boolean timeout_occurred) {
                            boolean do_it;
                            if (this.diversified || this.hits >= f_cutoff) {
                                do_it = false;
                            } else if (this.hits <= f_cutoff / 2) {
                                do_it = true;
                            } else {
                                boolean bl = do_it = RandomUtils.nextInt(this.hits - f_cutoff / 2 + 1) == 0;
                            }
                            if (do_it) {
                                try {
                                    dht_plugin.put(key_bytes, "Content size rel: " + selected_size + " -> " + to_hash.substring(0, 16), map_bytes, (byte)16, new DHTPluginOperationListener(){

                                        @Override
                                        public boolean diversified() {
                                            return true;
                                        }

                                        @Override
                                        public void starts(byte[] key) {
                                        }

                                        @Override
                                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                        }

                                        @Override
                                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                        }

                                        @Override
                                        public void complete(byte[] key, boolean timeout_occurred) {
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DownloadInfo decodeInfo(Map map, byte[] from_hash, int level, boolean explicit, Set<String> unique_keys) {
        try {
            int n;
            String title = new String((byte[])map.get("d"), "UTF-8");
            String tracker = null;
            byte[] hash = (byte[])map.get("h");
            if (hash == null) {
                tracker = new String((byte[])map.get("t"), "UTF-8");
            }
            int rand = ((Long)map.get("r")).intValue();
            String key = String.valueOf(title) + " % " + rand;
            Set<String> set = unique_keys;
            synchronized (set) {
                if (unique_keys.contains(key)) {
                    return null;
                }
                unique_keys.add(key);
            }
            Long l_version = (Long)map.get("v");
            int version = l_version == null ? 0 : l_version.intValue();
            Long l_size = (Long)map.get("s");
            long size = l_size == null ? 0L : l_size;
            Long published = (Long)map.get("p");
            Long leechers = (Long)map.get("l");
            Long seeds = (Long)map.get("z");
            int seeds_leechers = leechers == null && seeds == null ? -1 : (leechers == null ? seeds.intValue() << 16 : (seeds == null ? leechers.intValue() & 0xFFFF : seeds.intValue() << 16 | leechers.intValue() & 0xFFFF));
            byte[] tracker_keys = (byte[])map.get("k");
            byte[] ws_keys = (byte[])map.get("w");
            if (tracker_keys != null && tracker_keys.length % 4 != 0) {
                tracker_keys = null;
            }
            if (ws_keys != null && ws_keys.length % 4 != 0) {
                ws_keys = null;
            }
            byte[] _tags = (byte[])map.get("g");
            String[] tags = this.decodeTags(_tags);
            Long _nets = (Long)map.get("o");
            byte nets = _nets == null ? (byte)1 : _nets.byteValue();
            int first_seen = (int)(SystemTime.getCurrentTime() / 1000L);
            if (published == null) {
                n = 0;
                return new DownloadInfo(version, from_hash, hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, first_seen, level, explicit, size, n, seeds_leechers);
            }
            n = published.intValue();
            return new DownloadInfo(version, from_hash, hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, first_seen, level, explicit, size, n, seeds_leechers);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void lookupAttributes(byte[] from_hash, RelatedAttributeLookupListener listener) throws ContentException {
        this.lookupAttributes(from_hash, new String[]{"Public"}, listener);
    }

    public void lookupAttributes(final byte[] from_hash, final String[] networks, final RelatedAttributeLookupListener listener) throws ContentException {
        if (from_hash == null) {
            throw new ContentException("hash is null");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupAttributesSupport(from_hash, RelatedContentManager.convertNetworks(networks), listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupAttributesSupport(from_hash, RelatedContentManager.convertNetworks(networks), listener);
        }
    }

    void lookupAttributesSupport(final byte[] from_hash, byte networks, final RelatedAttributeLookupListener listener) throws ContentException {
        try {
            if (!this.enabled) {
                throw new ContentException("rcm is disabled");
            }
            final Download from_download = this.getDownload(from_hash);
            final Set<Object> existing_tags = from_download != null ? this.getExplicitTags(from_download) : Collections.emptySet();
            DHTPluginInterface dht_plugin = this.selectDHT(networks);
            if (dht_plugin == null) {
                throw new Exception("DHT Plugin unavailable for networks " + this.getString(RelatedContentManager.convertNetworks(networks)));
            }
            final String dht_plugin_network = dht_plugin == this.public_dht_plugin ? "Public" : "I2P";
            String from_hash_str = ByteFormatter.encodeString(from_hash);
            byte[] key_bytes = ("az:rcm:assoc:" + from_hash_str).getBytes("UTF-8");
            String op_str = "Content attr read: " + from_hash_str.substring(0, 16);
            dht_plugin.get(key_bytes, op_str, (byte)0, 512, 30000L, false, true, new DHTPluginOperationListener(){
                private Set<String> tags = new HashSet<String>();
                private Set<String> swarm_tags = new HashSet<String>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void starts(byte[] key) {
                    if (listener != null) {
                        String[] l_tags;
                        try {
                            listener.lookupStart();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        ContentCache content_cache = RelatedContentManager.this.loadRelatedContent();
                        DownloadInfo info = content_cache.related_content.get(Base32.encode(from_hash));
                        if (info != null && (l_tags = info.getTags()) != null) {
                            String[] stringArray = l_tags;
                            int n = l_tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block11: {
                                    String tag = stringArray[n2];
                                    Set<String> set = this.tags;
                                    synchronized (set) {
                                        if (this.tags.contains(tag)) {
                                            break block11;
                                        }
                                        this.tags.add(tag);
                                    }
                                    try {
                                        listener.tagFound(tag, dht_plugin_network);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                }

                @Override
                public boolean diversified() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    block10: {
                        try {
                            Map<String, Object> map = BDecoder.decode(value.getValue());
                            String[] r_tags = RelatedContentManager.this.decodeTags((byte[])map.get("m"));
                            if (r_tags == null) break block10;
                            String[] stringArray = r_tags;
                            int n = r_tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block11: {
                                    String tag = stringArray[n2];
                                    Set<String> set = this.tags;
                                    synchronized (set) {
                                        if (!TagUtils.isInternalTagName(tag) && !existing_tags.contains(tag)) {
                                            this.swarm_tags.add(tag);
                                        }
                                        if (this.tags.contains(tag)) {
                                            break block11;
                                        }
                                        this.tags.add(tag);
                                    }
                                    try {
                                        listener.tagFound(tag, dht_plugin_network);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    if (from_download != null) {
                        Set<String> set = this.tags;
                        synchronized (set) {
                            if (!this.swarm_tags.isEmpty()) {
                                DownloadManagerState dms = PluginCoreUtils.unwrap(from_download).getDownloadState();
                                String[] old = dms.getListAttribute("stag");
                                if (old == null || old.length == 0) {
                                    dms.setListAttribute("stag", this.swarm_tags.toArray(new String[0]));
                                } else if (old.length < 16) {
                                    this.swarm_tags.addAll(Arrays.asList(old));
                                    if (this.swarm_tags.size() > old.length) {
                                        dms.setListAttribute("stag", this.swarm_tags.toArray(new String[0]));
                                    }
                                }
                            }
                        }
                    }
                    if (listener != null) {
                        try {
                            listener.lookupComplete();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            ContentException ce = e instanceof ContentException ? (ContentException)e : new ContentException("Lookup failed", e);
            if (listener != null) {
                try {
                    listener.lookupFailed(ce);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
            throw ce;
        }
    }

    public void lookupContent(final byte[] hash, final RelatedContentLookupListener listener) throws ContentException {
        if (hash == null) {
            throw new ContentException("hash is null");
        }
        byte net = 1;
        try {
            Download download = this.getDownload(hash);
            if (download != null) {
                net = this.getNetworks(download);
            }
        }
        catch (Throwable download) {
            // empty catch block
        }
        final byte f_net = net;
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(hash, 0, f_net, true, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(hash, 0, f_net, true, listener);
        }
    }

    public void lookupContent(final byte[] hash, String[] networks, final RelatedContentLookupListener listener) throws ContentException {
        if (hash == null) {
            throw new ContentException("hash is null");
        }
        final byte net = RelatedContentManager.convertNetworks(networks);
        if (net == 0) {
            throw new ContentException("No networks specified");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(hash, 0, net, true, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(hash, 0, net, true, listener);
        }
    }

    public void lookupContent(final long file_size, final RelatedContentLookupListener listener) throws ContentException {
        if (file_size < 0x3200000L) {
            throw new ContentException("file size is invalid - min=52428800");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(file_size, (byte)1, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(file_size, (byte)1, listener);
        }
    }

    public void lookupContent(final long file_size, String[] networks, final RelatedContentLookupListener listener) throws ContentException {
        if (file_size < 0x3200000L) {
            throw new ContentException("file size is invalid - min=52428800");
        }
        final byte net = RelatedContentManager.convertNetworks(networks);
        if (net == 0) {
            throw new ContentException("No networks specified");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(file_size, net, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(file_size, net, listener);
        }
    }

    void lookupContentSupport(long file_size, byte networks, RelatedContentLookupListener listener) throws ContentException {
        if (!this.enabled) {
            throw new ContentException("rcm is disabled");
        }
        try {
            byte[] key_bytes = ("az:rcm:size:assoc:" + file_size).getBytes("UTF-8");
            byte[] from_hash = new SHA1Simple().calculateHash(key_bytes);
            String op_str = "Content rel read: size=" + file_size;
            this.lookupContentSupport0(from_hash, key_bytes, op_str, 0, networks, true, listener);
        }
        catch (ContentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ContentException("lookup failed", e);
        }
    }

    void lookupContentSupport(byte[] from_hash, int level, byte networks, boolean explicit, RelatedContentLookupListener listener) throws ContentException {
        if (!this.enabled) {
            throw new ContentException("rcm is disabled");
        }
        try {
            String from_hash_str = ByteFormatter.encodeString(from_hash);
            byte[] key_bytes = ("az:rcm:assoc:" + from_hash_str).getBytes("UTF-8");
            String op_str = "Content rel read: " + from_hash_str.substring(0, 16);
            this.lookupContentSupport0(from_hash, key_bytes, op_str, level, networks, explicit, listener);
        }
        catch (ContentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ContentException("lookup failed", e);
        }
    }

    private String getString(String[] args) {
        String str = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + s;
            ++n2;
        }
        return str;
    }

    private void lookupContentSupport0(final byte[] from_hash, byte[] key_bytes, String op_str, final int level, byte networks, final boolean explicit, final RelatedContentLookupListener listener) throws ContentException {
        try {
            int max_hits = 30;
            DHTPluginInterface dht_plugin = this.selectDHT(networks);
            if (dht_plugin == null) {
                throw new Exception("DHT Plugin unavailable for networks '" + this.getString(RelatedContentManager.convertNetworks(networks)) + "'");
            }
            dht_plugin.get(key_bytes, op_str, (byte)0, 30, 60000L, false, true, new DHTPluginOperationListener(){
                private Set<String> entries = new HashSet<String>();
                private RelatedContentManagerListener manager_listener;
                {
                    this.manager_listener = new RelatedContentManagerListener(){
                        private Set<RelatedContent> content_list = new HashSet<RelatedContent>();

                        @Override
                        public void contentFound(RelatedContent[] content) {
                            this.handle(content);
                        }

                        @Override
                        public void contentChanged(RelatedContent[] content) {
                            this.handle(content);
                        }

                        @Override
                        public void contentRemoved(RelatedContent[] content) {
                        }

                        @Override
                        public void contentChanged() {
                        }

                        @Override
                        public void contentReset() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void handle(RelatedContent[] content) {
                            ArrayList<RelatedContent> new_content = new ArrayList<RelatedContent>(content.length);
                            Set<RelatedContent> set = this.content_list;
                            synchronized (set) {
                                RelatedContent[] relatedContentArray = content;
                                int n = content.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    RelatedContent rc = relatedContentArray[n2];
                                    if (!this.content_list.contains(rc)) {
                                        new_content.add(rc);
                                    }
                                    ++n2;
                                }
                                if (new_content.size() == 0) {
                                    return;
                                }
                                this.content_list.addAll(new_content);
                            }
                            relatedContentLookupListener.contentFound(new_content.toArray(new RelatedContent[new_content.size()]));
                        }
                    };
                }

                @Override
                public void starts(byte[] key) {
                    if (listener != null) {
                        try {
                            listener.lookupStart();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                @Override
                public boolean diversified() {
                    return true;
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    try {
                        Map<String, Object> map = BDecoder.decode(value.getValue());
                        DownloadInfo info = RelatedContentManager.this.decodeInfo(map, from_hash, level + 1, explicit, this.entries);
                        if (info != null) {
                            RelatedContentManager.this.analyseResponse(info, listener == null ? null : this.manager_listener);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    if (listener != null) {
                        try {
                            listener.lookupComplete();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            ContentException ce = e instanceof ContentException ? (ContentException)e : new ContentException("Lookup failed", e);
            if (listener != null) {
                try {
                    listener.lookupFailed(ce);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
            throw ce;
        }
    }

    protected void popuplateSecondaryLookups(ContentCache content_cache) {
        Random rand = new Random();
        this.secondary_lookups.clear();
        List primaries = this.download_info_map.values();
        int primary_count = primaries.size();
        int primaries_to_add = primary_count < 2 ? 0 : (primary_count < 5 ? (rand.nextInt(4) == 0 ? 1 : 0) : (primary_count < 10 ? 1 : 2));
        if (primaries_to_add > 0) {
            HashSet<DownloadInfo> added = new HashSet<DownloadInfo>();
            int i = 0;
            while (i < primaries_to_add) {
                DownloadInfo info = (DownloadInfo)primaries.get(rand.nextInt(primaries.size()));
                if (!added.contains(info)) {
                    added.add(info);
                    this.secondary_lookups.addLast(new SecondaryLookup(info.getHash(), info.getLevel(), info.getNetworksInternal()));
                }
                ++i;
            }
        }
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        Iterator<DownloadInfo> it = related_content.values().iterator();
        ArrayList<DownloadInfo> secondary_cache_temp = new ArrayList<DownloadInfo>(related_content.size());
        while (it.hasNext()) {
            DownloadInfo di = it.next();
            if (di.getHash() == null || di.getLevel() >= this.max_search_level) continue;
            secondary_cache_temp.add(di);
        }
        int cache_size = Math.min(secondary_cache_temp.size(), 10 - this.secondary_lookups.size());
        if (cache_size > 0) {
            int i = 0;
            while (i < cache_size) {
                int index = rand.nextInt(secondary_cache_temp.size());
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(index);
                secondary_cache_temp.set(index, (DownloadInfo)secondary_cache_temp.get(i));
                secondary_cache_temp.set(i, x);
                ++i;
            }
            i = 0;
            while (i < cache_size) {
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(i);
                this.secondary_lookups.addLast(new SecondaryLookup(x.getHash(), x.getLevel(), x.getNetworksInternal()));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondaryLookup() {
        SecondaryLookup sl;
        long now = SystemTime.getMonotonousTime();
        Object object = this.rcm_lock;
        synchronized (object) {
            if (this.secondary_lookup_in_progress) {
                return;
            }
            if (now - this.secondary_lookup_complete_time < 900000L) {
                return;
            }
            if (this.secondary_lookups.size() == 0) {
                ContentCache cc;
                ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    cc = this.loadRelatedContent();
                } else {
                    this.popuplateSecondaryLookups(cc);
                }
            }
            if (this.secondary_lookups.size() == 0) {
                return;
            }
            sl = this.secondary_lookups.removeFirst();
            this.secondary_lookup_in_progress = true;
        }
        try {
            this.lookupContentSupport(sl.getHash(), sl.getLevel(), sl.getNetworks(), false, new RelatedContentLookupListener(){

                @Override
                public void lookupStart() {
                }

                @Override
                public void contentFound(RelatedContent[] content) {
                }

                @Override
                public void lookupComplete() {
                    this.next();
                }

                @Override
                public void lookupFailed(ContentException error) {
                    this.next();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void next() {
                    SecondaryLookup next_sl;
                    Object object = RelatedContentManager.this.rcm_lock;
                    synchronized (object) {
                        if (RelatedContentManager.this.secondary_lookups.size() == 0) {
                            RelatedContentManager.this.secondary_lookup_in_progress = false;
                            RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                            return;
                        }
                        next_sl = RelatedContentManager.this.secondary_lookups.removeFirst();
                    }
                    final 17 listener = this;
                    SimpleTimer.addEvent("RCM:SLDelay", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            try {
                                RelatedContentManager.this.lookupContentSupport(next_sl.getHash(), next_sl.getLevel(), next_sl.getNetworks(), false, listener);
                            }
                            catch (Throwable e) {
                                Object object = (this).RelatedContentManager.this.rcm_lock;
                                synchronized (object) {
                                    (this).RelatedContentManager.this.secondary_lookup_in_progress = false;
                                    (this).RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            Object object2 = this.rcm_lock;
            synchronized (object2) {
                this.secondary_lookup_in_progress = false;
                this.secondary_lookup_complete_time = now;
            }
        }
    }

    protected void contentChanged(final DownloadInfo info) {
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged(new RelatedContent[]{info});
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void contentChanged(boolean is_dirty) {
        if (is_dirty) {
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RelatedContent[] content) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            this.delete(content, content_cache, true);
        }
    }

    protected void delete(final RelatedContent[] content, ContentCache content_cache, boolean persistent) {
        if (persistent) {
            this.addPersistentlyDeleted(content);
        }
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        Iterator<DownloadInfo> it = related_content.values().iterator();
        while (it.hasNext()) {
            DownloadInfo di = it.next();
            RelatedContent[] relatedContentArray = content;
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                RelatedContent c = relatedContentArray[n2];
                if (c == di) {
                    it.remove();
                    if (di.isUnread()) {
                        this.decrementUnread();
                    }
                }
                ++n2;
            }
        }
        ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = content_cache.related_content_map;
        ArrayList<byte[]> delete = new ArrayList<byte[]>();
        block2: for (byte[] key : related_content_map.keys()) {
            ArrayList infos = (ArrayList)related_content_map.get(key);
            RelatedContent[] relatedContentArray = content;
            int n = content.length;
            int n3 = 0;
            while (n3 < n) {
                RelatedContent c = relatedContentArray[n3];
                if (infos.remove(c) && infos.size() == 0) {
                    delete.add(key);
                    continue block2;
                }
                ++n3;
            }
        }
        for (byte[] key : delete) {
            related_content_map.remove(key);
        }
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentRemoved(content);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected String getPrivateInfoKey(RelatedContent info) {
        return String.valueOf(info.getTitle()) + ":" + info.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyseResponse(DownloadInfo to_info, final RelatedContentManagerListener listener) {
        try {
            Object object = this.rcm_lock;
            synchronized (object) {
                String key;
                byte[] target = to_info.getHash();
                if (target != null) {
                    if (this.download_info_map.containsKey(target)) {
                        return;
                    }
                    key = Base32.encode(target);
                } else {
                    key = this.getPrivateInfoKey(to_info);
                    if (this.download_priv_set.contains(key)) {
                        return;
                    }
                }
                if (this.isPersistentlyDeleted(to_info)) {
                    return;
                }
                if (this.globalFilter(to_info)) {
                    return;
                }
                ContentCache content_cache = this.loadRelatedContent();
                DownloadInfo target_info = null;
                boolean changed_content = false;
                boolean new_content = false;
                target_info = content_cache.related_content.get(key);
                if (target_info == null) {
                    if (this.enoughSpaceFor(content_cache, to_info)) {
                        target_info = to_info;
                        content_cache.related_content.put(key, target_info);
                        byte[] from_hash = to_info.getRelatedToHash();
                        ArrayList<DownloadInfo> links = (ArrayList<DownloadInfo>)content_cache.related_content_map.get(from_hash);
                        if (links == null) {
                            links = new ArrayList<DownloadInfo>(1);
                            content_cache.related_content_map.put(from_hash, links);
                        }
                        links.add(target_info);
                        links.trimToSize();
                        target_info.setPublic(content_cache);
                        if (this.secondary_lookups.size() < 10) {
                            byte[] hash = target_info.getHash();
                            int level = target_info.getLevel();
                            if (hash != null && level < this.max_search_level) {
                                this.secondary_lookups.add(new SecondaryLookup(hash, level, target_info.getNetworksInternal()));
                            }
                        }
                        new_content = true;
                    } else {
                        transient_info_cache.put(key, to_info);
                    }
                } else if (to_info.getVersion() >= target_info.getVersion()) {
                    changed_content = target_info.addInfo(to_info);
                }
                if (target_info != null) {
                    boolean something_changed;
                    final RelatedContent[] f_target = new RelatedContent[]{target_info};
                    final boolean f_change = changed_content;
                    boolean bl = something_changed = changed_content || new_content;
                    if (something_changed) {
                        this.setConfigDirty();
                    }
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (something_changed) {
                                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                                    try {
                                        if (f_change) {
                                            l.contentChanged(f_target);
                                            continue;
                                        }
                                        l.contentFound(f_target);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                            if (listener != null) {
                                try {
                                    if (f_change) {
                                        listener.contentChanged(f_target);
                                    } else {
                                        listener.contentFound(f_target);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected boolean enoughSpaceFor(ContentCache content_cache, DownloadInfo fi) {
        int now_secs;
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        if (related_content.size() < this.max_results + this.temporary_space.get()) {
            return true;
        }
        Iterator<Map.Entry<String, DownloadInfo>> it = related_content.entrySet().iterator();
        int max_level = fi.getLevel();
        HashMap<Integer, DownloadInfo> oldest_per_rank = new HashMap<Integer, DownloadInfo>();
        int min_rank = Integer.MAX_VALUE;
        int max_rank = -1;
        while (it.hasNext()) {
            int rank;
            int info_level;
            Map.Entry<String, DownloadInfo> entry = it.next();
            DownloadInfo info = entry.getValue();
            if (info.isExplicit() || (info_level = info.getLevel()) < max_level) continue;
            if (info_level > max_level) {
                max_level = info_level;
                min_rank = Integer.MAX_VALUE;
                max_rank = -1;
                oldest_per_rank.clear();
            }
            if ((rank = info.getRank()) < min_rank) {
                min_rank = rank;
            } else if (rank > max_rank) {
                max_rank = rank;
            }
            DownloadInfo oldest = (DownloadInfo)oldest_per_rank.get(rank);
            if (oldest == null) {
                oldest_per_rank.put(rank, info);
                continue;
            }
            if (info.getLastSeenSecs() >= oldest.getLastSeenSecs()) continue;
            oldest_per_rank.put(rank, info);
        }
        DownloadInfo to_remove = (DownloadInfo)oldest_per_rank.get(min_rank);
        if (to_remove != null) {
            this.delete(new RelatedContent[]{to_remove}, content_cache, false);
            return true;
        }
        if (max_level == 1 && (to_remove = (DownloadInfo)oldest_per_rank.get(max_rank)) != null && (now_secs = (int)(SystemTime.getCurrentTime() / 1000L)) - to_remove.getLastSeenSecs() >= 86400) {
            this.delete(new RelatedContent[]{to_remove}, content_cache, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedContent[] getRelatedContent() {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            return content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DownloadInfo> getRelatedContentAsList() {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            return new ArrayList<DownloadInfo>(content_cache.related_content.values());
        }
    }

    public void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean reset_perm_dels) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache cc;
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (cc == null) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                cc.related_content = new HashMap<String, DownloadInfo>();
                cc.related_content_map = new ByteArrayHashMapEx();
            }
            this.pub_download_infos1.clear();
            this.pub_download_infos2.clear();
            this.non_pub_download_infos1.clear();
            this.non_pub_download_infos2.clear();
            List list = this.download_info_map.values();
            for (DownloadInfo info : list) {
                byte nets = info.getNetworksInternal();
                if (nets == 0) continue;
                if ((nets & 1) != 0) {
                    this.pub_download_infos1.add(info);
                    this.pub_download_infos2.add(info);
                    continue;
                }
                this.non_pub_download_infos1.add(info);
                this.non_pub_download_infos2.add(info);
            }
            Collections.shuffle(this.pub_download_infos1);
            Collections.shuffle(this.non_pub_download_infos1);
            this.total_unread.set(0);
            if (reset_perm_dels) {
                this.resetPersistentlyDeleted();
            }
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    l.contentReset();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchInstance searchRCM(final Map<String, Object> search_parameters, final SearchObserver observer) throws SearchException {
        if (!this.initialisation_complete_sem.isReleasedForever()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            final boolean[] cancelled = new boolean[1];
            final boolean[] went_async = new boolean[1];
            final SearchInstance[] si = new SearchInstance[1];
            final SearchException[] error = new SearchException[1];
            final AESemaphore temp_sem = new AESemaphore("");
            dispatcher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void runSupport() {
                    try {
                        try {
                            si[0] = RelatedContentManager.this.searchRCMSupport(search_parameters, observer);
                            boolean[] blArray = cancelled;
                            synchronized (cancelled) {
                                if (!cancelled[0]) return;
                                si[0].cancel();
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            SearchException se = e instanceof SearchException ? (SearchException)e : new SearchException("Search failed", e);
                            boolean[] blArray = cancelled;
                            synchronized (cancelled) {
                                error[0] = se;
                                if (went_async[0]) {
                                    observer.complete();
                                }
                                // ** MonitorExit[var3_4] (shouldn't be in output)
                                temp_sem.release();
                                return;
                            }
                        }
                    }
                    finally {
                        temp_sem.release();
                    }
                }
            });
            temp_sem.reserve(500L);
            boolean[] blArray = cancelled;
            synchronized (cancelled) {
                if (si[0] != null) {
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return si[0];
                }
                if (error[0] != null) {
                    throw error[0];
                }
                went_async[0] = true;
                // ** MonitorExit[var9_9] (shouldn't be in output)
                SearchInstance result = new SearchInstance(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void cancel() {
                        boolean[] blArray = cancelled;
                        synchronized (cancelled) {
                            if (si[0] != null) {
                                si[0].cancel();
                            }
                            cancelled[0] = true;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                return result;
            }
        }
        return this.searchRCMSupport(search_parameters, observer);
    }

    SearchInstance searchRCMSupport(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
        RelatedContentSearcher searcher2;
        this.initialisation_complete_sem.reserve();
        if (!this.enabled) {
            throw new SearchException("rcm is disabled");
        }
        String[] networks = (String[])search_parameters.get("n");
        String target_net = "Public";
        if (networks != null) {
            String[] stringArray = networks;
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    target_net = "Public";
                    break;
                }
                if (net == "I2P") {
                    target_net = "I2P";
                }
                ++n2;
            }
        }
        if (target_net == "I2P") {
            this.checkI2PSearcher(true);
        } else if (prefer_i2p && (searcher2 = this.checkMixSearcher()) != null) {
            return searcher2.searchRCM(search_parameters, observer);
        }
        for (RelatedContentSearcher searcher2 : this.searchers) {
            String net = searcher2.getDHTPlugin().getNetwork();
            if (net != target_net) continue;
            return searcher2.searchRCM(search_parameters, observer);
        }
        throw new SearchException("no searchers available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        Object object = this.rcm_lock;
        synchronized (object) {
            this.content_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentCache loadRelatedContent() {
        boolean fire_event = false;
        try {
            Object object = this.rcm_lock;
            synchronized (object) {
                ContentCache cc;
                this.last_config_access = SystemTime.getMonotonousTime();
                ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    fire_event = true;
                    cc = new ContentCache();
                    this.content_cache = new WeakReference<ContentCache>(cc);
                    try {
                        int new_total_unread = 0;
                        if (FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
                            Map<Object, Object> map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                            Map<String, DownloadInfo> related_content = cc.related_content;
                            ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = cc.related_content_map;
                            byte[] data = (byte[])map.get("d");
                            if (data != null) {
                                block48: {
                                    map = null;
                                    BufferedInputStream is = null;
                                    try {
                                        try {
                                            is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(CryptoManagerFactory.getSingleton().deobfuscate(data))));
                                            map = BDecoder.decode(is);
                                        }
                                        catch (Throwable throwable) {
                                            if (is != null) {
                                                try {
                                                    is.close();
                                                }
                                                catch (Throwable throwable2) {}
                                            }
                                            break block48;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (Throwable throwable3) {
                                                // empty catch block
                                            }
                                        }
                                        throw throwable;
                                    }
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (map == null) {
                                    map = new HashMap();
                                }
                            }
                            Map rcm_map = (Map)map.get("rcm");
                            Object rc_map_stuff = map.get("rc");
                            if (rc_map_stuff != null && rcm_map != null) {
                                String key;
                                HashMap<Integer, DownloadInfo> id_map = new HashMap<Integer, DownloadInfo>();
                                if (rc_map_stuff instanceof Map) {
                                    Map rc_map = (Map)rc_map_stuff;
                                    for (Map.Entry entry : rc_map.entrySet()) {
                                        try {
                                            key = (String)entry.getKey();
                                            Map info_map = (Map)entry.getValue();
                                            DownloadInfo info = this.deserialiseDI(info_map, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)info_map.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                } else {
                                    List rc_map_list = (List)rc_map_stuff;
                                    for (Map map2 : rc_map_list) {
                                        try {
                                            key = new String((byte[])map2.get("_k"), "UTF-8");
                                            DownloadInfo info = this.deserialiseDI(map2, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)map2.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                if (rcm_map.size() != 0 && id_map.size() != 0) {
                                    for (String key2 : rcm_map.keySet()) {
                                        try {
                                            byte[] hash = Base32.decode(key2);
                                            int[] ids = MapUtils.importIntArray(rcm_map, key2);
                                            if (ids == null || ids.length == 0) continue;
                                            ArrayList<DownloadInfo> di_list = new ArrayList<DownloadInfo>(ids.length);
                                            int[] nArray = ids;
                                            int n = ids.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                int id = nArray[n2];
                                                DownloadInfo di = (DownloadInfo)id_map.get(id);
                                                if (di != null) {
                                                    di.setRelatedToHash(hash);
                                                    di_list.add(di);
                                                }
                                                ++n2;
                                            }
                                            if (di_list.size() <= 0) continue;
                                            related_content_map.put(hash, di_list);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                Iterator<DownloadInfo> it = related_content.values().iterator();
                                while (it.hasNext()) {
                                    DownloadInfo downloadInfo = it.next();
                                    if (downloadInfo.getRelatedToHash() != null) continue;
                                    if (downloadInfo.isUnread()) {
                                        --new_total_unread;
                                    }
                                    it.remove();
                                }
                                this.popuplateSecondaryLookups(cc);
                            }
                        }
                        if (this.total_unread.get() != new_total_unread) {
                            this.total_unread.set(new_total_unread);
                            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, new_total_unread);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    this.enforceMaxResults(cc, false);
                }
                this.content_cache_ref = cc;
                ContentCache contentCache2 = cc;
                return contentCache2;
            }
        }
        finally {
            if (fire_event) {
                this.contentChanged(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRelatedContent(int tick_count) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache cc;
            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, this.total_unread.get());
            long now = SystemTime.getMonotonousTime();
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (!this.content_dirty) {
                if (cc != null && now - this.last_config_access > 60000L) {
                    if (this.content_cache_ref != null) {
                        this.content_discard_ticks = 0;
                    }
                    this.content_cache_ref = null;
                }
                return;
            }
            if (tick_count % 10 != 0) {
                return;
            }
            this.last_config_access = now;
            this.content_dirty = false;
            if (cc != null) {
                if (this.persist) {
                    Map<String, DownloadInfo> related_content = cc.related_content;
                    ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = cc.related_content_map;
                    if (related_content.size() == 0) {
                        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
                    } else {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        Set<Map.Entry<String, DownloadInfo>> rcs = related_content.entrySet();
                        ArrayList<Map<String, Object>> rc_map_list = new ArrayList<Map<String, Object>>(rcs.size());
                        map.put("rc", rc_map_list);
                        int id = 0;
                        HashMap<Object, Integer> info_map = new HashMap<Object, Integer>();
                        for (Map.Entry<String, DownloadInfo> entry : rcs) {
                            DownloadInfo info = entry.getValue();
                            Map<String, Object> di_map = this.serialiseDI(info, cc);
                            if (di_map == null) continue;
                            info_map.put(info, id);
                            di_map.put("_i", new Long(id));
                            di_map.put("_k", entry.getKey());
                            rc_map_list.add(di_map);
                            ++id;
                        }
                        HashMap rcm_map = new HashMap();
                        map.put("rcm", rcm_map);
                        for (byte[] hash : related_content_map.keys()) {
                            List dis = (List)related_content_map.get(hash);
                            int[] ids = new int[dis.size()];
                            int pos = 0;
                            for (DownloadInfo di : dis) {
                                Integer index = (Integer)info_map.get(di);
                                if (index == null) break;
                                ids[pos++] = index;
                            }
                            if (pos != ids.length) continue;
                            MapUtils.exportIntArrayAsByteArray(rcm_map, Base32.encode(hash), ids);
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(102400);
                        try {
                            GZIPOutputStream gos = new GZIPOutputStream(baos);
                            gos.write(BEncoder.encode(map));
                            gos.close();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        map.clear();
                        map.put("d", CryptoManagerFactory.getSingleton().obfuscate(baos.toByteArray()));
                        FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
                    }
                } else {
                    this.deleteRelatedContent();
                }
                for (RelatedContentSearcher searcher : this.searchers) {
                    searcher.updateKeyBloom(cc);
                }
            }
        }
    }

    void deleteRelatedContent() {
        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
    }

    public int getNumUnread() {
        return this.total_unread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRead() {
        boolean changed = false;
        Object object = this.rcm_lock;
        synchronized (object) {
            DownloadInfo[] content;
            DownloadInfo[] downloadInfoArray = content = (DownloadInfo[])this.getRelatedContent();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadInfo c = downloadInfoArray[n2];
                if (c.isUnread()) {
                    changed = true;
                    c.setUnreadInternal(false);
                }
                ++n2;
            }
            this.total_unread.set(0);
        }
        if (changed) {
            this.contentChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            this.addPersistentlyDeleted(content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]));
            this.reset(false);
        }
    }

    protected void incrementUnread() {
        this.total_unread.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUnread() {
        Object object = this.rcm_lock;
        synchronized (object) {
            int val = this.total_unread.decrementAndGet();
            if (val < 0) {
                this.total_unread.set(0);
            }
        }
    }

    protected Download getDownload(byte[] hash) {
        try {
            return this.plugin_interface.getDownloadManager().getDownload(hash);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private byte[][] getKeys(Download download) {
        byte[] tracker_keys = null;
        byte[] ws_keys = null;
        try {
            Torrent torrent = download.getTorrent();
            if (torrent != null) {
                TOTorrentAnnounceURLSet[] sets;
                TOTorrent to_torrent = PluginCoreUtils.unwrap(torrent);
                HashSet<String> tracker_domains = new HashSet<String>();
                this.addURLToDomainKeySet(tracker_domains, to_torrent.getAnnounceURL());
                TOTorrentAnnounceURLGroup group = to_torrent.getAnnounceURLGroup();
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = group.getAnnounceURLSets();
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                    URL[] urls = set.getAnnounceURLs();
                    URL[] uRLArray = urls;
                    int n3 = urls.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        URL u = uRLArray[n4];
                        this.addURLToDomainKeySet(tracker_domains, u);
                        ++n4;
                    }
                    ++n2;
                }
                tracker_keys = this.domainsToArray(tracker_domains, 8);
                HashSet<String> ws_domains = new HashSet<String>();
                List getright = BDecoder.decodeStrings(this.getURLList(to_torrent, "url-list"));
                List webseeds = BDecoder.decodeStrings(this.getURLList(to_torrent, "httpseeds"));
                List[] listArray = new List[]{getright, webseeds};
                int n5 = listArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    List l = listArray[n6];
                    for (Object o : l) {
                        if (!(o instanceof String)) continue;
                        try {
                            this.addURLToDomainKeySet(ws_domains, new URL((String)o));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n6;
                }
                ws_keys = this.domainsToArray(ws_domains, 3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[][]{tracker_keys, ws_keys};
    }

    protected byte[] domainsToArray(Set<String> domains, int max) {
        int entries = Math.min(domains.size(), max);
        if (entries > 0) {
            byte[] keys = new byte[entries * 4];
            int pos = 0;
            for (String dom : domains) {
                int hash = dom.hashCode();
                byte[] bytes = new byte[]{(byte)(hash >> 24), (byte)(hash >> 16), (byte)(hash >> 8), (byte)hash};
                System.arraycopy(bytes, 0, keys, pos, 4);
                pos += 4;
            }
            return keys;
        }
        return null;
    }

    protected List getURLList(TOTorrent torrent, String key) {
        Object obj = torrent.getAdditionalProperty(key);
        if (obj instanceof byte[]) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(obj);
            return l;
        }
        if (obj instanceof List) {
            return (List)BEncoder.clone(obj);
        }
        return new ArrayList();
    }

    private void addURLToDomainKeySet(Set<String> set, URL u) {
        String prot = u.getProtocol();
        if (prot != null && (prot.equalsIgnoreCase("http") || prot.equalsIgnoreCase("udp"))) {
            String host = u.getHost().toLowerCase(Locale.US);
            if (host.contains(":")) {
                return;
            }
            String[] bits = host.split("\\.");
            int len = bits.length;
            if (len >= 2) {
                String end = bits[len - 1];
                char[] chars = end.toCharArray();
                boolean all_digits = true;
                char[] cArray = chars;
                int n = chars.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isDigit(c)) {
                        all_digits = false;
                        break;
                    }
                    ++n2;
                }
                if (!all_digits) {
                    set.add(String.valueOf(bits[len - 2]) + "." + end);
                }
            }
        }
    }

    private byte getNetworks(Download download) {
        String[] networks = download.getListAttribute(this.ta_networks);
        if (networks == null) {
            return 0;
        }
        return RelatedContentManager.convertNetworks(networks);
    }

    public static String[] convertNetworks(byte net) {
        if (net == 0) {
            return new String[0];
        }
        if (net == 1) {
            return NET_PUBLIC_ARRAY;
        }
        if (net == 2) {
            return NET_I2P_ARRAY;
        }
        if (net == 4) {
            return NET_TOR_ARRAY;
        }
        if (net == 3) {
            return NET_PUBLIC_AND_I2P_ARRAY;
        }
        ArrayList<String> nets = new ArrayList<String>();
        if ((net & 1) != 0) {
            nets.add("Public");
        }
        if ((net & 2) != 0) {
            nets.add("I2P");
        }
        if ((net & 4) != 0) {
            nets.add("Tor");
        }
        return nets.toArray(new String[nets.size()]);
    }

    public static byte convertNetworks(String[] networks) {
        byte nets = 0;
        String[] stringArray = networks;
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equalsIgnoreCase("Public")) {
                nets = (byte)(nets | 1);
            } else if (n3.equalsIgnoreCase("I2P")) {
                nets = (byte)(nets | 2);
            } else if (n3.equalsIgnoreCase("Tor")) {
                nets = (byte)(nets | 4);
            }
            ++n2;
        }
        return nets;
    }

    private Set<String> getExplicitTags(Download download) {
        HashSet<String> all_tags = new HashSet<String>();
        if (this.tag_manager.isEnabled()) {
            Tag cat_tag;
            String cat_name;
            String string = cat_name = this.ta_category == null ? null : download.getAttribute(this.ta_category);
            if (cat_name != null && (cat_tag = this.tag_manager.getTagType(1).getTag(cat_name, true)) != null && cat_tag.isPublic()) {
                all_tags.add(cat_name.toLowerCase(Locale.US));
            }
            List<Tag> tags = this.tag_manager.getTagType(3).getTagsForTaggable(PluginCoreUtils.unwrap(download));
            for (Tag t : tags) {
                if (!t.isPublic()) continue;
                all_tags.add(t.getTagName(true).toLowerCase(Locale.US));
            }
        }
        return all_tags;
    }

    private String[] getTags(Download download) {
        String[] networks;
        HashSet<String> all_tags = new HashSet<String>();
        if (this.tag_manager.isEnabled()) {
            Tag cat_tag;
            String cat_name;
            String string = cat_name = this.ta_category == null ? null : download.getAttribute(this.ta_category);
            if (cat_name != null && (cat_tag = this.tag_manager.getTagType(1).getTag(cat_name, true)) != null && cat_tag.isPublic()) {
                all_tags.add(cat_name.toLowerCase(Locale.US));
            }
            List<Tag> tags = this.tag_manager.getTagType(3).getTagsForTaggable(PluginCoreUtils.unwrap(download));
            for (Tag t : tags) {
                if (!t.isPublic()) continue;
                all_tags.add(t.getTagName(true).toLowerCase(Locale.US));
            }
        }
        String[] stringArray = networks = download.getListAttribute(this.ta_networks);
        int n = networks.length;
        int t = 0;
        while (t < n) {
            String network = stringArray[t];
            if (!network.equals("Public") && AEPluginProxyHandler.hasPluginProxyForNetwork(network, true)) {
                all_tags.add("_" + network.toLowerCase(Locale.US) + "_");
            }
            ++t;
        }
        try {
            TOTorrent torrent = PluginCoreUtils.unwrap(download.getTorrent());
            int tt = torrent.getTorrentType();
            if (tt == 2) {
                all_tags.add("_hybrid_");
            } else if (tt == 3) {
                all_tags.add("_v2_");
            }
        }
        catch (Throwable torrent) {
            // empty catch block
        }
        if (all_tags.size() == 0) {
            return null;
        }
        if (all_tags.size() == 1) {
            return new String[]{(String)all_tags.iterator().next()};
        }
        ArrayList temp = new ArrayList(all_tags);
        Collections.shuffle(temp);
        return temp.toArray(new String[temp.size()]);
    }

    protected byte[] encodeTags(String[] tags) {
        if (tags == null || tags.length == 0) {
            return null;
        }
        byte[] temp = new byte[64];
        int pos = 0;
        int rem = temp.length;
        int i = 0;
        while (i < tags.length) {
            String tag = tags[i];
            tag = this.truncateTag(tag);
            try {
                byte[] tag_bytes = tag.getBytes("UTF-8");
                int tb_len = tag_bytes.length;
                if (rem < tb_len + 1) break;
                temp[pos++] = (byte)tb_len;
                System.arraycopy(tag_bytes, 0, temp, pos, tb_len);
                pos += tb_len;
                rem -= tb_len + 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        if (pos == 0) {
            return null;
        }
        byte[] result = new byte[pos];
        System.arraycopy(temp, 0, result, 0, pos);
        return result;
    }

    protected String truncateTag(String tag) {
        if (tag.length() > 20) {
            tag = tag.substring(0, 20);
        }
        while (tag.length() > 0) {
            try {
                byte[] tag_bytes = tag.getBytes("UTF-8");
                if (tag_bytes.length <= 20) break;
                tag = tag.substring(0, tag.length() - 1);
            }
            catch (Throwable e) {
                break;
            }
        }
        return tag;
    }

    protected String[] decodeTags(byte[] bytes) {
        int tag_len;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>(10);
        for (int pos = 0; pos < bytes.length; pos += tag_len) {
            if ((tag_len = bytes[pos++] & 0xFF) > 20) break;
            try {
                tags.add(new String(bytes, pos, tag_len, "UTF-8"));
                continue;
            }
            catch (Throwable e) {
                break;
            }
        }
        if (tags.size() == 0) {
            return null;
        }
        return tags.toArray(new String[tags.size()]);
    }

    protected byte[] getPermDelKey(RelatedContent info) {
        byte[] bytes = info.getHash();
        if (bytes == null) {
            try {
                bytes = new SHA1Simple().calculateHash(this.getPrivateInfoKey(info).getBytes("ISO-8859-1"));
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        byte[] key = new byte[8];
        System.arraycopy(bytes, 0, key, 0, 8);
        return key;
    }

    protected List<byte[]> loadPersistentlyDeleted() {
        List entries = null;
        if (FileUtil.resilientConfigFileExists(PERSIST_DEL_FILE)) {
            Map map = FileUtil.readResilientConfigFile(PERSIST_DEL_FILE);
            entries = (List)map.get("entries");
        }
        if (entries == null) {
            entries = new ArrayList(0);
        }
        return entries;
    }

    protected void addPersistentlyDeleted(RelatedContent[] content) {
        block6: {
            if (content.length == 0) {
                return;
            }
            List<byte[]> entries = this.loadPersistentlyDeleted();
            ArrayList<byte[]> new_keys = new ArrayList<byte[]>(content.length);
            RelatedContent[] relatedContentArray = content;
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                RelatedContent rc = relatedContentArray[n2];
                byte[] key = this.getPermDelKey(rc);
                new_keys.add(key);
                entries.add(key);
                ++n2;
            }
            HashMap<String, List<byte[]>> map = new HashMap<String, List<byte[]>>();
            map.put("entries", entries);
            FileUtil.writeResilientConfigFile(PERSIST_DEL_FILE, map);
            if (this.persist_del_bloom == null) break block6;
            if (this.persist_del_bloom.getSize() / (this.persist_del_bloom.getEntryCount() + content.length) < 10) {
                this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, this.persist_del_bloom.getSize() * 10 + 1000 + content.length));
                for (byte[] k : entries) {
                    this.persist_del_bloom.add(k);
                }
            } else {
                for (byte[] k : new_keys) {
                    this.persist_del_bloom.add(k);
                }
            }
        }
    }

    protected boolean globalFilter(RelatedContent content) {
        return this.global_filter_active_only && content.getSeeds() <= 0 && content.getLeechers() <= 0;
    }

    protected boolean isPersistentlyDeleted(RelatedContent content) {
        if (this.persist_del_bloom == null) {
            List<byte[]> entries = this.loadPersistentlyDeleted();
            this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, entries.size() * 10 + 1000));
            for (byte[] k : entries) {
                this.persist_del_bloom.add(k);
            }
        }
        byte[] key = this.getPermDelKey(content);
        return this.persist_del_bloom.contains(key);
    }

    protected void resetPersistentlyDeleted() {
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
        this.persist_del_bloom = BloomFilterFactory.createAddOnly(1000);
    }

    public void reserveTemporarySpace() {
        this.temporary_space.addAndGet(50);
    }

    public void releaseTemporarySpace() {
        boolean reset_explicit = this.temporary_space.addAndGet(-50) == 0;
        this.enforceMaxResults(reset_explicit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enforceMaxResults(boolean reset_explicit) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            this.enforceMaxResults(content_cache, reset_explicit);
        }
    }

    protected void enforceMaxResults(ContentCache content_cache, boolean reset_explicit) {
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        int num_to_remove = related_content.size() - (this.max_results + this.temporary_space.get());
        if (num_to_remove > 0) {
            ArrayList<DownloadInfo> infos = new ArrayList<DownloadInfo>(related_content.values());
            if (reset_explicit) {
                for (DownloadInfo info : infos) {
                    if (!info.isExplicit()) continue;
                    info.setExplicit(false);
                }
            }
            Collections.sort(infos, new Comparator<DownloadInfo>(){

                @Override
                public int compare(DownloadInfo o1, DownloadInfo o2) {
                    int res = o2.getLevel() - o1.getLevel();
                    if (res != 0) {
                        return res;
                    }
                    res = o1.getRank() - o2.getRank();
                    if (res != 0) {
                        return res;
                    }
                    return o1.getLastSeenSecs() - o2.getLastSeenSecs();
                }
            });
            ArrayList<RelatedContent> to_remove = new ArrayList<RelatedContent>();
            int i = 0;
            while (i < Math.min(num_to_remove, infos.size())) {
                to_remove.add((RelatedContent)infos.get(i));
                ++i;
            }
            if (to_remove.size() > 0) {
                this.delete(to_remove.toArray(new RelatedContent[to_remove.size()]), content_cache, false);
            }
        }
    }

    public void addListener(RelatedContentManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RelatedContentManagerListener listener) {
        this.listeners.remove(listener);
    }

    private Map<String, Object> serialiseDI(DownloadInfo info, ContentCache cc) {
        try {
            byte nets;
            String[] tags;
            byte[] ws_keys;
            HashMap<String, Object> info_map = new HashMap<String, Object>();
            MapUtils.exportLong(info_map, "v", info.getVersion());
            info_map.put("h", info.getHash());
            MapUtils.setMapString(info_map, "d", info.getTitle());
            MapUtils.exportInt(info_map, "r", info.getRand());
            MapUtils.setMapString(info_map, "t", info.getTracker());
            MapUtils.exportLong(info_map, "z", info.getSize());
            MapUtils.exportInt(info_map, "p", (int)(info.getPublishDate() / 3600000L));
            MapUtils.exportInt(info_map, "q", info.getSeeds() << 16 | info.getLeechers() & 0xFFFF);
            byte[] tracker_keys = info.getTrackerKeys();
            if (tracker_keys != null) {
                info_map.put("k", tracker_keys);
            }
            if ((ws_keys = info.getWebSeedKeys()) != null) {
                info_map.put("w", ws_keys);
            }
            if ((tags = info.getTags()) != null) {
                info_map.put("g", this.encodeTags(tags));
            }
            if ((nets = info.getNetworksInternal()) != 1) {
                info_map.put("o", new Long(nets & 0xFF));
            }
            if (cc != null) {
                MapUtils.exportBooleanAsLong(info_map, "u", info.isUnread());
                MapUtils.exportIntArrayAsByteArray(info_map, "l", info.getRandList());
                MapUtils.exportInt(info_map, "f", info.getFirstSeenSecs());
                MapUtils.exportInt(info_map, "s", info.getLastSeenSecs());
                MapUtils.exportInt(info_map, "e", info.getLevel());
            }
            MapUtils.exportLong(info_map, "cl", info.getChangedLocallyOn());
            return info_map;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private DownloadInfo deserialiseDI(Map<String, Object> info_map, ContentCache cc) {
        try {
            int version = (int)MapUtils.importLong(info_map, "v", 0L);
            byte[] hash = (byte[])info_map.get("h");
            String title = MapUtils.getMapString(info_map, "d", null);
            int rand = MapUtils.importInt(info_map, "r", 0);
            String tracker = MapUtils.getMapString(info_map, "t", null);
            long size = MapUtils.importLong(info_map, "z", 0L);
            int date = MapUtils.importInt(info_map, "p", 0);
            int seeds_leechers = MapUtils.importInt(info_map, "q", -1);
            byte[] tracker_keys = (byte[])info_map.get("k");
            byte[] ws_keys = (byte[])info_map.get("w");
            long lastChangedLocally = MapUtils.importLong(info_map, "cl", 0L);
            if (tracker_keys != null && tracker_keys.length % 4 != 0) {
                tracker_keys = null;
            }
            if (ws_keys != null && ws_keys.length % 4 != 0) {
                ws_keys = null;
            }
            byte[] _tags = (byte[])info_map.get("g");
            String[] tags = this.decodeTags(_tags);
            Long _nets = (Long)info_map.get("o");
            byte nets = _nets == null ? (byte)1 : _nets.byteValue();
            int first_seen = MapUtils.importInt(info_map, "f", 0);
            if (cc == null) {
                DownloadInfo info = new DownloadInfo(version, hash, hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, first_seen, 0, false, size, date, seeds_leechers);
                info.setChangedLocallyOn(lastChangedLocally);
                return info;
            }
            boolean unread = MapUtils.getMapBoolean(info_map, "u", false);
            int[] rand_list = MapUtils.importIntArray(info_map, "l");
            int last_seen = MapUtils.importInt(info_map, "s", 0);
            int level = MapUtils.importInt(info_map, "e", 0);
            DownloadInfo info = new DownloadInfo(version, hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, unread, rand_list, first_seen, last_seen, level, size, date, seeds_leechers, cc);
            info.setChangedLocallyOn(lastChangedLocally);
            return info;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private void dump() {
        RelatedContent[] related_content = this.getRelatedContent();
        ByteArrayHashMap<ArrayList<String>> tk_map = new ByteArrayHashMap<ArrayList<String>>();
        ByteArrayHashMap<ArrayList<String>> ws_map = new ByteArrayHashMap<ArrayList<String>>();
        RelatedContent[] relatedContentArray = related_content;
        int n = related_content.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] ws_keys;
            RelatedContent rc = relatedContentArray[n2];
            byte[] tracker_keys = rc.getTrackerKeys();
            if (tracker_keys != null) {
                int i = 0;
                while (i < tracker_keys.length) {
                    byte[] tk = new byte[4];
                    System.arraycopy(tracker_keys, i, tk, 0, 4);
                    ArrayList<String> titles = (ArrayList<String>)tk_map.get(tk);
                    if (titles == null) {
                        titles = new ArrayList<String>();
                        tk_map.put(tk, titles);
                    }
                    titles.add(rc.getTitle());
                    i += 4;
                }
            }
            if ((ws_keys = rc.getWebSeedKeys()) != null) {
                int i = 0;
                while (i < ws_keys.length) {
                    byte[] wk = new byte[4];
                    System.arraycopy(ws_keys, i, wk, 0, 4);
                    ArrayList<String> titles = (ArrayList<String>)ws_map.get(wk);
                    if (titles == null) {
                        titles = new ArrayList<String>();
                        ws_map.put(wk, titles);
                    }
                    titles.add(rc.getTitle());
                    i += 4;
                }
            }
            ++n2;
        }
        System.out.println("-- Trackers --");
        for (byte[] key : tk_map.keys()) {
            List titles = (List)tk_map.get(key);
            System.out.println(ByteFormatter.encodeString(key));
            for (String title : titles) {
                System.out.println("    " + title);
            }
        }
        System.out.println("-- Web Seeds --");
        for (byte[] key : ws_map.keys()) {
            List titles = (List)ws_map.get(key);
            System.out.println(ByteFormatter.encodeString(key));
            for (String title : titles) {
                System.out.println("    " + title);
            }
        }
    }

    protected static class ByteArrayHashMapEx<T>
    extends ByteArrayHashMap<T> {
        protected ByteArrayHashMapEx() {
        }

        public T getRandomValueExcluding(T excluded) {
            int num = RandomUtils.nextInt(this.size);
            T result = null;
            int j = 0;
            while (j < this.table.length) {
                ByteArrayHashMap.Entry e = this.table[j];
                while (e != null) {
                    Object value = e.value;
                    if (value != excluded) {
                        result = (T)value;
                    }
                    if (num <= 0 && result != null) {
                        return result;
                    }
                    --num;
                    e = e.next;
                }
                ++j;
            }
            return result;
        }
    }

    protected static class ContentCache {
        protected Map<String, DownloadInfo> related_content = new HashMap<String, DownloadInfo>();
        protected ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = new ByteArrayHashMapEx();

        protected ContentCache() {
        }
    }

    protected class DownloadInfo
    extends RelatedContent {
        private final int rand;
        private final int first_seen;
        private boolean unread;
        private int[] rand_list;
        private int last_seen;
        private int level;
        private boolean explicit;
        private ContentCache cc;

        protected DownloadInfo(int _version, byte[] _related_to, byte[] _hash, String _title, int _rand, String _tracker, byte[] _tracker_keys, byte[] _ws_keys, String[] _tags, byte _nets, int _first_seen, int _level, boolean _explicit, long _size, int _date, int _seeds_leechers) {
            super(_version, _related_to, _title, _hash, _tracker, _tracker_keys, _ws_keys, _tags, _nets, _size, _date, _seeds_leechers);
            this.unread = true;
            this.first_seen = _first_seen;
            this.rand = _rand;
            this.level = _level;
            this.explicit = _explicit;
            this.updateLastSeen();
        }

        protected DownloadInfo(int _version, byte[] _hash, String _title, int _rand, String _tracker, byte[] _tracker_keys, byte[] _ws_keys, String[] _tags, byte _nets, boolean _unread, int[] _rand_list, int _first_seen, int _last_seen, int _level, long _size, int _date, int _seeds_leechers, ContentCache _cc) {
            super(_version, _title, _hash, _tracker, _tracker_keys, _ws_keys, _tags, _nets, _size, _date, _seeds_leechers);
            this.unread = true;
            this.first_seen = _first_seen;
            this.rand = _rand;
            this.unread = _unread;
            this.rand_list = _rand_list;
            this.last_seen = _last_seen;
            this.level = _level;
            this.cc = _cc;
            if (this.rand_list != null && this.rand_list.length > 100) {
                int[] temp = new int[100];
                System.arraycopy(this.rand_list, 0, temp, 0, 100);
                this.rand_list = temp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean addInfo(DownloadInfo info) {
            byte existing_nets;
            byte other_nets;
            String[] other_tags;
            int d;
            int sl;
            boolean result = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.updateLastSeen();
                int r = info.getRand();
                if (this.rand_list == null) {
                    this.rand_list = new int[]{r};
                    result = true;
                } else {
                    boolean match = false;
                    int i = 0;
                    while (i < this.rand_list.length) {
                        if (this.rand_list[i] == r) {
                            match = true;
                            break;
                        }
                        ++i;
                    }
                    if (!match && this.rand_list.length < 100) {
                        int len = this.rand_list.length;
                        int[] new_rand_list = new int[len + 1];
                        System.arraycopy(this.rand_list, 0, new_rand_list, 0, len);
                        new_rand_list[len] = r;
                        this.rand_list = new_rand_list;
                        result = true;
                    }
                }
            }
            if (info.getVersion() > this.getVersion()) {
                this.setVersion(info.getVersion());
                result = true;
            }
            if (info.getLevel() < this.level) {
                this.level = info.getLevel();
                result = true;
            }
            if (info.getVersion() >= this.getVersion() && (sl = info.getSeedsLeechers()) != -1 && sl != this.getSeedsLeechers()) {
                this.setSeedsLeechers(sl);
                result = true;
            }
            if ((d = info.getDateHours()) > 0 && this.getDateHours() == 0) {
                this.setDateHours(d);
                result = true;
            }
            if ((other_tags = info.getTags()) != null && other_tags.length > 0) {
                String[] existing_tags = this.getTags();
                if (existing_tags == NO_TAGS) {
                    this.setTags(other_tags);
                    result = true;
                } else {
                    boolean same;
                    if (other_tags.length == existing_tags.length) {
                        if (existing_tags.length == 1) {
                            same = other_tags[0].equals(existing_tags[0]);
                        } else {
                            same = true;
                            int i = 0;
                            while (i < existing_tags.length) {
                                String e_tag = existing_tags[i];
                                boolean found = false;
                                int j = 0;
                                while (j < other_tags.length) {
                                    if (e_tag.equals(other_tags[j])) {
                                        found = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!found) {
                                    same = false;
                                    break;
                                }
                                ++i;
                            }
                        }
                    } else {
                        same = false;
                    }
                    if (!same) {
                        HashSet tags = new HashSet();
                        Collections.addAll(tags, existing_tags);
                        Collections.addAll(tags, other_tags);
                        this.setTags(tags.toArray(new String[tags.size()]));
                        result = true;
                    }
                }
            }
            if ((other_nets = info.getNetworksInternal()) != (existing_nets = this.getNetworksInternal())) {
                this.setNetworksInternal((byte)(other_nets | existing_nets));
                result = true;
            }
            if (result) {
                this.setChangedLocallyOn(0L);
            }
            return result;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        protected boolean isExplicit() {
            return this.explicit;
        }

        protected void setExplicit(boolean b) {
            this.explicit = b;
        }

        protected void updateLastSeen() {
            this.last_seen = (int)(SystemTime.getCurrentTime() / 1000L);
        }

        @Override
        public int getRank() {
            return this.rand_list == null ? 0 : this.rand_list.length;
        }

        @Override
        public boolean isUnread() {
            return this.unread;
        }

        protected void setPublic(ContentCache _cc) {
            this.cc = _cc;
            if (this.unread) {
                RelatedContentManager.this.incrementUnread();
            }
            this.rand_list = new int[]{this.rand};
            this.setChangedLocallyOn(0L);
        }

        @Override
        public int getLastSeenSecs() {
            return this.last_seen;
        }

        @Override
        public int getFirstSeenSecs() {
            return this.first_seen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setUnreadInternal(boolean _unread) {
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.unread = _unread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUnread(boolean _unread) {
            boolean changed = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                if (this.unread != _unread) {
                    this.unread = _unread;
                    changed = true;
                }
            }
            if (changed) {
                if (_unread) {
                    RelatedContentManager.this.incrementUnread();
                } else {
                    RelatedContentManager.this.decrementUnread();
                }
                this.setChangedLocallyOn(0L);
                RelatedContentManager.this.contentChanged(this);
            }
        }

        protected int getRand() {
            return this.rand;
        }

        protected int[] getRandList() {
            return this.rand_list;
        }

        @Override
        public Download getRelatedToDownload() {
            try {
                return RelatedContentManager.this.getDownload(this.getRelatedToHash());
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }

        @Override
        public void delete() {
            this.setChangedLocallyOn(0L);
            RelatedContentManager.this.delete(new RelatedContent[]{this});
        }

        @Override
        public String getString() {
            return String.valueOf(super.getString()) + ", " + this.rand + ", rl=" + Arrays.toString(this.rand_list) + ", last_seen=" + this.last_seen + ", level=" + this.level;
        }
    }

    protected static class RCMSearchXFer
    implements DistributedDatabaseTransferType {
        protected RCMSearchXFer() {
        }
    }

    private static class SecondaryLookup {
        private final byte[] hash;
        private final int level;
        private final byte nets;

        SecondaryLookup(byte[] _hash, int _level, byte _nets) {
            this.hash = _hash;
            this.level = _level;
            this.nets = _nets;
        }

        byte[] getHash() {
            return this.hash;
        }

        int getLevel() {
            return this.level;
        }

        byte getNetworks() {
            return this.nets;
        }
    }
}

