/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.config.impl;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.PriorityParameterListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.speedmanager.SpeedManager;

public final class TransferSpeedValidator {
    public static final String AUTO_UPLOAD_ENABLED_CONFIGKEY = "Auto Upload Speed Enabled";
    public static final String AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY = "Auto Upload Speed Seeding Enabled";
    public static final String UPLOAD_CONFIGKEY = "Max Upload Speed KBs";
    public static final String UPLOAD_SEEDING_CONFIGKEY = "Max Upload Speed Seeding KBs";
    public static final String DOWNLOAD_CONFIGKEY = "Max Download Speed KBs";
    public static final String UPLOAD_SEEDING_ENABLED_CONFIGKEY = "enable.seedingonly.upload.rate";
    public static final String[] CONFIG_PARAMS = new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled", "Max Upload Speed KBs", "Max Upload Speed Seeding KBs", "Max Download Speed KBs", "enable.seedingonly.upload.rate"};
    private final String configKey;
    private final Number configValue;
    static boolean auto_upload_enabled;
    static boolean auto_upload_seeding_enabled;
    static boolean seeding_upload_enabled;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{UPLOAD_SEEDING_ENABLED_CONFIGKEY, AUTO_UPLOAD_ENABLED_CONFIGKEY, AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY}, new PriorityParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                if (parameterName == null || parameterName.equals(TransferSpeedValidator.UPLOAD_SEEDING_ENABLED_CONFIGKEY)) {
                    seeding_upload_enabled = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.UPLOAD_SEEDING_ENABLED_CONFIGKEY);
                }
                if (parameterName == null || parameterName.equals(TransferSpeedValidator.AUTO_UPLOAD_ENABLED_CONFIGKEY)) {
                    auto_upload_enabled = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.AUTO_UPLOAD_ENABLED_CONFIGKEY);
                }
                if (parameterName == null || parameterName.equals(TransferSpeedValidator.AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY)) {
                    auto_upload_seeding_enabled = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY);
                }
            }
        });
    }

    public TransferSpeedValidator(String configKey, Number value) {
        this.configKey = configKey;
        this.configValue = value;
    }

    private static Object validate(String configKey, Number value) {
        int newValue = value.intValue();
        if (newValue < 0) {
            newValue = 0;
        }
        if (configKey == UPLOAD_CONFIGKEY) {
            int downValue = COConfigurationManager.getIntParameter(DOWNLOAD_CONFIGKEY);
            if (newValue != 0 && newValue < 5 && (downValue == 0 || downValue > newValue * 2)) {
                newValue = (downValue + 1) / 2;
            }
        } else if (configKey == DOWNLOAD_CONFIGKEY) {
            int upValue = COConfigurationManager.getIntParameter(UPLOAD_CONFIGKEY);
            if (upValue != 0 && upValue < 5) {
                if (newValue > upValue * 2) {
                    newValue = upValue * 2;
                } else if (newValue == 0) {
                    newValue = upValue * 2;
                }
            }
        } else if (configKey != UPLOAD_SEEDING_CONFIGKEY) {
            throw new IllegalArgumentException("Invalid Configuation Key; use key for max upload and max download");
        }
        return new Integer(newValue);
    }

    public Object getValue() {
        return TransferSpeedValidator.validate(this.configKey, this.configValue);
    }

    public static String getActiveUploadParameter(GlobalManager gm) {
        if (seeding_upload_enabled && gm.isSeedingOnly()) {
            return UPLOAD_SEEDING_CONFIGKEY;
        }
        return UPLOAD_CONFIGKEY;
    }

    public static String getDownloadParameter() {
        return DOWNLOAD_CONFIGKEY;
    }

    public static int getGlobalDownloadRateLimitBytesPerSecond() {
        return COConfigurationManager.getIntParameter(TransferSpeedValidator.getDownloadParameter()) * 1024;
    }

    public static void setGlobalDownloadRateLimitBytesPerSecond(int bytes_per_second) {
        COConfigurationManager.setParameter(TransferSpeedValidator.getDownloadParameter(), (bytes_per_second + 1023) / 1024);
    }

    public static boolean isAutoUploadAvailable(Core core) {
        if (core == null) {
            return false;
        }
        SpeedManager speedManager = core.getSpeedManager();
        return speedManager == null ? false : speedManager.isAvailable();
    }

    public static boolean isAutoSpeedActive(GlobalManager gm) {
        if (auto_upload_enabled) {
            return auto_upload_enabled;
        }
        if (gm.isSeedingOnly()) {
            return auto_upload_seeding_enabled;
        }
        return auto_upload_enabled;
    }

    public static String getActiveAutoUploadParameter(GlobalManager gm) {
        if (!auto_upload_enabled && gm.isSeedingOnly()) {
            return AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY;
        }
        return AUTO_UPLOAD_ENABLED_CONFIGKEY;
    }
}

