/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.config.impl;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.PriorityParameterListener;
import com.biglybt.core.config.impl.ConfigurationChecker;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.config.impl.ConfigurationParameterNotFoundException;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.ConcurrentHashMapWrapper;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConfigurationManager
implements AEDiagnosticsEvidenceGenerator {
    private static final boolean DEBUG_PARAMETER_LISTENERS = false;
    public static final String CONFIG_FILENAME = "biglybt.config";
    private static ConfigurationManager config_temp = null;
    private static ConfigurationManager config = null;
    private static final AEMonitor class_mon = new AEMonitor("ConfigMan:class");
    private ConcurrentHashMapWrapper<String, Object> propertiesMap;
    private final List transient_properties = new ArrayList();
    private final List<COConfigurationListener> listenerz = new ArrayList<COConfigurationListener>();
    private final Map<String, ParameterListener[]> parameterListenerz = new HashMap<String, ParameterListener[]>();
    private final Map<String, List<WeakReference<ParameterListener>>> weakParameterListenerz = new HashMap<String, List<WeakReference<ParameterListener>>>();
    private final List<COConfigurationManager.ResetToDefaultsListener> reset_to_def_listeners = new ArrayList<COConfigurationManager.ResetToDefaultsListener>();
    private static final FrequencyLimitedDispatcher dirty_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            COConfigurationManager.save();
        }
    }, 30000);
    private final ParameterListener exportable_parameter_listener = new ParameterListener(){

        @Override
        public void parameterChanged(String key) {
            ConfigurationManager.this.updateExportableParameter(key);
        }
    };
    private final Map<String, String[]> exported_parameters = new HashMap<String, String[]>();
    private final Map<String, String> imported_parameters = new HashMap<String, String>();
    private volatile boolean exported_parameters_dirty;

    public static ConfigurationManager getInstance() {
        try {
            class_mon.enter();
            if (config == null) {
                if (config_temp == null) {
                    config_temp = new ConfigurationManager();
                    config_temp.load();
                    config_temp.initialise();
                    config = config_temp;
                } else {
                    if (ConfigurationManager.config_temp.propertiesMap == null) {
                        config_temp.load();
                    }
                    ConfigurationManager configurationManager = config_temp;
                    return configurationManager;
                }
            }
            ConfigurationManager configurationManager = config;
            return configurationManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public static ConfigurationManager getInstance(Map data) {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager(data);
            }
            ConfigurationManager configurationManager = config;
            return configurationManager;
        }
        finally {
            class_mon.exit();
        }
    }

    private ConfigurationManager() {
    }

    private ConfigurationManager(Map data) {
        if (data.get("Logger.DebugFiles.Enabled") == null) {
            data.put("Logger.DebugFiles.Enabled", new Long(0L));
        }
        this.propertiesMap = new ConcurrentHashMapWrapper(data);
    }

    protected void initialise() {
        ConfigurationChecker.checkConfiguration();
        ConfigurationChecker.setSystemProperties();
        this.loadExportedParameters();
        AEDiagnostics.addWeakEvidenceGenerator(this);
    }

    public void load(String filename) {
        Map data = FileUtil.readResilientConfigFile(filename, false);
        if (this.propertiesMap == null) {
            ConcurrentHashMapWrapper c_map = new ConcurrentHashMapWrapper(data.size() + 256, 0.75f, 8);
            c_map.putAll(data);
            this.propertiesMap = c_map;
        }
    }

    public void load() {
        this.load(CONFIG_FILENAME);
        try {
            String[] keys;
            String[] stringArray = keys = this.propertiesMap.keySet().toArray(new String[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key != null && (key.startsWith("SideBar.Expanded.") || key.startsWith("NameColumn.wrapText."))) {
                    this.removeParameter(key);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) {
        ArrayList<COConfigurationListener> listeners_copy;
        if (this.propertiesMap == null) {
            return;
        }
        TreeMap<String, Object> properties_clone = this.propertiesMap.toTreeMap();
        if (!this.transient_properties.isEmpty()) {
            properties_clone.keySet().removeAll(this.transient_properties);
        }
        FileUtil.writeResilientConfigFile(filename, properties_clone);
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            listeners_copy = new ArrayList<COConfigurationListener>(this.listenerz);
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            COConfigurationListener l = (COConfigurationListener)listeners_copy.get(i);
            if (l != null) {
                try {
                    l.configurationSaved();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else {
                Debug.out("COConfigurationListener is null");
            }
            ++i;
        }
        if (this.exported_parameters_dirty) {
            this.exportParameters();
        }
    }

    public void save() {
        this.save(CONFIG_FILENAME);
    }

    public void setDirty() {
        dirty_dispatcher.dispatch();
    }

    public boolean isNewInstall() {
        return ConfigurationChecker.isNewInstall();
    }

    public Set<String> getDefinedParameters() {
        return new HashSet<String>(this.propertiesMap.keySet());
    }

    public boolean getBooleanParameter(String parameter, boolean defaultValue) {
        int defaultInt = defaultValue ? 1 : 0;
        int result = this.getIntParameter(parameter, defaultInt);
        return result != 0;
    }

    public boolean getBooleanParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, 0);
        }
        return result != 0;
    }

    public boolean setParameter(String parameter, boolean value) {
        return this.setParameter(parameter, value ? 1 : 0);
    }

    private Long getLongParameterRaw(String parameter) {
        try {
            return (Long)this.propertiesMap.get(parameter);
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return null;
        }
    }

    public int getIntParameter(String parameter, int defaultValue) {
        Long tempValue = this.getLongParameterRaw(parameter);
        return tempValue != null ? tempValue.intValue() : defaultValue;
    }

    public int getIntParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, 0);
        }
        return result;
    }

    public long getLongParameter(String parameter, long defaultValue) {
        Long tempValue = this.getLongParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    public long getLongParameter(String parameter) {
        long result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getLongParameter(parameter, def.getLongParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getLongParameter(parameter, 0L);
        }
        return result;
    }

    private byte[] getByteParameterRaw(String parameter) {
        return (byte[])this.propertiesMap.get(parameter);
    }

    public byte[] getByteParameter(String parameter) {
        byte[] result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getByteParameter(parameter, def.getByteParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getByteParameter(parameter, ConfigurationDefaults.def_bytes);
        }
        return result;
    }

    public byte[] getByteParameter(String parameter, byte[] defaultValue) {
        byte[] tempValue = this.getByteParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    private String getStringParameter(String parameter, byte[] defaultValue) {
        byte[] bp = this.getByteParameter(parameter, defaultValue);
        if (bp == null) {
            bp = this.getByteParameter(parameter, null);
        }
        if (bp == null) {
            return null;
        }
        return ConfigurationManager.bytesToString(bp);
    }

    public String getStringParameter(String parameter, String defaultValue) {
        String tempValue = this.getStringParameter(parameter, (byte[])null);
        return tempValue != null ? tempValue : defaultValue;
    }

    public String getStringParameter(String parameter) {
        String result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getStringParameter(parameter, def.getStringParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getStringParameter(parameter, "");
        }
        return result;
    }

    public List<String> getStringListParameter(String parameter) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList != null) {
                return BDecoder.decodeStrings(new ArrayList(rawList));
            }
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
        }
        return new ArrayList<String>();
    }

    public List getListParameter(String parameter, List def) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return def;
            }
            return rawList;
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return def;
        }
    }

    public boolean setParameter(String parameter, List value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public Map getMapParameter(String parameter, Map def) {
        try {
            Map map = (Map)this.propertiesMap.get(parameter);
            if (map == null) {
                return def;
            }
            return map;
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return def;
        }
    }

    public boolean setParameter(String parameter, Map value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getDirectoryParameter(String parameter) throws IOException {
        String dir = this.getStringParameter(parameter);
        if (dir.length() > 0) {
            File temp = FileUtil.newFile(dir, new String[0]);
            if (!temp.exists()) {
                FileUtil.mkdirs(temp);
            }
            if (!temp.isDirectory()) {
                throw new IOException("Configuration error. This is not a directory: " + dir);
            }
        }
        return dir;
    }

    public float getFloatParameter(String parameter) {
        return this.getFloatParameter(parameter, 0.0f);
    }

    public float getFloatParameter(String parameter, float def_val) {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            Object o = this.propertiesMap.get(parameter);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            String s = this.getStringParameter(parameter);
            if (!s.equals("")) {
                return Float.parseFloat(s);
            }
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
        }
        try {
            return def.getFloatParameter(parameter);
        }
        catch (Exception e2) {
            return def_val;
        }
    }

    public boolean setParameter(String parameter, float defaultValue) {
        String newValue = String.valueOf(defaultValue);
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(newValue));
    }

    public boolean setParameter(String parameter, int defaultValue) {
        Long newValue = new Long(defaultValue);
        try {
            Long oldValue = (Long)this.propertiesMap.put(parameter, newValue);
            return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, long defaultValue) {
        Long newValue = new Long(defaultValue);
        try {
            Long oldValue = (Long)this.propertiesMap.put(parameter, newValue);
            return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, byte[] defaultValue) {
        try {
            byte[] oldValue = (byte[])this.propertiesMap.put(parameter, defaultValue);
            return this.notifyParameterListenersIfChanged(parameter, defaultValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, String defaultValue) {
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(defaultValue));
    }

    public boolean hasParameter(String key, boolean explicit) {
        if (this.propertiesMap.containsKey(key)) {
            return true;
        }
        return !explicit && ConfigurationDefaults.getInstance().hasParameter(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyParameter(String parameter, String value) {
        List verifiers = ConfigurationDefaults.getInstance().getVerifiers(parameter);
        if (verifiers == null) return true;
        try {
            int i = 0;
            while (true) {
                if (i >= verifiers.size()) {
                    return true;
                }
                COConfigurationManager.ParameterVerifier verifier = (COConfigurationManager.ParameterVerifier)verifiers.get(i);
                if (verifier != null) {
                    try {
                        if (!verifier.verify(parameter, value)) {
                            return false;
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return true;
    }

    public boolean setRGBParameter(String parameter, int red, int green, int blue, Boolean override) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".red", red);
        bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".green", green);
        bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".blue", blue);
        if (override != null) {
            bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".override", override);
        }
        if (bAnyChanged) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean setRGBParameter(String parameter, int[] rgb, Boolean override) {
        if (rgb != null) {
            if (rgb.length < 3) {
                System.err.println("Invalid array for setRGBParameter(\"" + parameter + "\", " + Arrays.toString(rgb) + ", " + override);
                return false;
            }
            return this.setRGBParameter(parameter, rgb[0], rgb[1], rgb[2], override);
        }
        boolean changed = false;
        changed |= this.removeParameter(String.valueOf(parameter) + ".override");
        changed |= this.removeParameter(String.valueOf(parameter) + ".red");
        changed |= this.removeParameter(String.valueOf(parameter) + ".green");
        if (changed |= this.removeParameter(String.valueOf(parameter) + ".blue")) {
            this.notifyParameterListeners(parameter);
        }
        return changed;
    }

    public int[] getRGBParameter(String parameter) {
        int r = this.getIntParameter(String.valueOf(parameter) + ".red", -1);
        int g = this.getIntParameter(String.valueOf(parameter) + ".green", -1);
        int b = this.getIntParameter(String.valueOf(parameter) + ".blue", -1);
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            return null;
        }
        return new int[]{r, g, b};
    }

    public Object getParameter(String name) {
        Object value = this.propertiesMap.get(name);
        if (value == null) {
            value = ConfigurationDefaults.getInstance().getParameter(name);
        }
        return value;
    }

    public void setParameterRawNoNotify(String parameter, Object value) {
        this.propertiesMap.put(parameter, value);
    }

    public void registerTransientParameter(String param) {
        this.transient_properties.add(param);
    }

    public boolean removeParameter(String parameter) {
        boolean removed;
        boolean bl = removed = this.propertiesMap.remove(parameter) != null;
        if (removed) {
            this.notifyParameterListeners(parameter);
        }
        return removed;
    }

    public boolean removeRGBParameter(String parameter) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.removeParameter(String.valueOf(parameter) + ".red");
        bAnyChanged |= this.removeParameter(String.valueOf(parameter) + ".green");
        bAnyChanged |= this.removeParameter(String.valueOf(parameter) + ".blue");
        if (bAnyChanged |= this.removeParameter(String.valueOf(parameter) + ".override")) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean doesParameterNonDefaultExist(String parameter) {
        return this.propertiesMap.containsKey(parameter);
    }

    private boolean notifyParameterListenersIfChanged(String parameter, Long newValue, Long oldValue) {
        if (oldValue == null || newValue.compareTo(oldValue) != 0) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private boolean notifyParameterListenersIfChanged(String parameter, byte[] newValue, byte[] oldValue) {
        if (oldValue == null || !Arrays.equals(newValue, oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResetToDefaultsListener(COConfigurationManager.ResetToDefaultsListener l) {
        List<COConfigurationManager.ResetToDefaultsListener> list = this.reset_to_def_listeners;
        synchronized (list) {
            this.reset_to_def_listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExportedParameter(String name, String key) {
        Map<String, String[]> map = this.exported_parameters;
        synchronized (map) {
            String[] entry = this.exported_parameters.get(key);
            if (entry == null) {
                entry = new String[]{name, this.imported_parameters.remove(name)};
                this.exported_parameters.put(key, entry);
            }
        }
        this.addParameterListener(key, this.exportable_parameter_listener);
        this.updateExportableParameter(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateExportableParameter(String key) {
        String value;
        Object o_value = this.getParameter(key);
        if (o_value == null) {
            value = null;
        } else if (o_value instanceof byte[]) {
            try {
                value = new String((byte[])o_value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value = null;
            }
        } else {
            value = String.valueOf(o_value);
        }
        Map<String, String[]> map = this.exported_parameters;
        synchronized (map) {
            String existing;
            String[] entry = this.exported_parameters.get(key);
            if (!(entry == null || (existing = entry[1]) == value || existing != null && value != null && existing.equals(value))) {
                entry[1] = value;
                if (!this.exported_parameters_dirty) {
                    this.exported_parameters_dirty = true;
                    new DelayedEvent("epd", 5000L, new AERunnable(){

                        @Override
                        public void runSupport() {
                            ConfigurationManager.this.exportParameters();
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportParameters() {
        Map<String, String[]> map = this.exported_parameters;
        synchronized (map) {
            if (!this.exported_parameters_dirty) {
                return;
            }
            this.exported_parameters_dirty = false;
            try {
                String key;
                TreeMap<String, String> tm = new TreeMap<String, String>();
                HashSet<String> exported_keys = new HashSet<String>();
                for (String[] stringArray : this.exported_parameters.values()) {
                    key = stringArray[0];
                    String value = stringArray[1];
                    exported_keys.add(key);
                    if (value == null) continue;
                    tm.put(key, value);
                }
                for (Map.Entry entry : this.imported_parameters.entrySet()) {
                    key = (String)entry.getKey();
                    if (exported_keys.contains(key)) continue;
                    tm.put(key, (String)entry.getValue());
                }
                File file = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
                File props = FileUtil.newFile(file, "exported_params.properties");
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)FileUtil.newFileOutputStream(props), "UTF-8"));){
                    for (Map.Entry entry : tm.entrySet()) {
                        pw.println(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExportedParameters() {
        Map<String, String[]> map = this.exported_parameters;
        synchronized (map) {
            block10: {
                try {
                    File parent_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
                    File props = FileUtil.newFile(parent_dir, "exported_params.properties");
                    if (!props.exists()) break block10;
                    try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)FileUtil.newFileInputStream(props), "UTF-8"));){
                        String line;
                        while ((line = lnr.readLine()) != null) {
                            String[] bits = line.split("=");
                            if (bits.length != 2) continue;
                            String key = bits[0].trim();
                            String value = bits[1].trim();
                            if (key.length() <= 0 || value.length() <= 0) continue;
                            this.imported_parameters.put(key, value);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        COConfigurationManager.setIntDefault("instance.port", Constants.INSTANCE_PORT);
        this.registerExportedParameter("instance.port", "instance.port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToDefaults() {
        ArrayList<COConfigurationManager.ResetToDefaultsListener> listeners;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        ArrayList<String> def_names = new ArrayList<String>(def.getAllowedParameters());
        for (String s : def_names) {
            if (this.propertiesMap.remove(s) == null) continue;
            this.notifyParameterListeners(s);
        }
        List<COConfigurationManager.ResetToDefaultsListener> list = this.reset_to_def_listeners;
        synchronized (list) {
            listeners = new ArrayList<COConfigurationManager.ResetToDefaultsListener>(this.reset_to_def_listeners);
        }
        for (COConfigurationManager.ResetToDefaultsListener l : listeners) {
            try {
                l.reset();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyParameterListeners(String parameter) {
        ParameterListener[] listeners;
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            listeners = this.parameterListenerz.get(parameter);
        }
        ArrayList<ParameterListener> listListeners = null;
        Map<String, List<WeakReference<ParameterListener>>> map2 = this.weakParameterListenerz;
        synchronized (map2) {
            List<WeakReference<ParameterListener>> temp = this.weakParameterListenerz.get(parameter);
            if (temp != null) {
                Iterator<WeakReference<ParameterListener>> iterator = temp.iterator();
                while (iterator.hasNext()) {
                    ParameterListener listener = (ParameterListener)iterator.next().get();
                    if (listener == null) {
                        iterator.remove();
                        continue;
                    }
                    if (listListeners == null) {
                        listListeners = new ArrayList<ParameterListener>(temp.size() + (listeners == null ? 0 : listeners.length));
                    }
                    if (listeners != null && !(listener instanceof PriorityParameterListener)) {
                        Collections.addAll(listListeners, listeners);
                        listeners = null;
                    }
                    listListeners.add(listener);
                }
            }
        }
        if (listListeners != null) {
            for (ParameterListener listener : listListeners) {
                if (listener == null) continue;
                try {
                    listener.parameterChanged(parameter);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (listeners != null) {
            ParameterListener[] parameterListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterListener listener;
                listener = parameterListenerArray[n2];
                if (listener != null) {
                    try {
                        listener.parameterChanged(parameter);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakParameterListener(String parameter, ParameterListener new_listener) {
        if (parameter == null || new_listener == null) {
            return;
        }
        Map<String, List<WeakReference<ParameterListener>>> map = this.weakParameterListenerz;
        synchronized (map) {
            List<WeakReference<ParameterListener>> listeners = this.weakParameterListenerz.get(parameter);
            if (listeners == null) {
                listeners = new ArrayList<WeakReference<ParameterListener>>(1);
                listeners.add(new WeakReference<ParameterListener>(new_listener));
                this.weakParameterListenerz.put(parameter, listeners);
            } else {
                if (Constants.IS_CVS_VERSION && listeners.size() > 100) {
                    Debug.out(parameter);
                }
                Iterator<WeakReference<ParameterListener>> iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ParameterListener listener = (ParameterListener)iterator.next().get();
                    if (listener == null) {
                        iterator.remove();
                    }
                    if (listener != new_listener) continue;
                    return;
                }
                WeakReference<ParameterListener> weakRef = new WeakReference<ParameterListener>(new_listener);
                if (new_listener instanceof PriorityParameterListener) {
                    listeners.add(0, weakRef);
                } else {
                    listeners.add(weakRef);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWeakParameterListener(String parameter, ParameterListener listener) {
        Map<String, List<WeakReference<ParameterListener>>> map = this.weakParameterListenerz;
        synchronized (map) {
            List<WeakReference<ParameterListener>> list = this.weakParameterListenerz.get(parameter);
            if (list != null) {
                Iterator<WeakReference<ParameterListener>> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ParameterListener existing = (ParameterListener)iterator.next().get();
                    if (existing == null) {
                        iterator.remove();
                        continue;
                    }
                    if (existing != listener) continue;
                    iterator.remove();
                    break;
                }
                if (list.size() == 0) {
                    this.weakParameterListenerz.remove(parameter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterListener(String parameter, ParameterListener new_listener) {
        if (parameter == null || new_listener == null) {
            return;
        }
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            ParameterListener[] listeners = this.parameterListenerz.get(parameter);
            if (listeners == null) {
                this.parameterListenerz.put(parameter, new ParameterListener[]{new_listener});
            } else {
                int pos;
                ParameterListener[] new_listeners = new ParameterListener[listeners.length + 1];
                if (Constants.IS_CVS_VERSION && listeners.length > 100) {
                    Debug.out(parameter);
                }
                if (new_listener instanceof PriorityParameterListener) {
                    new_listeners[0] = new_listener;
                    pos = 1;
                } else {
                    new_listeners[listeners.length] = new_listener;
                    pos = 0;
                }
                int i = 0;
                while (i < listeners.length) {
                    ParameterListener existing_listener = listeners[i];
                    if (existing_listener == new_listener) {
                        return;
                    }
                    new_listeners[pos++] = existing_listener;
                    ++i;
                }
                this.parameterListenerz.put(parameter, new_listeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterListener(String parameter, ParameterListener listener) {
        if (parameter == null || listener == null) {
            return;
        }
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            ParameterListener[] listeners = this.parameterListenerz.get(parameter);
            if (listeners == null) {
                return;
            }
            if (listeners.length == 1) {
                if (listeners[0] == listener) {
                    this.parameterListenerz.remove(parameter);
                }
            } else {
                ParameterListener[] new_listeners = new ParameterListener[listeners.length - 1];
                int pos = 0;
                int i = 0;
                while (i < listeners.length) {
                    ParameterListener existing_listener = listeners[i];
                    if (existing_listener != listener) {
                        if (pos == new_listeners.length) {
                            return;
                        }
                        new_listeners[pos++] = existing_listener;
                    }
                    ++i;
                }
                this.parameterListenerz.put(parameter, new_listeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(COConfigurationListener listener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndFireListener(COConfigurationListener listener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.add(listener);
        }
        try {
            listener.configurationSaved();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(COConfigurationListener listener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.remove(listener);
        }
    }

    private boolean ignoreKeyForDump(String key) {
        String lc_key = key.toLowerCase(Locale.US);
        if (key.startsWith("core.crypto.") || lc_key.equals("id") || lc_key.equals("azbuddy.dchat.optsmap") || lc_key.endsWith(".privx") || lc_key.endsWith(".user") || lc_key.contains("password") || lc_key.contains("username") || lc_key.contains("session key")) {
            return true;
        }
        Object value = this.propertiesMap.get(key);
        if (value instanceof byte[]) {
            try {
                value = new String((byte[])value, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value instanceof String && ((String)value).toLowerCase(Locale.US).endsWith(".b32.i2p");
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Configuration Details");
        try {
            writer.indent();
            writer.println("version=3.4.0.0, subver=");
            writer.println("System Properties");
            try {
                writer.indent();
                Properties props = System.getProperties();
                for (String string : new TreeSet<Object>(props.keySet())) {
                    writer.println(String.valueOf(string) + "=" + props.get(string));
                }
            }
            finally {
                writer.exdent();
            }
            writer.println("Environment");
            try {
                writer.indent();
                Map<String, String> env = System.getenv();
                if (env == null) {
                    writer.println("Not supported");
                } else {
                    for (String string : new TreeSet<String>(env.keySet())) {
                        writer.println(String.valueOf(string) + "=" + env.get(string));
                    }
                }
            }
            finally {
                writer.exdent();
            }
            writer.println(String.valueOf(Constants.APP_NAME) + " Config");
            ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
            try {
                writer.indent();
                TreeSet<String> keys = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                keys.addAll(this.propertiesMap.keySet());
                for (String key : keys) {
                    if (this.ignoreKeyForDump(key)) continue;
                    Object value = this.propertiesMap.get(key);
                    boolean bParamExists = defaults.doesParameterDefaultExist(key.toString());
                    if (!bParamExists) {
                        key = "[NoDef] " + key;
                    } else {
                        Object def = defaults.getParameter(key);
                        if (def != null && value != null && !BEncoder.objectsAreIdentical(def, value)) {
                            key = "-> " + key;
                        }
                    }
                    if (value instanceof Long) {
                        writer.println(String.valueOf(key) + "=" + value);
                        continue;
                    }
                    if (value instanceof List) {
                        writer.println(String.valueOf(key) + "=" + BDecoder.decodeStrings((List)BEncoder.clone(value)) + "[list]");
                        continue;
                    }
                    if (value instanceof Map) {
                        writer.println(String.valueOf(key) + "=" + BDecoder.decodeStrings((Map)BEncoder.clone(value)) + "[map]");
                        continue;
                    }
                    if (value instanceof byte[]) {
                        byte[] b = (byte[])value;
                        boolean hex = false;
                        int i = 0;
                        while (i < b.length) {
                            char c = (char)b[i];
                            if (!Character.isLetterOrDigit(c) && "\\ `\u00c2\u00ac\"\u00c2\u00a3$%^&*()-_=+[{]};:'@#~,<.>/?'".indexOf(c) == -1) {
                                hex = true;
                                break;
                            }
                            ++i;
                        }
                        writer.println(String.valueOf(key) + "=" + (hex ? ByteFormatter.nicePrint(b) : ConfigurationManager.bytesToString((byte[])value)));
                        continue;
                    }
                    writer.println(String.valueOf(key) + "=" + value + "[unknown]");
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void dumpConfigChanges(IndentWriter writer) {
        ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
        TreeSet<String> keys = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        keys.addAll(this.propertiesMap.keySet());
        for (String key : keys) {
            Object def;
            if (this.ignoreKeyForDump(key)) continue;
            Object value = this.propertiesMap.get(key);
            boolean bParamExists = defaults.doesParameterDefaultExist(key.toString());
            if (!bParamExists || (def = defaults.getParameter(key)) == null || value == null || BEncoder.objectsAreIdentical(def, value)) continue;
            if (value instanceof Long) {
                writer.println(String.valueOf(key) + "=" + value);
                continue;
            }
            if (value instanceof List) {
                writer.println(String.valueOf(key) + "=" + BDecoder.decodeStrings((List)BEncoder.clone(value)) + "[list]");
                continue;
            }
            if (value instanceof Map) {
                writer.println(String.valueOf(key) + "=" + BDecoder.decodeStrings((Map)BEncoder.clone(value)) + "[map]");
                continue;
            }
            if (value instanceof byte[]) {
                byte[] b = (byte[])value;
                boolean hex = false;
                int i = 0;
                while (i < b.length) {
                    char c = (char)b[i];
                    if (!Character.isLetterOrDigit(c) && "\\ `\u00c2\u00ac\"\u00c2\u00a3$%^&*()-_=+[{]};:'@#~,<.>/?'".indexOf(c) == -1) {
                        hex = true;
                        break;
                    }
                    ++i;
                }
                writer.println(String.valueOf(key) + "=" + (hex ? ByteFormatter.nicePrint(b) : ConfigurationManager.bytesToString((byte[])value)));
                continue;
            }
            writer.println(String.valueOf(key) + "=" + value + "[unknown]");
        }
    }

    protected static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, Constants.DEFAULT_ENCODING_CHARSET);
        }
        catch (Throwable e) {
            return new String(bytes);
        }
    }

    protected static byte[] stringToBytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(Constants.DEFAULT_ENCODING_CHARSET);
        }
        catch (Throwable e) {
            return str.getBytes();
        }
    }
}

