/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.category.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryListener;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.category.impl.CategoryManagerImpl;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.impl.TagBase;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class CategoryImpl
extends TagBase
implements Category,
Comparable,
TagDownload,
TagListener {
    final String sName;
    private final int type;
    private final CopyOnWriteList<DownloadManager> managers_cow = new CopyOnWriteList();
    int upload_speed;
    int download_speed;
    private final Object UPLOAD_PRIORITY_KEY = new Object();
    private final Map<String, String> attributes;
    private static final AtomicInteger tag_ids = new AtomicInteger();
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "cat_up: " + CategoryImpl.this.sName;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.upload_speed;
        }

        @Override
        public boolean isDisabled() {
            return CategoryImpl.this.upload_speed == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "cat_down: " + CategoryImpl.this.sName;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.download_speed;
        }

        @Override
        public boolean isDisabled() {
            return CategoryImpl.this.download_speed == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private boolean destroyed;
    private static final int LDT_CATEGORY_DMADDED = 1;
    private static final int LDT_CATEGORY_DMREMOVED = 2;
    private final ListenerManager<CategoryListener> category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher<CategoryListener>(){

        @Override
        public void dispatch(CategoryListener target, int type, Object value) {
            if (type == 1) {
                target.downloadManagerAdded(CategoryImpl.this, (DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved(CategoryImpl.this, (DownloadManager)value);
            }
        }
    });

    protected CategoryImpl(CategoryManagerImpl manager, String sName, int maxup, int maxdown, Map<String, String> _attributes) {
        super(manager, tag_ids.incrementAndGet(), sName);
        this.addTag();
        this.sName = sName;
        this.type = 0;
        this.setGroup(MessageText.getString("TableColumn.header.category"));
        this.upload_speed = maxup;
        this.download_speed = maxdown;
        this.attributes = _attributes;
        this.addTagListener(this, true);
    }

    protected CategoryImpl(CategoryManagerImpl manager, String sName, int type, Map<String, String> _attributes) {
        super(manager, tag_ids.incrementAndGet(), sName);
        this.addTag();
        this.sName = sName;
        this.type = type;
        this.setGroup(MessageText.getString("TableColumn.header.category"));
        this.attributes = _attributes;
    }

    @Override
    public void addCategoryListener(CategoryListener l) {
        if (!this.category_listeners.hasListener(l)) {
            this.category_listeners.addListener(l);
        }
    }

    @Override
    public void removeCategoryListener(CategoryListener l) {
        this.category_listeners.removeListener(l);
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean[] isTagAuto() {
        if (this.getType() == 0) {
            return new boolean[3];
        }
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        return blArray;
    }

    @Override
    public List<DownloadManager> getDownloadManagers(List<DownloadManager> all_dms) {
        if (this.type == 0) {
            return this.managers_cow.getList();
        }
        if (this.type == 1 || all_dms == null) {
            return all_dms;
        }
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        int i = 0;
        while (i < all_dms.size()) {
            DownloadManager dm = all_dms.get(i);
            Category cat = dm.getDownloadState().getCategory();
            if (cat == null || cat.getType() == 2) {
                result.add(dm);
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addManager(DownloadManagerState manager_state) {
        boolean do_add;
        Category manager_cat = manager_state.getCategory();
        if (this.type != 2 && manager_cat != this || this.type == 2 && manager_cat != null) {
            manager_state.setCategory(this);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        CopyOnWriteList<DownloadManager> copyOnWriteList = this.managers_cow;
        synchronized (copyOnWriteList) {
            boolean bl = do_add = !this.managers_cow.contains(manager);
            if (do_add && this.type == 0) {
                this.managers_cow.add(manager);
            }
        }
        if (do_add) {
            manager.addRateLimiter(this.upload_limiter, true);
            manager.addRateLimiter(this.download_limiter, false);
        }
        super.addTaggable(manager);
        if (do_add) {
            this.category_listeners.dispatch(1, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeManager(DownloadManagerState manager_state) {
        boolean do_remove;
        if (manager_state.getCategory() == this) {
            manager_state.setCategory(null);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        CopyOnWriteList<DownloadManager> copyOnWriteList = this.managers_cow;
        synchronized (copyOnWriteList) {
            boolean bl = do_remove = this.type != 0 || this.managers_cow.contains(manager);
            if (do_remove) {
                this.managers_cow.remove(manager);
            }
        }
        if (do_remove) {
            manager.removeRateLimiter(this.upload_limiter, true);
            manager.removeRateLimiter(this.download_limiter, false);
        }
        super.removeTaggable(manager);
        if (do_remove) {
            this.category_listeners.dispatch(2, manager);
        }
    }

    @Override
    public void addTaggable(Taggable t) {
        DownloadManager dm = (DownloadManager)t;
        this.addManager(dm.getDownloadState());
    }

    @Override
    public void removeTaggable(Taggable t) {
        DownloadManager dm = (DownloadManager)t;
        this.removeManager(dm.getDownloadState());
    }

    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        DownloadManager manager = (DownloadManager)tagged;
        int pri = this.getIntAttribute("at_up_pri", -1);
        if (pri > 0) {
            manager.updateAutoUploadPriority(this.UPLOAD_PRIORITY_KEY, true);
        }
    }

    @Override
    public void taggableSync(Tag tag) {
    }

    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
        DownloadManager manager = (DownloadManager)tagged;
        int pri = this.getIntAttribute("at_up_pri", -1);
        if (pri > 0) {
            manager.updateAutoUploadPriority(this.UPLOAD_PRIORITY_KEY, false);
        }
    }

    @Override
    public void setDownloadSpeed(int speed) {
        if (this.download_speed != speed) {
            this.download_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getDownloadSpeed() {
        return this.download_speed;
    }

    @Override
    public void setUploadSpeed(int speed) {
        if (this.upload_speed != speed) {
            this.upload_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getUploadSpeed() {
        return this.upload_speed;
    }

    protected void setAttributes(Map<String, String> a) {
        this.attributes.clear();
        this.attributes.putAll(a);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getStringAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setStringAttribute(String name, String value) {
        String old = this.attributes.put(name, value);
        if (old == null || !old.equals(value)) {
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getIntAttribute(String name) {
        return this.getIntAttribute(name, 0);
    }

    private int getIntAttribute(String name, int def) {
        String str = this.getStringAttribute(name);
        if (str == null) {
            return def;
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setIntAttribute(String name, int value) {
        String str_val = String.valueOf(value);
        String old = this.attributes.put(name, str_val);
        if (old == null || !old.equals(str_val)) {
            if (name.equals("at_up_pri")) {
                for (DownloadManager dm : this.managers_cow) {
                    dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_KEY, value > 0);
                }
            }
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public boolean getBooleanAttribute(String name) {
        String str = this.getStringAttribute(name);
        return str != null && str.equals("true");
    }

    @Override
    public void setBooleanAttribute(String name, boolean value) {
        String str_val = value ? "true" : "false";
        String old = this.attributes.put(name, str_val);
        if (old == null || !old.equals(str_val)) {
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getTaggableTypes() {
        return 2;
    }

    @Override
    public String getTagName(boolean localize) {
        if (localize && (this.type == 1 || this.type == 2)) {
            return MessageText.getString(this.getTagNameRaw());
        }
        return super.getTagName(localize);
    }

    @Override
    public boolean supportsTagRates() {
        return false;
    }

    @Override
    public boolean supportsTagUploadLimit() {
        return true;
    }

    @Override
    public boolean supportsTagDownloadLimit() {
        return true;
    }

    @Override
    public int getTagUploadLimit() {
        return this.getUploadSpeed();
    }

    @Override
    public void setTagUploadLimit(int bps) {
        this.setUploadSpeed(bps);
    }

    @Override
    public int getTagCurrentUploadRate() {
        return -1;
    }

    @Override
    public int getTagDownloadLimit() {
        return this.getDownloadSpeed();
    }

    @Override
    public void setTagDownloadLimit(int bps) {
        this.setDownloadSpeed(bps);
    }

    @Override
    public int getTagCurrentDownloadRate() {
        return -1;
    }

    @Override
    public int getTagUploadPriority() {
        if (this.type == 0) {
            return this.getIntAttribute("at_up_pri");
        }
        return -1;
    }

    @Override
    public void setTagUploadPriority(int priority) {
        this.setIntAttribute("at_up_pri", priority);
    }

    @Override
    public boolean getCanBePublicDefault() {
        return this.type == 0;
    }

    @Override
    public boolean supportsTagTranscode() {
        return false;
    }

    @Override
    public String[] getTagTranscodeTarget() {
        return null;
    }

    @Override
    public void setTagTranscodeTarget(String uid, String display_name) {
    }

    @Override
    public Set<DownloadManager> getTaggedDownloads() {
        Core core = CoreFactory.getSingleton();
        if (!core.isStarted()) {
            return new IdentityHashSet<DownloadManager>();
        }
        return new IdentityHashSet<DownloadManager>(this.getDownloadManagers(core.getGlobalManager().getDownloadManagers()));
    }

    @Override
    public Set<Taggable> getTagged() {
        return this.getTaggedDownloads();
    }

    @Override
    public int getTaggedCount() {
        return this.getTagged().size();
    }

    @Override
    public boolean hasTaggable(Taggable t) {
        if (!(t instanceof DownloadManager)) {
            return false;
        }
        if (this.type == 0) {
            return this.managers_cow.contains((DownloadManager)t);
        }
        if (this.type == 1) {
            return true;
        }
        DownloadManager dm = (DownloadManager)t;
        Category cat = dm.getDownloadState().getCategory();
        return cat == null || cat.getType() == 2;
    }

    @Override
    public int getRunStateCapabilities() {
        return 0;
    }

    @Override
    public boolean hasRunStateCapability(int capability) {
        return false;
    }

    @Override
    public boolean[] getPerformableOperations(int[] ops) {
        return new boolean[ops.length];
    }

    @Override
    public List<Taggable> performOperation(int op) {
        Debug.out("derp");
        return new ArrayList<Taggable>();
    }

    @Override
    protected void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.removeTagListener(this);
            this.removeTag();
        }
    }

    @Override
    public void removeTag() {
        CategoryManager.removeCategory(this);
        super.removeTag();
    }

    public int compareTo(Object b) {
        boolean bTypeIsUser;
        boolean aTypeIsUser = this.type == 0;
        boolean bl = bTypeIsUser = ((Category)b).getType() == 0;
        if (aTypeIsUser == bTypeIsUser) {
            return this.sName.compareToIgnoreCase(((Category)b).getName());
        }
        if (aTypeIsUser) {
            return 1;
        }
        return -1;
    }

    @Override
    public void dump(IndentWriter writer) {
        if (this.upload_speed != 0) {
            writer.println("up=" + this.upload_speed);
        }
        if (this.download_speed != 0) {
            writer.println("down=" + this.download_speed);
        }
        if (this.attributes.size() > 0) {
            writer.println("attributes: " + this.attributes);
        }
    }
}

