/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.backup.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.backup.BackupManager;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.custom.CustomizationManagerFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.update.UpdateInstaller;
import java.io.BufferedInputStream;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class BackupManagerImpl
implements BackupManager {
    private static BackupManagerImpl singleton;
    private final Core core;
    private final AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean first_schedule_check = true;
    private TimerEvent backup_event;
    private long last_auto_backup;
    volatile boolean closing;

    public static synchronized BackupManager getSingleton(Core core) {
        if (singleton == null) {
            singleton = new BackupManagerImpl(core);
        }
        return singleton;
    }

    private BackupManagerImpl(Core _core) {
        this.core = _core;
        COConfigurationManager.addParameterListener(new String[]{"br.backup.auto.enable", "br.backup.auto.everydays", "br.backup.auto.retain"}, new ParameterListener(){
            COConfigurationListener save_listener;
            final Object lock = this;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameter) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.save_listener == null) {
                        this.save_listener = new COConfigurationListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void configurationSaved() {
                                BackupManagerImpl.this.checkSchedule();
                                COConfigurationManager.removeListener(this);
                                Object object = lock;
                                synchronized (object) {
                                    if (save_listener == this) {
                                        save_listener = null;
                                    }
                                }
                            }
                        };
                        COConfigurationManager.addListener(this.save_listener);
                    }
                }
            }
        });
        this.checkSchedule();
        this.core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void stopping(Core core) {
                BackupManagerImpl.this.closing = true;
            }
        });
    }

    @Override
    public long getLastBackupTime() {
        return COConfigurationManager.getLongParameter("br.backup.last.time", 0L);
    }

    @Override
    public String getLastBackupError() {
        return COConfigurationManager.getStringParameter("br.backup.last.error", "");
    }

    void checkSchedule() {
        this.checkSchedule(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSchedule(final BackupManager.BackupListener _listener, boolean force) {
        final BackupManager.BackupListener listener = new BackupManager.BackupListener(){

            @Override
            public boolean reportProgress(String str) {
                if (_listener != null) {
                    try {
                        return _listener.reportProgress(str);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                return true;
            }

            @Override
            public void reportError(Throwable error) {
                if (_listener != null) {
                    try {
                        _listener.reportError(error);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void reportComplete() {
                if (_listener != null) {
                    try {
                        _listener.reportComplete();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        boolean enabled = COConfigurationManager.getBooleanParameter("br.backup.auto.enable");
        boolean do_backup = false;
        BackupManagerImpl backupManagerImpl = this;
        synchronized (backupManagerImpl) {
            long check_period;
            long utc_next_backup;
            if (this.backup_event != null) {
                this.backup_event.cancel();
                this.backup_event = null;
            }
            if (this.first_schedule_check) {
                String current_ver;
                String last_ver;
                if (!enabled && !(last_ver = COConfigurationManager.getStringParameter("br.backup.config.info.ver", "")).equals(current_ver = "3.4.0.0")) {
                    COConfigurationManager.setParameter("br.backup.config.info.ver", current_ver);
                    Logger.log(new LogAlert(false, 0, MessageText.getString("br.backup.setup.info")));
                }
                this.first_schedule_check = false;
                if (!force) {
                    if (enabled) {
                        this.backup_event = SimpleTimer.addEvent("BM:startup", SystemTime.getCurrentTime() + 300000L, new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                BackupManagerImpl.this.checkSchedule();
                            }
                        });
                    }
                    return;
                }
            }
            if (!enabled) {
                listener.reportError(new Exception("Auto-backup not enabled"));
                return;
            }
            long now_utc = SystemTime.getCurrentTime();
            int offset = TimeZone.getDefault().getOffset(now_utc);
            long now_local = now_utc + (long)offset;
            long HOUR = 3600000L;
            long DAY = 24L * HOUR;
            long local_day_index = now_local / DAY;
            long local_hour_index = now_local / HOUR;
            long last_auto_backup_day = COConfigurationManager.getLongParameter("br.backup.auto.last_backup_day", 0L);
            long last_auto_backup_hour = COConfigurationManager.getLongParameter("br.backup.auto.last_backup_hour", 0L);
            if (last_auto_backup_day > local_day_index) {
                last_auto_backup_day = local_day_index;
            }
            if (last_auto_backup_hour > local_hour_index) {
                last_auto_backup_hour = local_hour_index;
            }
            long backup_every_days = COConfigurationManager.getLongParameter("br.backup.auto.everydays");
            long backup_every_hours = COConfigurationManager.getLongParameter("br.backup.auto.everyhours");
            if ((backup_every_days = Math.max(0L, backup_every_days)) == 0L) {
                backup_every_hours = Math.max(1L, backup_every_hours);
                utc_next_backup = (last_auto_backup_hour + backup_every_hours) * HOUR;
                check_period = 600000L;
            } else {
                utc_next_backup = (last_auto_backup_day + backup_every_days) * DAY;
                check_period = 14400000L;
            }
            long time_to_next_backup = utc_next_backup - now_local;
            if (time_to_next_backup <= 0L || force) {
                if (now_utc - this.last_auto_backup >= check_period || force) {
                    do_backup = true;
                    this.last_auto_backup = now_utc;
                    COConfigurationManager.setParameter("br.backup.auto.last_backup_day", local_day_index);
                    COConfigurationManager.setParameter("br.backup.auto.last_backup_hour", local_hour_index);
                } else {
                    time_to_next_backup = check_period;
                }
            }
            if (!do_backup) {
                time_to_next_backup = Math.max(time_to_next_backup, 60000L);
                listener.reportProgress("Scheduling next backup in " + TimeFormatter.format(time_to_next_backup / 1000L));
                this.backup_event = SimpleTimer.addEvent("BM:auto", now_utc + time_to_next_backup, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        BackupManagerImpl.this.checkSchedule();
                    }
                });
            }
        }
        if (do_backup) {
            String backup_dir = COConfigurationManager.getStringParameter("br.backup.auto.dir", "");
            listener.reportProgress("Auto backup starting: folder=" + backup_dir);
            final File target_dir = FileUtil.newFile(backup_dir, new String[0]);
            this.backup(target_dir, new BackupManager.BackupListener(){

                @Override
                public boolean reportProgress(String str) {
                    return listener.reportProgress(str);
                }

                @Override
                public void reportComplete() {
                    try {
                        System.out.println("Auto backup completed");
                        COConfigurationManager.save();
                        if (COConfigurationManager.getBooleanParameter("br.backup.notify")) {
                            Logger.log(new LogAlert(true, 0, "Backup completed at " + new Date()));
                        }
                        int backup_retain = COConfigurationManager.getIntParameter("br.backup.auto.retain");
                        backup_retain = Math.max(1, backup_retain);
                        File[] backups = target_dir.listFiles();
                        ArrayList<File> backup_dirs = new ArrayList<File>();
                        File[] fileArray = backups;
                        int n = backups.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File test_file;
                            File f = fileArray[n2];
                            if (f.isDirectory() && BackupManagerImpl.this.getBackupDirTime(f) > 0L && (test_file = FileUtil.newFile(f, "biglybt.config")).exists()) {
                                backup_dirs.add(f);
                            }
                            ++n2;
                        }
                        Collections.sort(backup_dirs, new Comparator<File>(){

                            @Override
                            public int compare(File o1, File o2) {
                                long t1 = BackupManagerImpl.this.getBackupDirTime(o1);
                                long t2 = BackupManagerImpl.this.getBackupDirTime(o2);
                                long res = t2 - t1;
                                if (res < 0L) {
                                    return -1;
                                }
                                if (res > 0L) {
                                    return 1;
                                }
                                Debug.out("hmm: " + o1 + "/" + o2);
                                return 0;
                            }
                        });
                        int i = backup_retain;
                        while (i < backup_dirs.size()) {
                            File f = (File)backup_dirs.get(i);
                            listener.reportProgress("Deleting old backup: " + f);
                            FileUtil.recursiveDeleteNoCheck(f);
                            ++i;
                        }
                    }
                    finally {
                        listener.reportComplete();
                        BackupManagerImpl.this.checkSchedule();
                    }
                }

                @Override
                public void reportError(Throwable error) {
                    try {
                        listener.reportProgress("Auto backup failed");
                        Logger.log(new LogAlert(true, 3, "Backup failed at " + new Date(), error));
                    }
                    finally {
                        listener.reportError(error);
                        BackupManagerImpl.this.checkSchedule();
                    }
                }
            });
        } else {
            listener.reportError(new Exception("Backup not scheduled to run now"));
        }
    }

    @Override
    public void runAutoBackup(BackupManager.BackupListener listener) {
        this.checkSchedule(listener, true);
    }

    @Override
    public void backup(final File parent_folder, final BackupManager.BackupListener _listener) {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                BackupManager.BackupListener listener = new BackupManager.BackupListener(){

                    @Override
                    public boolean reportProgress(String str) {
                        return _listener.reportProgress(str);
                    }

                    @Override
                    public void reportComplete() {
                        try {
                            this.setStatus("");
                        }
                        finally {
                            _listener.reportComplete();
                        }
                    }

                    @Override
                    public void reportError(Throwable error) {
                        try {
                            this.setStatus(Debug.getNestedExceptionMessage(error));
                        }
                        finally {
                            _listener.reportError(error);
                        }
                    }
                };
                BackupManagerImpl.this.backupSupport(parent_folder, listener);
            }

            void setStatus(String error) {
                COConfigurationManager.setParameter("br.backup.last.time", SystemTime.getCurrentTime());
                COConfigurationManager.setParameter("br.backup.last.error", error);
            }
        });
    }

    private void checkClosing() throws Exception {
        if (this.closing) {
            throw new Exception("operation cancelled, app is closing");
        }
    }

    private long[] copyFiles(File from_file, File to_file) throws Exception {
        return this.copyFilesSupport(from_file, to_file, 1);
    }

    private long[] copyFilesSupport(File from_file, File to_file, int depth) throws Exception {
        long total_files = 0L;
        long total_copied = 0L;
        if (depth > 32) {
            throw new Exception("Backup path too deep, abandoning");
        }
        if (from_file.isDirectory()) {
            boolean skip = false;
            File parent = from_file.getParentFile();
            String parent_name = parent == null ? "" : parent.getName();
            String name = from_file.getName();
            if (parent_name.equals("aznettorbrowser")) {
                if (name.startsWith("browser_")) {
                    skip = true;
                }
            } else if (parent_name.equals("azwebtorrent") && (name.equals("data") || name.startsWith("browser_"))) {
                skip = true;
            }
            if (!skip) {
                if (!to_file.mkdirs()) {
                    throw new Exception("Failed to create '" + to_file.getAbsolutePath() + "'");
                }
                File[] files = from_file.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        this.checkClosing();
                        long[] temp = this.copyFilesSupport(f, FileUtil.newFile(to_file, f.getName()), depth + 1);
                        total_files += temp[0];
                        total_copied += temp[1];
                        ++n2;
                    }
                }
            }
        } else {
            if (!FileUtil.copyFileWithDates(from_file, to_file)) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable skip) {
                    // empty catch block
                }
                if (!FileUtil.copyFileWithDates(from_file, to_file)) {
                    String name = from_file.getName().toLowerCase(Locale.US);
                    if (name.startsWith(".lock") || name.startsWith(".azlock") || name.startsWith("lock") || name.equals("stats.lck") || name.endsWith(".saving") || name.endsWith(".gz") || name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".dll") || name.endsWith(".so") || FileUtil.containsPathSegment(from_file, "cache", false) || FileUtil.containsPathSegment(from_file, "azneti2phelper" + File.separator + "netdb", false) || FileUtil.containsPathSegment(from_file, "azneti2phelper" + File.separator + "peerprofiles", false)) {
                        return new long[]{total_files, total_copied};
                    }
                    throw new Exception("Failed to copy file '" + from_file + "'");
                }
            }
            total_copied = from_file.length();
        }
        return new long[]{++total_files, total_copied};
    }

    long getBackupDirTime(File file) {
        String name = file.getName();
        int pos = name.indexOf(".");
        long suffix = 0L;
        if (pos != -1) {
            try {
                suffix = Integer.parseInt(name.substring(pos + 1));
                name = name.substring(0, pos);
            }
            catch (Throwable e) {
                return -1L;
            }
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(name).getTime() + suffix;
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    void backupSupport(File parent_folder, final BackupManager.BackupListener _listener) {
        try {
            String date_dir = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            File backup_folder = null;
            boolean ok = false;
            try {
                File[] user_files;
                this.checkClosing();
                if (parent_folder.getName().length() == 0 || !parent_folder.isDirectory()) {
                    throw new Exception("Backup folder '" + parent_folder + "' is invalid");
                }
                BackupManager.BackupListener listener = new BackupManager.BackupListener(){

                    @Override
                    public boolean reportProgress(String str) {
                        if (!_listener.reportProgress(str)) {
                            throw new RuntimeException("Operation abandoned by listener");
                        }
                        return true;
                    }

                    @Override
                    public void reportComplete() {
                        _listener.reportComplete();
                    }

                    @Override
                    public void reportError(Throwable error) {
                        _listener.reportError(error);
                    }
                };
                int max_suffix = -1;
                String[] existing = parent_folder.list();
                if (existing != null) {
                    String[] stringArray = existing;
                    int n = existing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ex = stringArray[n2];
                        if (ex.startsWith(date_dir)) {
                            int pos = ex.indexOf(".");
                            if (pos >= 0) {
                                try {
                                    max_suffix = Math.max(max_suffix, Integer.parseInt(ex.substring(pos + 1)));
                                }
                                catch (Throwable throwable) {}
                            } else if (max_suffix == -1) {
                                max_suffix = 0;
                            }
                        }
                        ++n2;
                    }
                }
                int i = max_suffix + 1;
                while (i < 100) {
                    File test_file;
                    String test_dir = date_dir;
                    if (i > 0) {
                        test_dir = String.valueOf(test_dir) + "." + i;
                    }
                    if (!(test_file = FileUtil.newFile(parent_folder, test_dir)).exists()) {
                        backup_folder = test_file;
                        backup_folder.mkdirs();
                        break;
                    }
                    ++i;
                }
                if (backup_folder == null) {
                    backup_folder = FileUtil.newFile(parent_folder, date_dir);
                }
                File user_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
                File temp_dir = backup_folder;
                while (temp_dir != null) {
                    if (temp_dir.equals(user_dir)) {
                        throw new Exception("Backup folder '" + backup_folder + "' is not permitted to be within the configuration folder '" + user_dir + "'.\r\nSelect an alternative location.");
                    }
                    temp_dir = temp_dir.getParentFile();
                }
                listener.reportProgress("Writing to " + backup_folder.getAbsolutePath());
                if (!backup_folder.exists() && !backup_folder.mkdirs()) {
                    throw new Exception("Failed to create '" + backup_folder.getAbsolutePath() + "'");
                }
                listener.reportProgress("Syncing current state");
                this.core.saveState();
                listener.reportProgress("Reading configuration data from " + user_dir.getAbsolutePath());
                File[] fileArray = user_files = user_dir.listFiles();
                int n = user_files.length;
                int n3 = 0;
                while (n3 < n) {
                    block33: {
                        String name;
                        File f;
                        block34: {
                            block32: {
                                f = fileArray[n3];
                                this.checkClosing();
                                name = f.getName();
                                if (!f.isDirectory()) break block32;
                                if (name.equals("cache") || name.equals("tmp") || name.equals("logs") || name.equals("updates") || name.equals("debug")) break block33;
                                if (!name.equals("plugins") || COConfigurationManager.getBooleanParameter("br.restore.doplugins")) break block34;
                                listener.reportProgress("Not backing up plugins due to configuration settings");
                                break block33;
                            }
                            if (name.equals(".lock") || name.equals(".azlock") || name.equals("update.properties") || name.endsWith(".log")) break block33;
                        }
                        File dest_file = FileUtil.newFile(backup_folder, name);
                        listener.reportProgress("Copying '" + name + "' ...");
                        long[] result = this.copyFiles(f, dest_file);
                        String result_str = DisplayFormatters.formatByteCountToKiBEtc(result[1]);
                        if (result[0] > 1L) {
                            result_str = String.valueOf(result[0]) + " files, " + result_str;
                        }
                        listener.reportProgress(result_str);
                    }
                    ++n3;
                }
                listener.reportComplete();
                ok = true;
            }
            catch (Throwable throwable) {
                if (!ok && backup_folder != null) {
                    FileUtil.recursiveDeleteNoCheck(backup_folder);
                }
                throw throwable;
            }
            if (!ok && backup_folder != null) {
                FileUtil.recursiveDeleteNoCheck(backup_folder);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            _listener.reportError(e);
        }
    }

    @Override
    public void restore(final File backup_folder, final BackupManager.BackupListener listener) {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                BackupManagerImpl.this.restoreSupport(backup_folder, listener);
            }
        });
    }

    private void addActions(UpdateInstaller installer, File source, File target) throws Exception {
        if (source.isDirectory()) {
            File[] files;
            File[] fileArray = files = source.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.addActions(installer, f, FileUtil.newFile(target, f.getName()));
                ++n2;
            }
        } else {
            installer.addMoveAction(source.getAbsolutePath(), target.getAbsolutePath());
        }
    }

    private int patch(Map<String, Object> map, String from, String to) {
        int mods = 0;
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        while (it.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            Object new_value = value = entry.getValue();
            if (value instanceof Map) {
                mods += this.patch((Map)value, from, to);
            } else if (value instanceof List) {
                mods += this.patch((List)value, from, to);
            } else if (value instanceof byte[]) {
                try {
                    String str = new String((byte[])value, "UTF-8");
                    if (str.startsWith(from)) {
                        new_value = String.valueOf(to) + str.substring(from.length());
                        ++mods;
                    }
                }
                catch (Throwable str) {
                    // empty catch block
                }
            }
            if (key.startsWith(from)) {
                String new_key = String.valueOf(to) + key.substring(from.length());
                ++mods;
                it.remove();
                replacements.put(new_key, new_value);
                continue;
            }
            if (value == new_value) continue;
            entry.setValue(new_value);
        }
        map.putAll(replacements);
        return mods;
    }

    private int patch(List list, String from, String to) {
        int mods = 0;
        int i = 0;
        while (i < list.size()) {
            Object entry = list.get(i);
            if (entry instanceof Map) {
                mods += this.patch((Map)entry, from, to);
            } else if (entry instanceof List) {
                mods += this.patch((List)entry, from, to);
            } else if (entry instanceof byte[]) {
                try {
                    String str = new String((byte[])entry, "UTF-8");
                    if (str.startsWith(from)) {
                        list.set(i, String.valueOf(to) + str.substring(from.length()));
                        ++mods;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        return mods;
    }

    void restoreSupport(File backup_folder, BackupManager.BackupListener listener) {
        try {
            UpdateInstaller installer = null;
            File temp_dir = null;
            boolean ok = false;
            try {
                File f;
                listener.reportProgress("Reading from " + backup_folder.getAbsolutePath());
                if (!backup_folder.isDirectory()) {
                    throw new Exception("Location '" + backup_folder.getAbsolutePath() + "' must be a directory");
                }
                listener.reportProgress("Analysing backup");
                File config = FileUtil.newFile(backup_folder, "biglybt.config");
                if (!config.exists()) {
                    throw new Exception("Invalid backup: biglybt.config not found");
                }
                Map<String, Object> config_map = BDecoder.decode(FileUtil.readFileAsByteArray(config));
                byte[] temp = (byte[])config_map.get("azureus.user.directory");
                if (temp == null) {
                    throw new Exception("Invalid backup: biglybt.config doesn't contain user directory details");
                }
                File current_user_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
                File backup_user_dir = FileUtil.newFile(new String(temp, "UTF-8"), new String[0]);
                listener.reportProgress("Current user directory:\t" + current_user_dir.getAbsolutePath());
                listener.reportProgress("Backup's user directory:\t" + backup_user_dir.getAbsolutePath());
                temp_dir = AETemporaryFileHandler.createTempDir();
                PluginInterface pi = this.core.getPluginManager().getDefaultPluginInterface();
                installer = pi.getUpdateManager().createInstaller();
                File[] files = backup_folder.listFiles();
                if (COConfigurationManager.getBooleanParameter("br.restore.autopause")) {
                    File cf = CustomizationManagerFactory.getSingleton().getNewUserCustomizationFile("restore_ap");
                    FileUtil.writeStringAsFile(cf, "Pause\\ Downloads\\ On\\ Start\\ After\\ Resume=bool:true");
                }
                if (current_user_dir.equals(backup_user_dir)) {
                    listener.reportProgress("Directories are the same, no patching required");
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        f = fileArray[n2];
                        File source = FileUtil.newFile(temp_dir, f.getName());
                        listener.reportProgress("Creating restore action for '" + f.getName() + "'");
                        this.copyFiles(f, source);
                        File target = FileUtil.newFile(current_user_dir, f.getName());
                        this.addActions(installer, source, target);
                        ++n2;
                    }
                } else {
                    listener.reportProgress("Directories are different, backup requires patching");
                    File[] fileArray = files;
                    int n = files.length;
                    int n3 = 0;
                    while (n3 < n) {
                        f = fileArray[n3];
                        File source = FileUtil.newFile(temp_dir, f.getName());
                        listener.reportProgress("Creating restore action for '" + f.getName() + "'");
                        if (f.isDirectory() || !f.getName().contains(".config")) {
                            this.copyFiles(f, source);
                        } else {
                            boolean patched;
                            block38: {
                                patched = false;
                                BufferedInputStream bis = new BufferedInputStream(FileUtil.newFileInputStream(f), 0x100000);
                                try {
                                    try {
                                        int applied;
                                        Map<String, Object> m = BDecoder.decode(bis);
                                        bis.close();
                                        bis = null;
                                        if (m.size() > 0 && (applied = this.patch(m, backup_user_dir.getAbsolutePath(), current_user_dir.getAbsolutePath())) > 0) {
                                            listener.reportProgress("    Applied " + applied + " patches");
                                            patched = FileUtil.writeBytesAsFile2(source.getAbsolutePath(), BEncoder.encode(m));
                                            if (!patched) {
                                                throw new Exception("Failed to write " + source);
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        String name = f.getName();
                                        if (!name.contains(".bad") && !name.contains(".bak")) {
                                            throw e;
                                        }
                                        listener.reportProgress("    Ignored failure to patch bad configuration file");
                                        if (bis != null) {
                                            try {
                                                bis.close();
                                            }
                                            catch (Throwable throwable) {}
                                        }
                                        break block38;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (bis != null) {
                                        try {
                                            bis.close();
                                        }
                                        catch (Throwable throwable2) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                if (bis != null) {
                                    try {
                                        bis.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!patched) {
                                this.copyFiles(f, source);
                            }
                        }
                        File target = FileUtil.newFile(current_user_dir, f.getName());
                        this.addActions(installer, source, target);
                        ++n3;
                    }
                }
                listener.reportProgress("Restore action creation complete, restart required to complete the operation");
                listener.reportComplete();
                ok = true;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    if (installer != null) {
                        installer.destroy();
                    }
                    if (temp_dir != null) {
                        FileUtil.recursiveDeleteNoCheck(temp_dir);
                    }
                }
                throw throwable;
            }
            if (!ok) {
                if (installer != null) {
                    installer.destroy();
                }
                if (temp_dir != null) {
                    FileUtil.recursiveDeleteNoCheck(temp_dir);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            listener.reportError(e);
        }
    }
}

