/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.GenericValue;

/**
 *  Superclass of Let For Case clauses.
 * 
 */
public class VarClause extends Expression {

    public QName variable;
    public Type  varType;
    public LocalVariable varDecl;
    public Expression  expr;		// source
    public Expression  owner;		// FLWR, quantifiedExpr, typeswitch
    protected boolean checked = false;

    public VarClause( QName variable ) {
        this.variable = variable;
    }

    public boolean visit(Visitor v) {
	return v.examine(this) && expr.visit(v);
    }

    public void dump( ExprDump d ) {
	d.header( this, "VarClause" );
        d.display("variable", variable);
        d.display("varAddress", varDecl.address);
        d.display("varType", varType);
        d.display("expr", expr);
    }

    public Expression staticCheck( StaticContext context ) {
	if(checked)
	    return this;	// because of the insertion of a let before it
	checked = true;
	varDecl = context.defineLocalVariable(variable, varType, this);
	// check expression AFTER (pb with register allocation)
	expr = context.staticCheck( expr, 0 );
	
	type = varType;	// used for dynamic check (let)
	if(varType == null)
	    varDecl.type = varType = expr.getType();
	else if( !varType.accepts(expr.getType()) ) 
	    context.error( this, "incompatible value type %2 for variable %1",
			   context.prefixedName(variable),
			   expr.getType().toString(context));
	varDecl.defineType(varType);
	return this;
    }

    // dummy sequence used as source for FLWR pipeline
    // also root class of For and Let sequences
    public static class Sequence extends GenericValue
    {
	Value source;	// outer clause
	EvalContext context;
	Focus focus;
	boolean done = false;

	Sequence( Focus focus, EvalContext context ) {
	    this.focus = focus;
	    this.context = context;
	}

	void setSource( Value source ) {
	    this.source = source;
	}

	public Item   asItem() throws TypeException {
	    return item;	// dummy
	}

	// single shot sequence
	public boolean next() throws XQueryException {
	    if(done)
		return false;
	    return done = true;
	}

	public Value  bornAgain() {
	    return new Sequence( focus, context );
	}
    }
}
