/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class ValueGeOp: 
 * 
 */
public class ValueGeOp extends ValueComparison {

    public ValueGeOp( Expression expr1, Expression expr2 ) {
        super( expr1, expr2 );
    }

    public void dump( ExprDump d ) {
	d.header( this, "ge" );
        d.display("expr1", operands[0]);
        d.display("expr2", operands[1]);
    }

    protected DecisionMaker getDecisionMaker() {
	return COMP;
    }

    static DecisionMaker COMP = new DecisionMaker() {
	    public boolean make( int diff ) {
		
		return diff >= 0 && diff != Item.INCOMPARABLE;
	    }

	    public DecisionMaker reverse() {
		return ValueLeOp.COMP;
	    }
	};
}
