/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class TreatExpr: 
 * 
 */
public class TreatExpr extends CastExpr {

    public TreatExpr( Expression expr, Type targetType ) {
        super(expr, targetType);
    }

    public void dump( ExprDump d ) {
	d.header( this, "TreatExpr" );
        d.display("targetType", targetType);
        d.display("expr", expr);
    }

    public Expression staticCheck( StaticContext context ) {
	expr = context.staticCheck( expr, 0 );
	if( !expr.getType().accepts( targetType ) )
	    context.error(this, "static type of expression [%1] not compatible with %2",
			  expr.getType().toString(context), targetType.toString(context));
	type = targetType;
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
        Value v = expr.eval(focus, context);
	try {
	    v = targetType.check(v);
	} catch(TypeException e) {
	    context.error(this, e);
	}
	return v;
    }
}
