/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleString;

/**
 *	Superclass of expressions returning String.
 *	
 */
public abstract class StringExpression extends Expression
{
    // redefined above the 'abstract' evalAsBoolean
    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
        return new SingleString(evalAsString(focus, context));
    }

    public abstract String evalAsString( Focus focus, EvalContext context) throws XQueryException;

} // end of class StringExpression


