/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  class QuantifiedExpr: 
 */
public class QuantifiedExpr extends BooleanExpression {

    public boolean  every;
    Expression[] varClauses = new Expression[0];
    public Expression cond;

    public QuantifiedExpr( boolean every ) {
        this.every = every;
    }

    public void  addVarClause( Expression varClause ) {
        varClauses = addExpr(varClauses, varClause);
    }

    Expression  getVarClause( int rank ) {
        return rank < 0 || rank >= varClauses.length ? null : varClauses[rank];
    }

    public boolean visit( Visitor v ) {
	return v.examine(this) && v.visit(varClauses) && cond.visit(v);
    }

    public void dump( ExprDump d ) {
	d.header( this, "QuantifiedExpr" );
        d.display("every", ""+every);
        d.display("varClauses", varClauses);
        d.display("cond", cond);
    }

    public Expression staticCheck( StaticContext context ) {
	LocalVariable mark = context.markLocalVariables();
	for(int c = 0; c < varClauses.length; c ++) 
	    context.staticCheck( getVarClause(c), 0 );
	cond = context.staticCheck(cond, 0);
	type = Type.BOOLEAN;	// no check: effective bool value
	context.popLocalVariables(mark);
	return this;
    }

    public boolean evalAsBoolean( Focus focus, EvalContext context )
	throws XQueryException {
	// dummy iterator as init stub:
	VarClause.Sequence source = new VarClause.Sequence(focus, context);
	for(int c = 0; c < varClauses.length; c ++) { 
	    VarClause.Sequence newSrc =
		(VarClause.Sequence) getVarClause(c).eval( focus, context );
	    newSrc.setSource(source);
	    source = newSrc;
	}
	if( every )
	    for (;;) {
		if(!source.next())
		    return true;
		if( !cond.evalEffectiveBooleanValue( focus, context ) )
		    return false;
	    }
	else
	    for (;;) {
		if(!source.next())
		    return false;
		if( cond.evalEffectiveBooleanValue( focus, context ) )
		    return true;
	    }
    }
}
