/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleQName;

/**
 *  class QNameLiteral: 
 * 
 */
public class QNameLiteral extends Expression {

    public QName  name;

    public QNameLiteral( QName name ) {
        this.name = name;
	type = Type.QNAME;
    }

    public boolean visit( Visitor v ) {
	return v.examine(this);
    }

    public void dump( ExprDump d ) {
	d.header( this, "QNameLiteral '"+name+"'" );
    }

    public Expression staticCheck( StaticContext context ) {
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	return new SingleQName( name );
    }

    public QName evalAsQName( Focus focus, EvalContext context ) throws XQueryException {
	return name;
    }
}
