/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;

/**
 * 	Operator 'is'.
 */
public class IsOp extends NodeComparison {

    public IsOp( Expression expr1, Expression expr2 ) {
        super( expr1, expr2 );
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	Value n1 = expr1.eval( focus, context );
	Value n2 = expr2.eval( focus, context );
	return (!n1.next() || !n2.next()) ? Value.empty
	    : new SingleBoolean(n1.asNode().orderCompare(n2.asNode()) == 0);
    }

    public boolean evalAsBoolean( Focus focus, EvalContext context ) throws XQueryException {
	Value n1 = expr1.eval( focus, context );
	Value n2 = expr2.eval( focus, context );
	return (!n1.next() || !n2.next()) ? false : n1.asNode().orderCompare(n2.asNode()) == 0;
    }
}
