/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.GenericValue;

/**
 * 
 */
public class IntersectOp extends NodeExpression {

    public IntersectOp( Expression expr1, Expression expr2 ) {
	super(expr1, expr2);
    }

    public void dump( ExprDump d ) {
	d.header( this, "IntersectOp" );
        d.display("expr1", expr1);
        d.display("expr2", expr2);
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new Sequence( expr1.eval(focus, context), expr2.eval(focus, context));
    }

    public class Sequence  extends GenericValue
    {
	Value  s1, s2;
	Node n1, n2;	// current nodes in s1 s2

	Sequence( Value s1, Value s2 ) throws XQueryException {
	    this.s1 = s1; this.s2 = s2; 
	    n1 = s1.next() ? s1.asNode() : null;
	    n2 = s2.next() ? s2.asNode() : null;
	}

	// assumes that s1 and s2 are in doc order
	public boolean next() throws XQueryException {

	    for (;;) {
		// is one sequence finished ?
		if(n1 == null || n2 == null)
		    return false;
		// we have an item in both sequences:
		int cmp = n1.orderCompare(n2);
		item = n1;	// aka n2 if cmp == 0
		if(cmp <= 0) {
		    n1 = s1.next() ? s1.asNode() : null;
		}
		if(cmp >= 0) {
		    n2 = s2.next() ? s2.asNode() : null;
		}
		if(cmp == 0)
		    return true;
	    }
	}

	public Value  bornAgain() {
	    try {
		return new Sequence(s1.bornAgain(), s2.bornAgain());
	    } catch(XQueryException e) {
		return null; 	// cannot happen
	    }
	}
    }
}
