/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  class DocumentConstructor: 
 * 
 */
public class DocumentConstructor extends NodeConstructor {

    public DocumentConstructor( Expression expr ) {
        contents = new Expression[] { expr };
	type = Type.DOCUMENT;
    }

    public void dump( ExprDump d ) {
	d.header( this, "DocumentConstructor" );
        d.display("contents", contents);
    }

    public Node evalAsNode( Focus focus, EvalContext context ) throws XQueryException {

	EventDrivenBuilder builder = new EventDrivenBuilder();
	try {
	    evalAsEvents( builder, focus, context );
	    return builder.crop();
        }
        catch (DataModelException e) {
	    e.printStackTrace(); return null;// should not happen
	}
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException  {
	context.at(this);
	try {
	    output.startDocument();
	    for(int c = 0; c < contents.length; c++) {
		contents[c].evalAsEvents(output, focus, context);
	    }	
	    output.endDocument();
	}
	catch(DataModelException e) {
	    context.error(this, "error in constructor: " + e.getMessage());
	}
    }
}
