/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import java.math.BigDecimal;
import net.xfra.qizxopen.xquery.dt.SingleDecimal;

/**
 *  Implementation of decimal literals. 
 */
public class DecimalLiteral extends Expression {

    public BigDecimal  value;

    public DecimalLiteral( BigDecimal value ) {
        this.value = value;
	type = Type.DECIMAL;
    }

    public boolean visit(Visitor v) {
	return v.examine(this);
    }

    public void dump( ExprDump d ) {
	d.header( this, "DecimalLiteral" );
        d.display("value", ""+value);
    }

    public Expression staticCheck( StaticContext context ) {
	return this;
    }

    public int getFlags() {
	return CONSTANT;
    }

    public Value eval( Focus focus, EvalContext context) throws XQueryException {
	return new SingleDecimal(value) ;
    }
}
