/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 *  Superclass of all comparison operators. 
 * 
 */
public abstract class Comparison extends Expression {

    public Expression[]  operands;

    public Comparison( Expression expr1, Expression expr2 ) {
        operands = new Expression[] { expr1, expr2 };
    }

    protected interface DecisionMaker {
	// diff is -1 if lt, 0 if eq, 1 if gt
	boolean make( int diff );

	DecisionMaker reverse();
    }

    protected abstract Prototype[] getProtos();
    protected abstract DecisionMaker getDecisionMaker();

    public boolean visit( Visitor v ) {
	return v.examine(this) && operands[0].visit(v) && operands[1].visit(v);
    }

    public Expression staticCheck( StaticContext context ) {
	operands[0] = context.staticCheck( operands[0], 0 );
	operands[1] = context.staticCheck( operands[1], 0 );
        Exec exec = (Exec) context.resolve( getProtos(), operands, this );
	exec.decision = getDecisionMaker();
	return exec;
    }

    public abstract static class Exec extends Function.BoolCall {
	DecisionMaker decision;

	public void dump( ExprDump d ) {
	    d.header( this, ""+prototype );
	    d.display("left", args[0]);
	    d.display("op", decision.toString());
	    d.display("right", args[1]);
	}

	public boolean isEq() {
	    return decision == ValueEqOp.COMP;
	}
    }

    public boolean evalAsEffectiveBoolean( Focus focus, EvalContext context )
	throws XQueryException{
	return evalAsBoolean(focus, context);
    }
}
