/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;

/**
 *  Implementation of operator 'castable as'.  
 */
public class CastableExpr extends CastExpr {

    public CastableExpr( Expression expr, Type targetType ) {
        super(expr, targetType);
    }

    public void dump( ExprDump d ) {
	d.header( this, "CastableExpr" );
        d.display("expr", expr);
        d.display("type", type);
    }

    public Expression staticCheck( StaticContext context ) {
	expr = context.staticCheck( expr, 0 );
        type = Type.BOOLEAN;
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new SingleBoolean( evalAsBoolean( focus, context ) );
    }

    public boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException
    {
	Value v = expr.eval(focus, context);
	context.at(this);
	if(!v.next())
	    return isOptional;
	try {
	    targetType.cast(v, context);
	    return !v.next();	// must be singleton
	}
        catch (TypeException e) {
            return false;
        }
    }
}
