/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of constructors for TEXT, COMMENT. 
 */
public class AtomConstructor extends NodeConstructor {

    public int  kind;

    public AtomConstructor( int kind, Expression contents ) {
        this.kind = kind;
        this.contents = (contents == null)? new Expression[0] : new Expression[]{contents};
	type = Type.TEXT;
	if(kind == Node.COMMENT)
	    type = Type.COMMENT;
    }

    public void dump( ExprDump d ) {
	d.header( this, "AtomConstructor" );
        d.display("kind", ""+kind);
        d.display("contents", contents);
    }

    public Node evalAsNode( Focus focus, EvalContext context ) throws XQueryException {
	Node node;
	if(kind == Node.TEXT)
	    node = CoreDataModel.newTextNode();
	else if(kind == Node.COMMENT)
	    node = CoreDataModel.newCommentNode();
        else throw new RuntimeException("bad AtomConstructor");
	boolean first = true;
	for(int c = 0; c < contents.length; c++) {
	    Value cont = contents[c].eval(focus, context);
	    for(; cont.next(); ) {
		if(!first)
		    node.addText(" ");
		first = false;
		node.addText( cont.asString() );
	    }
	}
	return node;
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException  {
	context.at(this);

	if(kind == Node.TEXT) {
	    for(int c = 0; c < contents.length; c++) {
		Value cont = contents[c].eval(focus, context);
		for(; cont.next(); ) 
		    output.atom( cont.asString() );
	    }
	    return;
	}

	StringBuffer buf = new StringBuffer();
	for(int c = 0; c < contents.length; c++) {
	    Value cont = contents[c].eval(focus, context);
	    for(; cont.next(); ) 
		buf.append( cont.asString() ); 
	}
	String chunk = buf.toString();
	if(kind == Node.COMMENT)
	    output.comment(chunk);
        else
	    throw new RuntimeException("bad AtomConstructor");
    }
}
