/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 * Implementation of operator and.
 */
public class AndExpr extends BooleanExpression {

    public Expression[]  args;

    AndExpr() { }
    public AndExpr( Expression first ) {
        args = new Expression[] { first };
    }

    public void addExpr( Expression e ) {
	args = addExpr(args, e);
    }

    public boolean visit( Visitor v ) {
	return v.examine(this) && v.visit(args);
    }

    public void dump( ExprDump d ) {
	d.header( this, "AndExpr" );
	d.display("args", args);
    }

    public Expression staticCheck( StaticContext context ) {
	for(int i = 0; i < args.length; i++) {
	    // since we use the EBV, any operand type is OK
	    args[i] = context.staticCheck(args[i], 0);
	}
        type = Type.BOOLEAN;
	return this;
    }

    public boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException {
	for(int i = 0; i < args.length; i++)
	    if(!args[i].evalEffectiveBooleanValue(focus, context))
		return false;
	return true;
    }
}
