/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.impl;

import net.xfra.qizxopen.xquery.*;

/**
 *	Iterator on tokens of a XQuery script: returns the lexical type of each token.
 */
public class SyntaxColorer extends Lexer
{
    int curToken;
    //int firstTokenStart = 0;
    int prevTokenEnd = 0;
    int prevTokenType = -1;

    // lexical categories:
    public final static int TAG = 1;
    public final static int SPACE = 2;
    public final static int NUMBER = 3;
    public final static int STRING = 4;
    public final static int MISC = 5;
    public final static int NAME = 6;
    public final static int KEYWORD = 7;
    public final static int COMMENT = 8;
    public final static int PRAGMA = 9;
    public final static int FUNC = 10;

    public SyntaxColorer(String input) {
	startLexer(input);
	showComments = true;
	//debug = true;
    }

    // returns the text of the current token: null if end reached
    public String tokenValue() {
	return ((String) input).substring(tokenStart, tokenEnd);
    }

    /**
     *	Gets the space that is before the current token.
     *	Returns null if no space.
     */
    public String getSpace() {
	if(tokenStart <= prevTokenEnd)
	    return null;
	return ((String) input).substring(prevTokenEnd, tokenStart);
    }

//     public int nextToken() throws SyntaxException {
// 	firstTokenStart = tokenStart;
// 	for(;;) {
// 	    int tokenType = nextToken1();
// 	    if(tokenType == 0 || tokenType != prevTokenType) {
// 		prevTokenType = tokenType;
// 		firstTokenStart = tokenStart;
// 		return tokenType;
// 	    }
// 	}
//     }

    // returns the lexical category
    public int nextToken() throws SyntaxException {
	prevTokenEnd = tokenEnd;
	curToken = getToken();
	if(curToken == T_END)
	    return 0;
	switch(curToken) {
	case T_S:
	    return SPACE;
	case T_DecimalLiteral:
	case T_DoubleLiteral:
	case T_IntegerLiteral:
	    return NUMBER;
	case T_StringLiteral:
	case T_URLLiteral:
	    return STRING;
	case T_StartTagOpen: case T_StartTagOpenRoot:
	case T_EndTagOpen:
	case T_TagQName:
	case T_StartTagClose: case T_EndTagClose: case T_EmptyTagClose:
	case T_ValueIndicator:
	case T_OpenQuot: case T_OpenApos:
	case T_CloseQuot: case T_CloseApos:
	case T_Char: case T_CharRef:
	case T_XmlComment:
	case T_ProcessingInstruction:
	    return TAG;
	case T_Lbrace:
	case T_LbraceExprEnclosure:
	case T_Rbrace:
	case T_Equals:
	case T_Lpar: case T_Rpar:
	case T_Lt: case T_LtEquals: case T_LtLt:
	case T_Gt: case T_GtEquals: case T_GtGt:
	case T_Minus: case T_Plus:
	case T_Multiply: case T_Star:
	case T_QMark:
	case T_Slash:
	case T_Vbar:
	    return MISC;
	case T_QNameLpar:
	    return FUNC;
	case T_QName:
	case T_NCName:
	case T_NCNameColonStar: case T_StarColonNCName:
	case T_TypeQName:
	case T_VarName: case T_VariableIndicator:
	    return NAME;
	case T_Comment:
	    return COMMENT;
	case T_Pragma:
	case T_Extension:
	    return PRAGMA;
	default:
	    return KEYWORD;
	}
    }

    void parsedPragma(int location, String prefix, String localName, String body) {
    }

    void parsedExtension(int location, String prefix, String localName, String body) {
    }


/*
    static public void main( String args[] )
    {
        try {
            SyntaxColorer sco = new SyntaxColorer(args[0]);
	    for(int token = sco.nextToken(); token > 0; token = sco.nextToken()) {
		String str = sco.tokenValue();
		System.err.println("|" + str + "| = "+token);
	    }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
*/
} // end of class SyntaxColorer
