/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.impl;

import net.xfra.qizxopen.xquery.*;

/**
 *	Lexical analysis (undocumented internal class).
 *	<p>This code was generated from the XML specification, then completed and cleaned.
 */
public class Lexer {

    // tokens:
    final static int T_END = 0;
    final static int T_And = 1;
    final static int T_As = 2;
    final static int T_Ascending = 3;
    final static int T_AssignEquals = 4;
    final static int T_At = 5;
    final static int T_AtStringLiteral = 6;
    final static int T_AtWord = 7;
    final static int T_AtomicValue = 8;
    final static int T_AttributeLbrace = 9;
    final static int T_AttributeQNameLbrace = 10;
    final static int T_AttributeType = 11;
    final static int T_AxisAncestor = 12;
    final static int T_AxisAncestorOrSelf = 13;
    final static int T_AxisAttribute = 14;
    final static int T_AxisChild = 15;
    final static int T_AxisDescendant = 16;
    final static int T_AxisDescendantOrSelf = 17;
    final static int T_AxisFollowing = 18;
    final static int T_AxisFollowingSibling = 19;
    final static int T_AxisNamespace = 20;
    final static int T_AxisParent = 21;
    final static int T_AxisPreceding = 22;
    final static int T_AxisPrecedingSibling = 23;
    final static int T_AxisSelf = 24;
    final static int T_BaseChar = 25;
    final static int T_Case = 26;
    final static int T_CastAs = 27;
    final static int T_CastableAs = 28;
    final static int T_CdataSectionEnd = 29;
    final static int T_CdataSectionStart = 30;
    final static int T_Char = 31;
    final static int T_CharRef = 32;
    final static int T_CloseApos = 33;
    final static int T_CloseQuot = 34;
    final static int T_Collation = 35;
    final static int T_ColonEquals = 36;
    final static int T_CombiningChar = 37;
    final static int T_Comma = 38;
    final static int T_Comment = 39;
    final static int T_CommentLpar = 40;
    final static int T_DecimalLiteral = 41;
    final static int T_DeclareNamespace = 42;
    final static int T_DeclareResult = 43;
    final static int T_DeclareXMLSpace = 44;
    final static int T_Default = 45;
    final static int T_DefaultCollationEquals = 46;
    final static int T_DefaultElement = 47;
    final static int T_DefaultFunction = 48;
    final static int T_DeclareFunction = 49;
    final static int T_Descending = 50;
    final static int T_Digit = 51;
    final static int T_Digits = 52;
    final static int T_Div = 53;
    final static int T_Document = 54;	// OBSOLETE
    final static int T_DocumentLbrace = 55;
    final static int T_Dot = 56;
    final static int T_DotDot = 57;
    final static int T_DoubleLiteral = 58;
    final static int T_ElementLbrace = 59;
    final static int T_ElementQNameLbrace = 60;
    final static int T_ElementType = 61;
    final static int T_Else = 62;
    final static int T_Empty = 63;
    final static int T_EmptyGreatest = 64;
    final static int T_EmptyLeast = 65;
    final static int T_EmptyTagClose = 66;
    final static int T_EndTagClose = 67;
    final static int T_EndTagOpen = 68;
    final static int T_Equals = 69;
    final static int T_EscapeApos = 70;
    final static int T_EscapeQuot = 71;
    final static int T_Every = 72;
    final static int T_Except = 73;
    final static int T_ExprComment = 74;
    final static int T_Extender = 75;
    final static int T_ForVariable = 76;
    final static int T_FortranEq = 77;
    final static int T_FortranGe = 78;
    final static int T_FortranGt = 79;
    final static int T_FortranLe = 80;
    final static int T_FortranLt = 81;
    final static int T_FortranNe = 82;
    final static int T_Gt = 83;
    final static int T_GtEquals = 84;
    final static int T_GtGt = 85;
    //final static int T_HexDigits = 86;
    final static int T_Global = 87;
    final static int T_Idiv = 88;
    final static int T_IfLpar = 89;
    final static int T_ImportSchemaToken = 90;
    final static int T_In = 91;
    final static int T_InContext = 92;
    final static int T_Instanceof = 93;
    final static int T_IntegerLiteral = 94;
    final static int T_Intersect = 95;
    final static int T_Is = 96;
    final static int T_IsNot = 97;
    final static int T_Item = 98;
    final static int T_LCurlyBraceEscape = 99;
    final static int T_Lbrace = 100;
    final static int T_LbraceExprEnclosure = 101;
    final static int T_Lbrack = 102;
    final static int T_LetVariable = 103;
    final static int T_Letter = 104;
    final static int T_LocalPart = 105;
    final static int T_Lpar = 106;
    final static int T_Lt = 107;
    final static int T_LtEquals = 108;
    final static int T_LtLt = 109;
    final static int T_Minus = 110;
    final static int T_Mod = 111;
    final static int T_Multiply = 112;
    final static int T_NCName = 113;
    final static int T_NCNameColonStar = 114;
    //final static int T_NCNameForPrefix = 115;
    final static int T_Namespace = 116;
    final static int T_Nmchar = 117;
    final static int T_Nmstart = 118;
    final static int T_Node = 119;
    final static int T_NodeLpar = 120;
    final static int T_NotEquals = 121;
    final static int T_OfType = 122;
    final static int T_OpenApos = 123;
    final static int T_OpenQuot = 124;
    final static int T_Or = 125;
    final static int T_OrderBy = 126;
    final static int T_OrderByStable = 127;
    final static int T_PITarget = 128;
    final static int T_Plus = 129;
    final static int T_PredefinedEntityRef = 130;
    final static int T_Prefix = 131;
    final static int T_ProcessingInstruction = 132;
    final static int T_ProcessingInstructionLpar = 133;
    final static int T_Pragma = 134;
    final static int T_Extension = 135;
    final static int T_QMark = 136;
    final static int T_QName = 137;
    final static int T_QNameLpar = 138;
    final static int T_RCurlyBraceEscape = 139;
    final static int T_Rbrace = 140;
    final static int T_Rbrack = 141;
    final static int T_Return = 142;
    final static int T_Root = 143;
    final static int T_RootDescendants = 144;
    final static int T_Rpar = 145;
    final static int T_RparAs = 146;
    final static int T_S = 147;
    final static int T_Satisfies = 148;
    final static int T_SemiColon = 149;
    final static int T_Slash = 150;
    final static int T_SlashSlash = 151;
    final static int T_Some = 152;
    final static int T_Star = 153;
    final static int T_StarColonNCName = 154;
    final static int T_StartTagClose = 155;
    final static int T_StartTagOpen = 156;
    final static int T_StartTagOpenRoot = 157;
    final static int T_StringLiteral = 158;
    final static int T_TagQName = 159;
    final static int T_Text = 160;
    final static int T_TextLbrace = 161;
    final static int T_TextLpar = 162;
    final static int T_Then = 163;
    final static int T_To = 164;
    final static int T_TreatAs = 165;
    final static int T_TypeQName = 166;
    final static int T_TypeswitchLpar = 167;
    final static int T_URLLiteral = 168;
    final static int T_Union = 169;
    final static int T_Untyped = 170;
    final static int T_ValidateContext = 171;
    final static int T_Validate = 172;
    final static int T_ValueIndicator = 173;
    final static int T_VarName = 174;
    final static int T_VariableIndicator = 175;
    final static int T_Vbar = 176;
    final static int T_Where = 177;
    final static int T_WhitespaceChar = 178;
    final static int T_XMLSpaceEquals = 179;
    final static int T_XMLSpacePreserve = 180;
    final static int T_XMLSpaceStrip = 181;
    final static int T_XmlComment = 182;
    // May 2003 draft:
    final static int T_Module = 183;
    final static int T_DocumentNodeLpar = 184;
    final static int T_ElementLpar = 185;
    final static int T_AttributeLpar = 186;
    final static int T_ItemLparRpar = 187;
    final static int T_XQueryVersion = 188;
    final static int T_ImportModule = 189;
    final static int T_DeclareVariable = 190;
    final static int T_External = 191;
    final static int T_ValidationStrict = 192;
    final static int T_ValidationSkip = 193;
    final static int T_ValidationLax = 194;

    // Aug 2003 draft:
    final static int T_CommentLbrace = 195;
    final static int T_NamespaceLbrace = 196;
    final static int T_PILbrace = 197;
    final static int T_PINameLbrace = 198;

    // Heretic extensions:
    final static int T_Template = 200;
    

    final static String[] tokenNames = {
	"<end>",
        "and", "as", "ascending", "=", 
        "at", "at <string>", "at word", "atomic value", 
        "attribute {", "attribute <qname> {", "attribute type", "ancestor::", 
        "ancestor-or-self::", "attribute", "child::", "descendant::", 
        "descendant-or-self::", "following::", "following-sibling::", "namespace::", 
        "parent::", "preceding::", "preceding-sibling::", "self::", 
        "<basechar>", "case", "cast as", "castable as", 
        "cdatasectionend", "<cdata section start>", "<characters>", "<CharReference>", 
        "'", "\"", "collation", ":=", 
        "CombiningChar", ",", "comment", "comment(", 
        "DecimalLiteral", "declare namespace", "declare result", "declare xmlspace", 
        "default", "default collation =", "default element", "default function", 
        "declare function", "descending", "<digit>", "<digits>", 
        "div", "document", "document {", ".", 
        ".", "<double>", "element {", "element <qname> {", 
        "element type", "else", "empty", "empty greatest", 
        "empty least", "/>", ">", "</", 
        "=", "''", "\"\"", "every", 
        "except", "<comment>", "<extender>", "for $", 
        "eq", "ge", "gt", "le", 
        "lt", "ne", "gt", ">=", 
        ">>", "<hexdigits", "global", "idiv", 
        "if(", "import schema", "in", "in context", 
        "instanceof", "<integer>", "intersect", "is", 
        "isnot", "item", "{{", "{", 
        "{", "[", "let $", "<letter>", 
        "local", "(", "<", "<=", 
        "<<", "minus", "mod", "*", 
        "<ncname>", "<name>:*", "<ncname>", "namespace", 
        "<nmchar>", "<nmstart>", "node", "node(", 
        "!=", "of type", "'", "\"", 
        "or", "order by", "stable order by", "pi-target", 
        "plus", "<predefined entity>", "prefix", "processing-instruction", 
        "?>", "processing-instruction(", "<?", "?", 
        "<qname>", "<qname>(", "}}", "}", 
        "]", "return", "/", "//", 
        ")", ") as", "s", "satisfies", 
        ";", "/", "//", "some", 
        "*", "*:name", ">", "<", 
        "<", "<string>", "<tagname>", "text", 
        "text {", "text(", "then", "to", 
        "treat as", "type <qname>", "typeswitch(", "<url>", 
        "union", "untyped", "validate context", "validate {", 
        "<value indicator>", "<variable>", "$", "|", 
        "where", "<whitespace>", "xmlspace =", "preserve", 
        "strip", "<XML comment>",
	"module", "document-node(", "element(", "attribute(", "item()", 
	"xquery version", "import module", "declare variable", "external",
	"validation strict", "validation skip", "validation lax",
	"comment {", "namespace {", "pi {", "pi <name> {"
    };
    final static int APOS_ATTRIBUTE_CONTENT_STATE = 1;
    final static int CDATA_SECTION_STATE = 2;
    final static int DEFAULT_STATE = 3;
    final static int ELEMENT_CONTENT_STATE = 4;
    final static int END_TAG_STATE = 5;
    final static int ITEMTYPE_STATE = 6;
    final static int NAMESPACEDECL_STATE = 7;
    final static int NAMESPACEKEYWORD_STATE = 8;
    final static int OPERATOR_STATE = 9;
    final static int PROCESSING_INSTRUCTION_STATE = 10;
    final static int PROCESSING_INSTRUCTION_CONTENT_STATE = 11;
    final static int QNAME_STATE = 12;
    final static int QUOT_ATTRIBUTE_CONTENT_STATE = 13;
    final static int START_TAG_STATE = 14;
    final static int VARNAME_STATE = 15;
    final static int XMLSPACE_DECL_STATE = 16;
    final static int XML_COMMENT_STATE = 17;
    final static int XQUERY_COMMENT_STATE = 18;
    final static int OCCURRENCEINDICATOR_STATE = 19;
    final static int KINDTEST_STATE = 20;
    final static int CLOSEKINDTEST_STATE = 21;

    final static int TEMPLATE_KEY_STATE = 22;
 
    Module  currentModule;
    CharSequence input;
    int    inputLength;
    Log    log;
    char   curChar;
    int    curPtr;    // token start:
    // look-ahead position: moved by pickXXX() and next(), reset to curPtr by back()
    int    tokenStart;	
    int    tokenEnd;	

    int  lexState;
    int  stateSP, states[] = new int[8];
    StringBuffer saveBuffer = new StringBuffer();
    String prefixValue;
    boolean showComments = false; // show comments as tokens
    public static boolean debug = false;

    public Lexer( ) {
    }

    public void startLexer( CharSequence input ) {
	this.input = input;
	inputLength = input.length();
	lexState = DEFAULT_STATE;
	stateSP = 0;
	tokenEnd = 0;
	next();
	if(debug) System.err.println("===== Start lexer");
    }

    int getToken() throws SyntaxException {
	if(debug) {
	    System.err.print("getToken state "+lexState+" at "+curPtr+" ");
	    if(curChar <= ' ')
		 System.err.println("#"+(int) curChar+" ");
	    else System.err.println(((char) curChar)+" " );
	}

	saveBuffer.setLength(0);
	tokenStart = tokenEnd;
	if(curChar == 0) {
	    tokenEnd = inputLength;
	    return T_END;
	}
        switch(lexState) {

        case APOS_ATTRIBUTE_CONTENT_STATE:
            switch(curChar) {
            case '&':
		return parseCharRef();
            case '\'':
		next();
                if( !pick('\'') ) {
                    lexState = START_TAG_STATE;
		    return storeToken(T_CloseApos);
                }
		save('\'');
		return storeToken(T_Char);	// double apos

            case '{':
		next();
                if( !pick('{') ) {
                     pushState(); lexState = DEFAULT_STATE;
		     return storeToken(T_Lbrace);
                }
		save('{');
		return storeToken(T_Char);	// LBrace escape 

	    case '}':	// stray
		next();
		if(!pick('}') )
		    lexicalWarning("expected '}}'");
		save('}'); 
		return storeToken(T_Char);	// RBrace escape 

            default:
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
		while(curChar != 0 && curChar != '&' && curChar != '\'' &&
		      curChar != '{' && curChar != '}') {
		    save(curChar);
		    next();
		}
		return storeToken(T_Char);
            }

        case QUOT_ATTRIBUTE_CONTENT_STATE:
            switch(curChar) {
            case '"':
		next();
                if( !pick('"') ) {
                    lexState = START_TAG_STATE;
		    return storeToken(T_CloseQuot);
                }
		save('"');
		return storeToken(T_Char);	// double apos
            case '&':
		return parseCharRef();
            case '{':
		next();
                if( !pick('{') ) {
                     pushState(); lexState = DEFAULT_STATE;
		     return storeToken(T_Lbrace);
                }
		save('{');
		return storeToken(T_Char);	// LBrace escape 

            case '}':	// stray
		next();
		if(!pick('}') )
		    lexicalWarning("expected '}}'");
		save('}');
		return storeToken(T_Char);	// RBrace escape 

            default:
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
		while(curChar != 0 && curChar != '&' && curChar != '"' &&
		      curChar != '{' && curChar != '}') {
		    save(curChar);
		    next();
		}
		return storeToken(T_Char);
            }

        case DEFAULT_STATE:
	    optSkip(); backMark();
            switch(curChar) {
            case 0:
		return T_END;
            case '"': case '\'':
		pickStringLiteral();
		lexState = OPERATOR_STATE;
		return storeToken(T_StringLiteral);

            case '$':
                next();
		lexState = VARNAME_STATE;
		return storeToken(T_VariableIndicator);

            case '(':
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
                next(); return storeToken(T_Lpar);

            case ')':
                next();
		if( optSkip() && pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_RparAs);
                }
		lexState = OPERATOR_STATE;
		return storeToken(T_Rpar);

            case '*':
                next(); lexState = OPERATOR_STATE; 
		if( pick(':') && pickName() )
		    return storeToken(T_StarColonNCName);
		return storeToken(T_Star);

            case '+':
                next(); return storeToken(T_Plus);

            case ',':
		next(); return storeToken(T_Comma);

            case '-':
                next();	return storeToken(T_Minus);

            case '.':
                next();
		if( pick('.') ) {
                    lexState = OPERATOR_STATE;
		    return storeToken(T_DotDot);
                }
		else if(Character.isDigit(curChar)) {
		    lexState = OPERATOR_STATE; back();
		    return parseNumber();
		}
		lexState = OPERATOR_STATE; return storeToken(T_Dot);

            case '/':
                next();
		if( pick('/') )
                    return storeToken(T_RootDescendants);
		return storeToken(T_Root);

            case ';':
		next();
		return storeToken(T_SemiColon);

            case '<':
                next();
		if( pick("!--") ) {
                     lexState = OPERATOR_STATE;
		     return parseXMLComment();
		}
                else if( pick("![CDATA[") ) {
                     lexState = OPERATOR_STATE;
		     return parseCDATASection();
		}
                else if( pick('?') ) {
                     lexState = OPERATOR_STATE;
		     return parseProcessingInstruction();
		}
		pushState(OPERATOR_STATE); lexState = START_TAG_STATE;
		return storeToken(T_StartTagOpen);

            case '?':
                pick('?');
		lexState = DEFAULT_STATE;
		return storeToken(T_QMark);

            case '@':
                next(); return storeToken(T_At);

            case '[':
                next(); return storeToken(T_Lbrack);

            case ']':
                pick(']');
		lexState = OPERATOR_STATE;
		return storeToken(T_Rbrack);

            case 'a':
		backMark();
                if( pickName("ancestor") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisAncestor);
                }
                else if( back() && pickName("ancestor-or-self") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisAncestorOrSelf);
                }
                else if( back() && pickName("at") && optSkip() && pickStringLiteral() ) {
                    return storeToken(T_AtStringLiteral);
                }
                else if( back() && pickName("attribute") ) {
		    if( optSkip() && pick("::") ) {
			return storeToken(T_AxisAttribute);
		    }
		    else if( optSkip() && pickQName() && optSkip() && pick('{') ) {
			pushState(OPERATOR_STATE); 
			return storeToken(T_AttributeQNameLbrace);
		    }
		    else if( optSkip() && pick('{') ) {
			pushState(OPERATOR_STATE); pushState(OPERATOR_STATE); 
			return storeToken(T_AttributeLbrace);
		    }
		    else if( optSkip() && pick('(') ) {
			return storeToken(T_AttributeLpar);
		    }
		}
		back(); return parseNameDEFAULT();

            case 'c':
                if( back() && pickName("child") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisChild);
                }
                else if( back() && pickName("comment") && optSkip() && pick('(') ) {
                    return storeToken(T_CommentLpar);
                }
                else if( back() && pickName("comment") && optSkip() && pick('{') ) {
                    pushState(OPERATOR_STATE);
		    return storeToken(T_CommentLbrace);
                }
		back(); return parseNameDEFAULT();

            case 'd':
                if( pickName("declare") && reqSkip() ) {
		    if( pickName("namespace") ) {
			lexState = NAMESPACEDECL_STATE;
			return storeToken(T_DeclareNamespace);
		    }
		    else if( pickName("xmlspace") ) {
			lexState = XMLSPACE_DECL_STATE;
			return storeToken(T_DeclareXMLSpace);
		    }
		    else if( pickName("function") ) {
			pushState(lexState = DEFAULT_STATE);
			return storeToken(T_DeclareFunction);
		    }
		    else if( pickName("variable") && optSkip() && pick("$") ) {
			pushState(DEFAULT_STATE); lexState = VARNAME_STATE;
			return storeToken(T_DeclareVariable);
		    }
		    else {
			back(); return parseNameDEFAULT();
		    }
		}
                else if( pickName("default") && reqSkip() && pickName("collation") &&
			 reqSkip() && pick('=') ) {
                    lexState = NAMESPACEDECL_STATE;
		    return storeToken(T_DefaultCollationEquals);
                }
                else if( back() && pickName("default") && reqSkip() && pickName("function") ) {
                    lexState = NAMESPACEKEYWORD_STATE;
		    return storeToken(T_DefaultFunction);
                }
                else if( back() && pickName("default") && reqSkip() && pickName("element") ) {
                    lexState = NAMESPACEKEYWORD_STATE;
		    return storeToken(T_DefaultElement);
                }
                else if( back() && pickName("define") && reqSkip() && pickName("function") ) {
                    pushState(lexState = DEFAULT_STATE);
		    return storeToken(T_DeclareFunction);
                }
                else if( back() && pickName("define") && reqSkip() && pickName("variable") 
			 && optSkip() && pick("$") ) {
                    pushState(DEFAULT_STATE); lexState = VARNAME_STATE;
		    return storeToken(T_DeclareVariable);
                }
                else if( back() && pickName("descendant") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisDescendant);
                }
                else if( back() && pickName("descendant-or-self") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisDescendantOrSelf);
                }
                else if( back() && pickName("document") && optSkip() && pick('{') ) {
		    pushState(OPERATOR_STATE);
		    return storeToken(T_DocumentLbrace);
                }
                else if( pickName("document-node") && optSkip() && pick('(') ) {
                    return storeToken(T_DocumentNodeLpar);
                }
		back();
		return parseNameDEFAULT();

            case 'e':
                if(pickName("element") && reqSkip() && pickQName() && optSkip() && pick('{')) {
                     pushState(OPERATOR_STATE);
		     return storeToken(T_ElementQNameLbrace);
                }
                else if( back() && pickName("element") && optSkip() && pick('{') ) {
                     pushState(OPERATOR_STATE); pushState(OPERATOR_STATE);
		     return storeToken(T_ElementLbrace);
                }
                else if( back() && pickName("element") && optSkip() && pick('(') ) {
                     return storeToken(T_ElementLpar);
                }
                else if( back() && pickName("every") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_Every);
                }
		back(); return parseNameDEFAULT();

            case 'f':
                if( pickName("following") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisFollowing);
                }
                else if( back() && pickName("following-sibling") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisFollowingSibling);
                }
                else if( back() && pickName("for") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_ForVariable);
                }
		back(); return parseNameDEFAULT();

            case 'i':
                if( pickName("if") && optSkip() && pick('(') ) {
                    return storeToken(T_IfLpar);
                }
                else if( back() && pickName("import") && reqSkip() && pickName("schema") ) {
                    lexState = NAMESPACEKEYWORD_STATE;
		    return storeToken(T_ImportSchemaToken);
                }
                else if( back() && pickName("import") && reqSkip() && pickName("module") ) {
                    lexState = NAMESPACEKEYWORD_STATE;
		    return storeToken(T_ImportModule);
                }
		back(); return parseNameDEFAULT();

            case 'l':
                if( pickName("let") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_LetVariable);
                }
		back(); return parseNameDEFAULT();

            case 'm':
                if( pickName("module") && optSkip() && pickName("namespace")) {
                    lexState = NAMESPACEDECL_STATE;
		    return storeToken(T_Module);
                }
		back(); return parseNameDEFAULT();

            case 'n':
                if( pickName("namespace") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisNamespace);
                }
                else if( back() && pickName("namespace") && optSkip() && pickName() &&
			 optSkip() && pick("{") ) {
                    pushState(OPERATOR_STATE);
		    return storeToken(T_NamespaceLbrace);
                }
                else if( back() && pickName("node") && optSkip() && pick('(') ) {
                    return storeToken(T_NodeLpar);
                }
		back(); return parseNameDEFAULT();

            case 'o':
                if( back() && pickName("order") && reqSkip() && pickName("by") ) {
                    return storeToken(T_OrderBy);
                }
		back(); return parseNameDEFAULT();

            case 'p':
                if( pickName("parent") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisParent);
                }
                else if(pickName("preceding") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisPreceding);
                }
                else if( back() && pickName("preceding-sibling") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisPrecedingSibling);
                }
                else if( pickName("processing-instruction") && optSkip() && pick('(')) {
                    return storeToken(T_ProcessingInstructionLpar);
                }
                else if( back() && pickName("pi") && optSkip() ) {
		    if(pick("{")) {
			pushState(OPERATOR_STATE); pushState(OPERATOR_STATE);
			return storeToken(T_PILbrace);
		    }
		    if( pickName() && optSkip() && pick('{') ) {
			pushState(OPERATOR_STATE);
			return storeToken(T_PINameLbrace);
		    }
                }
		back(); return parseNameDEFAULT();

            case 's':
                if( pickName("self") && optSkip() && pick("::") ) {
                    return storeToken(T_AxisSelf);
                }
                else if( back() && pickName("some") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_Some);
                }
                else if( back() && pickName("stable") && reqSkip() && pickName("order") &&
			 reqSkip() && pickName("by") ) {
                    return storeToken(T_OrderByStable);
                }
		back(); return parseNameDEFAULT();

            case 't':
                if( pickName("text") && optSkip() && pick('{') ) {
		    pushState(OPERATOR_STATE);
		    return storeToken(T_TextLbrace);
                }
                else if( back() && pickName("text") && optSkip() && pick('(') ) {
                    return storeToken(T_TextLpar);
                }
                else if( back() && pickName("typeswitch") && optSkip() && pick('(') ) {
                    return storeToken(T_TypeswitchLpar);
                }
		back();
		return parseNameDEFAULT();

            case 'v':
                if( pickName("validate") && optSkip() ) {
		    if( curChar == '{' || isNameStart(curChar) )
			return storeToken(T_Validate);
		}
		else if( pickName("validation") && reqSkip()) {
		    if( pickName("strict") )
			return storeToken(T_ValidationStrict);
		    if( pickName("skip") )
			return storeToken(T_ValidationSkip);
		    if( pickName("lax") )
			return storeToken(T_ValidationLax);
		}
		back();
		return parseNameDEFAULT();

            case 'x':
                if( pickName("xquery") && reqSkip() && pickName("version")
		    && optSkip() && pickStringLiteral() )
		    return storeToken(T_XQueryVersion);
		back();
		return parseNameDEFAULT();

            case '{':
		next();
		return storeToken(T_LbraceExprEnclosure);

            case '}':
                next(); popState();
		return storeToken(T_Rbrace);

            default:
		if( Character.isDigit( curChar ) ) {
		    lexState = OPERATOR_STATE;
		    return parseNumber();
		}
		return parseNameDEFAULT();
            }

        case ELEMENT_CONTENT_STATE:
            switch(curChar) {
            case 0:
		return T_END;
            case '&':
                return parseCharRef();

            case '<':
                next();
		if( pick("!--") )
                     return parseXMLComment();
                else if( pick("![CDATA[") )
                     return parseCDATASection();
                else if( pick('?') )
                     return parseProcessingInstruction();
                else if( pick('/') ) {
                    lexState = END_TAG_STATE;
		    return storeToken(T_EndTagOpen);
                }
		else {
		    pushState(); lexState = START_TAG_STATE;
		    return storeToken(T_StartTagOpen);
		}

            case '{':
                /* if( pick("{--") )
                    skipExprComment();	// Nov 2002 Draft
		    else */
		if( pick("{{") ) {
                    save('{'); return storeToken(T_Char);
                }
		else {
                     next(); pushState(); lexState = DEFAULT_STATE;
		     return storeToken(T_Lbrace);
                }

            case '}':
                if( pick("}}") ) {
                    save('}');
		    return storeToken(T_Char);
                }
		lexicalWarning("'}' must be escaped by '}}' in element content");
		save('}'); next();
		// FALL THROUGH:
            default:
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
		while(curChar != 0 && curChar != '&' && curChar != '<' &&
		      curChar != '{' && curChar != '}') {
		    save(curChar); next();
		}
		return storeToken(T_Char);
            }
            //break;

        case START_TAG_STATE:
	    optSkip();	// actually not allowed after '<'
            switch(curChar) {
            case 0:
		return T_END;
            case '"':
                next();
		lexState = QUOT_ATTRIBUTE_CONTENT_STATE;
		return storeToken(T_OpenQuot);

            case '\'':
                next();
		lexState = APOS_ATTRIBUTE_CONTENT_STATE;
		return storeToken(T_OpenApos);

            case '/':
                if( pick("/>") ) {
                     popState(); return storeToken(T_EmptyTagClose);
                }
                break;
            case '=':
                next();
		return storeToken(T_ValueIndicator);

            case '>':
                next();
		lexState = ELEMENT_CONTENT_STATE;
		return storeToken(T_StartTagClose);

            default:
                if( pickQName() ) {
                    return storeToken(T_TagQName);
                }
            }
            lexicalError();
            break;

        case END_TAG_STATE:
	    optSkip();	// actually not allowed after '</'
            switch(curChar) {
            case '>':
                next();
		popState();
		return storeToken(T_EndTagClose);

            default:
                if( pickQName() ) {
                    return storeToken(T_TagQName);
                }
		lexicalError();
	    }


        case ITEMTYPE_STATE:
	    optSkip(); backMark();
            switch(curChar) {
            case '$':
                pick('$');
		lexState = VARNAME_STATE;
		return storeToken(T_VariableIndicator);

            case ')':
                next();
		if( optSkip() && pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_RparAs);
                }
		lexState = OPERATOR_STATE;
		return storeToken(T_Rpar);

            case '*':
		next();
                if( pick(':') && pickName() ) {
                    lexState = OPERATOR_STATE;
		    return storeToken(T_StarColonNCName);
                }
		lexicalError();
                break;
            case '.':
                if( pick("..") ) {
                    lexState = OPERATOR_STATE;
		    return storeToken(T_DotDot);
                }
		lexState = OPERATOR_STATE;
		return storeToken(T_Dot);

            case 'a':
                if( pickName("attribute") && optSkip() && pick('(' )) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_AttributeLpar);
                }
                back();
		return parseName(OCCURRENCEINDICATOR_STATE);

	    case 'c':
                if( pickName("comment") && optSkip() && pick('(') ) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_CommentLpar);
                }
                back(); return parseName(OCCURRENCEINDICATOR_STATE);

            case 'd':
                if( pickName("document-node") && optSkip() && pick('(') ) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_DocumentNodeLpar);
                }
                back(); return parseName(OCCURRENCEINDICATOR_STATE);

            case 'e':
                if( pickName("element") && optSkip() && pick('(') ) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_ElementLpar);
                }
                else if( pickName("empty") && pick("()") ) {
                    lexState = OPERATOR_STATE; return storeToken(T_Empty);
                }
                back(); return parseName(OCCURRENCEINDICATOR_STATE);

            case 'i':
		if( pickName("item") && optSkip() && pick('(') && optSkip() && pick(')')) {
                    lexState = OCCURRENCEINDICATOR_STATE;
		    return storeToken(T_ItemLparRpar);
                }
                back(); return parseName(OCCURRENCEINDICATOR_STATE);

            case 'n':
                if( pickName("node") && optSkip() && pick('(') ) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_NodeLpar);
                }
                return parseName(OCCURRENCEINDICATOR_STATE);

            case 'p':
                if( pickName("processing-instruction") && optSkip() && pick('(') ) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_ProcessingInstructionLpar);
                }
                return parseName(OCCURRENCEINDICATOR_STATE);

            case 't':
                if( pickName("text") && optSkip() && pick('(') ) {
                    lexState = KINDTEST_STATE; pushState(OCCURRENCEINDICATOR_STATE);
		    return storeToken(T_TextLpar);
                }
                return parseName(OCCURRENCEINDICATOR_STATE);

            case 'u':
                if( pickName("untyped") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Untyped);
                }
                return parseName(OCCURRENCEINDICATOR_STATE);

            case '{':
                next();
		pushState(DEFAULT_STATE); lexState = DEFAULT_STATE;
		return storeToken(T_LbraceExprEnclosure);

            default:
		if(showComments && pick("(:")) {
		    return parseCommentPragmaExt();
		}
                return parseName(OCCURRENCEINDICATOR_STATE);	// name:*
            }
            lexicalError();
            break;

	case KINDTEST_STATE:
	    optSkip(); backMark();
            switch(curChar) {
            case '"': case '\'':
		pickStringLiteral();
		return storeToken(T_StringLiteral);
            case '{':
		next();
		return storeToken(T_Lbrace);
            case ')':
		next(); popState();
		return storeToken(T_Rpar);
            case '*':
		next();
		return storeToken(T_Star);	// no CLOSEKINDTEST so far
            case '@':
		next();
		return storeToken(T_At);
            case ',':
		next();
		return storeToken(T_Comma);
	    case 'e':
		if( pickName("element") && optSkip() && pick('(') ) {
		    pushState(KINDTEST_STATE);
		    return T_ElementLpar;
		}
	    default:
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
		return parseName(lexState);
	    }	    

	case OCCURRENCEINDICATOR_STATE:
	    optSkip();
	    lexState = OPERATOR_STATE; 
            switch(curChar) {
            case '*':
		next(); return storeToken(T_Star);
            case '+':
		next(); return storeToken(T_Plus);
            case '?':
		next(); return storeToken(T_QMark);
	    }
	    return getToken();	// retry

        case NAMESPACEDECL_STATE:
	    optSkip();
            switch(curChar) {
            case '=':
                next();
		lexState = NAMESPACEDECL_STATE;
		return storeToken(T_AssignEquals);
	    case '"': case '\'':
		pickStringLiteral(); lexState = DEFAULT_STATE;
		return storeToken(T_URLLiteral);
            default:
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
                if( pickName() ) {
                    return storeToken(T_NCName);
                }
            }
            lexicalError();

        case NAMESPACEKEYWORD_STATE:
	    optSkip();
            switch(curChar) {
            case 'a':
		if( pickName("at") && optSkip() && (curChar == '"' || curChar == '\'')) {
		    return storeToken(T_At);
		}
		break;
            case 'n':
                if( pickName("namespace") ) {
                    lexState = NAMESPACEDECL_STATE;
		    return storeToken(T_Namespace);
                }
                break;
	    case '"': case '\'':
		pickStringLiteral(); lexState = DEFAULT_STATE;
		return storeToken(T_StringLiteral);
            }
            lexicalError();
            break;

        case OPERATOR_STATE:
            optSkip(); backMark();
	    switch(curChar) {
            case 0:
		return T_END;
	    case '"': case '\'':
		pickStringLiteral();
		return storeToken(T_StringLiteral);

            case '!':
                if( pick("!=") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_NotEquals);
                }
                break;
            case '$':
		next(); lexState = VARNAME_STATE;
		return storeToken(T_VariableIndicator);

            case '(':
		next();
		if(showComments && pick(':') ) {
		    return parseCommentPragmaExt();
		}
		else {
		    lexState = DEFAULT_STATE;
		    return storeToken(T_Lpar);
		}
            case ')':
                next();
		if( optSkip() && pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_RparAs);
                }
		return storeToken(T_Rpar);

            case '*':
                next();
		if( pick(':') && pickName() ) {
                    return storeToken(T_StarColonNCName);
                }
		lexState = DEFAULT_STATE;
		return storeToken(T_Multiply);

            case '+':
                next(); lexState = DEFAULT_STATE;
		return storeToken(T_Plus);

            case ',':
                next(); lexState = DEFAULT_STATE;
		return storeToken(T_Comma);

            case '-':
                next(); lexState = DEFAULT_STATE;
		return storeToken(T_Minus);

            case '.':
                next(); 
		if( pick('.') ) {
                    return storeToken(T_DotDot);
                }
		else if( Character.isDigit(curChar) ) {
		    return parseNumber();
		}
		return storeToken(T_Dot);

            case '/':
                next(); 
		if( pick('/') ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_SlashSlash);
                }
		lexState = DEFAULT_STATE;
		return storeToken(T_Slash);

            case ':':
                if( pick(":=") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_ColonEquals);
                }
                break;	//error

            case ';':
                next(); lexState = DEFAULT_STATE;
		return storeToken(T_SemiColon);

            case '<':
                lexState = DEFAULT_STATE; 
		if( pick("<<") ) {
                    return storeToken(T_LtLt);
                }
                else if( pick("<=") ) {
                    return storeToken(T_LtEquals);
                }
		next(); return storeToken(T_Lt);

            case '=':
                next(); lexState = DEFAULT_STATE;
		return storeToken(T_Equals);

            case '>':
                lexState = DEFAULT_STATE; 
		if( pick(">=") ) {
                    return storeToken(T_GtEquals);
                }
                else if( pick(">>") ) {
                    return storeToken(T_GtGt);
                }
		next(); return storeToken(T_Gt);

            case '?':
                next(); lexState = DEFAULT_STATE;
		return storeToken(T_QMark);

            case '[':
		next(); lexState = DEFAULT_STATE;
		return storeToken(T_Lbrack);

            case ']':
		next(); return storeToken(T_Rbrack);

            case 'a':
                if( pickName("and") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_And);
                }
                else if( pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_As);
                }
                else if( pickName("ascending") ) {
                    return storeToken(T_Ascending);
                }
                else if( pickName("at") && optSkip() && pickStringLiteral() ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_AtStringLiteral);
                }
                else if( back() && pickName("at") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_AtWord);
                }
                back(); return parseName();

            case 'c':
                if( pickName("case") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_Case);
                }
                else if( pickName("cast") && reqSkip() && pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_CastAs);
                }
                else if( pickName("castable") && reqSkip() && pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_CastableAs);
                }
                else if( back() && pickName("collation") ) {
                    return storeToken(T_Collation);
                }
                back(); return parseName();

            case 'd':
                if( pickName("declare") && reqSkip() ) {
		    if( pickName("namespace") ) {
			lexState = NAMESPACEDECL_STATE;
			return storeToken(T_DeclareNamespace);
		    }
		    else if( pickName("xmlspace") ) {
			lexState = XMLSPACE_DECL_STATE;
			return storeToken(T_DeclareXMLSpace);
		    }
		    else {
			back(); return parseName();
		    }
		}
                else if( back() && pickName("default") && reqSkip() ) {
		    if( pickName("function") ) {
			lexState = NAMESPACEKEYWORD_STATE;
			return storeToken(T_DefaultFunction);
		    }
		    else if( pickName("element") ) {
			lexState = NAMESPACEKEYWORD_STATE;
			return storeToken(T_DefaultElement);
		    }
		    else if( pickName("collation") && reqSkip() && pick('=') ) {
			lexState = NAMESPACEDECL_STATE;
			return storeToken(T_DefaultCollationEquals);
		    }
		    else {
			return storeToken(T_Default);
		    }
		}
                else if( back() && pickName("descending") ) {
                    return storeToken(T_Descending);
                }
                else if( pickName("div") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Div);
                }
                back(); return parseName();

            case 'e':
                if( pickName("else") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Else);
                }
                else if( pickName("empty") && reqSkip() && pickName("least") ) {
                    return storeToken(T_EmptyLeast);
                }
                else if( back() && pickName("empty") && reqSkip() && pickName("greatest") ) {
                    return storeToken(T_EmptyGreatest);
                }
                else if( back() && pickName("eq") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_FortranEq);
                }
                else if( back() && pickName("every") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_Every);
                }
                else if( back() && pickName("except") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Except);
                }
                else if( back() && pickName("external") ) {
		    popState();	// not sure why "declare function" pushes a state
                    lexState = DEFAULT_STATE;
		    return storeToken(T_External);
                }
                back(); return parseName();

            case 'f':
                if( pickName("for") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_ForVariable);
                }
                back(); return parseName();

            case 'g':
                if( pickName("ge") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_FortranGe);
                }
                else if( pickName("gt") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_FortranGt);
                }
                else if( pickName("global") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Global);
                }
                back(); return parseName();

            case 'i':
                if( pickName("idiv") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Idiv);
                }
                else if( pickName("import") && reqSkip() && pickName("module") ) {
                    lexState = NAMESPACEKEYWORD_STATE;
		    return storeToken(T_ImportModule);
                }
                else if( pickName("import") && reqSkip() && pickName("schema") ) {
                    lexState = NAMESPACEKEYWORD_STATE;
		    return storeToken(T_ImportSchemaToken);
                }
                else if( back() && pickName("in") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_In);
                }
                else if( back() && pickName("instance") && reqSkip() && pickName("of") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_Instanceof);
                }
                else if( back() && pickName("intersect") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Intersect);
                }
                else if( pickName("is") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Is);
                }
                else if( pickName("isnot") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_IsNot);
                }
		else if( pickName("item") && optSkip() && pick('(') && optSkip() && pick(')')) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_ItemLparRpar);
                }
                back();
		return parseName();

            case 'l':
                if( pickName("le") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_FortranLe);
                }
                else if( pickName("let") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_LetVariable);
                }
                else if( back() && pickName("lt") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_FortranLt);
                }
		return parseName();

            case 'm':
                if( pickName("mod") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Mod);
                }
                return parseName();

            case 'n':
                if( pickName("ne") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_FortranNe);
                }
		return parseName();

            case 'o':
                if( back() && pickName("order") && reqSkip() && pickName("by") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_OrderBy);
                }
                else if( back() && pickName("or") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Or);
                }
                back(); return parseName();

            case 'r':
                if( pickName("return") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Return);
                }
                return parseName();

            case 's':
                if( pickName("satisfies") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Satisfies);
                }
                else if( pickName("some") && optSkip() && pick('$') ) {
                    lexState = VARNAME_STATE;
		    return storeToken(T_Some);
                }
                else if( back() && pickName("stable") && reqSkip() && pickName("order") &&
			 reqSkip() && pickName("by") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_OrderByStable);
                }
                back();
		return parseName();

            case 't':
                if( pickName("then") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Then);
                }
                else if( pickName("to") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_To);
                }
                else if( pickName("treat") && reqSkip() && pickName("as") ) {
                    lexState = ITEMTYPE_STATE;
		    return storeToken(T_TreatAs);
                }
                else if( pickName("typeswitch") && optSkip() && pick('(') ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_TypeswitchLpar);
                }
                back();
		return parseName();

            case 'u':
                if( pickName("union") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Union);
                }
		return parseName();

            case 'v':
                if( pickName("validate") && optSkip() )
		    if( curChar == '{' || isNameStart(curChar) ) {
			return storeToken(T_Validate);
		    }
                back(); return parseName();

            case 'w':
                if( pickName("where") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_Where);
                }
                return parseName();

            case '{':
                next();	lexState = DEFAULT_STATE;
		return storeToken(T_LbraceExprEnclosure);

            case '|':
		next(); lexState = DEFAULT_STATE;
		return storeToken(T_Vbar);

            case '}':
		next(); popState();
		return storeToken(T_Rbrace);

            default:
		if( Character.isDigit(curChar) )
		    return parseNumber();
		return parseName();	// name:*
            }
            lexicalError();
            break;

        case QNAME_STATE:
	    optSkip(); backMark();
            switch(curChar) {
            case 0:
		return T_END;
            case '*':
                next();
		if( pick(':') && pickName() ) {
                    lexState = OPERATOR_STATE;
		    return storeToken(T_StarColonNCName);
                }
		lexState = OPERATOR_STATE;
		return storeToken(T_Star);

            case '.':
                next();
		if( pick('.') ) {
                    lexState = OPERATOR_STATE;
		    return storeToken(T_DotDot);
                }
		lexState = OPERATOR_STATE;
		return storeToken(T_Dot);

            default:
                return parseName();
            }

        case VARNAME_STATE:
	    optSkip();
	    if( pickQName() ) {
		lexState = OPERATOR_STATE;
		return storeToken(T_VarName);
	    }
            lexicalError();
            break;

        case XMLSPACE_DECL_STATE:
	    optSkip();
            switch(curChar) {
            case 0:
		return T_END;
            case '=':
		next();
		return storeToken(T_XMLSpaceEquals);

            case 'p':
                if( pickName("preserve") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_XMLSpacePreserve);
                }
                break;
            case 's':
                if( pickName("strip") ) {
                    lexState = DEFAULT_STATE;
		    return storeToken(T_XMLSpaceStrip);
                }
                break;
	    default:
		if(showComments && pick("(:"))
		    return parseCommentPragmaExt();
            }
            lexicalError();
            break;

	case TEMPLATE_KEY_STATE:	// name=value
	    optSkip();
	    break;
	}

	lexicalError("OOPS should not come here, state "+lexState);
	return storeToken(T_END);
    }

    // parse name or qname or name:*  , goto OPERATOR state
    int parseName() throws SyntaxException {
	return parseName(OPERATOR_STATE); 
    }

    // parse name or qname or name:*  , goto state
    int parseName(int state) throws SyntaxException {
	optSkip();
	if( !pickName() )
	    lexicalError();
	lexState = state; 
	prefixValue = "";
	if( pick(':') ) {
	    prefixValue = saveBuffer.toString();
	    if( pickName() ) {
		return storeToken(T_QName);
	    }
	    else if( pick('*') ) {
		return storeToken(T_NCNameColonStar);
	    }
	    else {
		backChar(); prefixValue = "";
	    }
	}
	return storeToken(T_QName);
    }

    // parse general name in default state: name or qname or name:* , goto OPERATOR state
    // or qname( , stay in DEFAULT state 
    int parseNameDEFAULT() throws SyntaxException {
	optSkip();
	int glitch = curPtr;
	if( !pickName() )
	    lexicalError();
	prefixValue = "";
	if( pick(':') ) {
	    prefixValue = saveBuffer.toString();
	    if( pickName() ) {
		if( optSkip() && pick('(')) {
		    return storeToken(T_QNameLpar);
		}
		lexState = OPERATOR_STATE;
		return storeToken(T_QName);
	    }
	    else if( pick('*') ) {
		lexState = OPERATOR_STATE;
		return storeToken(T_NCNameColonStar);
	    }
	    else {
		backChar(); prefixValue = "";
	    }
	}
	if( optSkip() && pick('(') )
	    return storeToken(T_QNameLpar);
	lexState = OPERATOR_STATE;
	return storeToken(T_QName);
    }

    int parseProcessingInstruction() throws SyntaxException {
	saveBuffer.setLength(0);
	for(;;) {
	    while(curChar != '?' && curChar != 0) {
		save(curChar); next();
	    }
	    if(curChar == 0)
		lexicalError("unterminated XML comment");
	    if(pick("?>"))
		break;
	    save(curChar); next();
	}
	return storeToken(T_ProcessingInstruction);
    }

    int parseXMLComment() throws SyntaxException {
	saveBuffer.setLength(0);
	for(;;) {
	    while(curChar != '-' && curChar != 0) {
		save(curChar); next();
	    }
	    if(curChar == 0)
		lexicalError("unterminated XML comment");
	    if(pick("-->"))
		break;
	    save(curChar); next();
	}
	return storeToken(T_XmlComment);
    }

    int parseCDATASection() throws SyntaxException {
	saveBuffer.setLength(0);
	for(;;) {
	    while(curChar != ']' && curChar != 0) {
		save(curChar); next();
	    }
	    if(curChar == 0)
		lexicalError("unterminated CDATA section");
	    if(pick("]]>"))
		break;
	    save(curChar); next();
	}
	return storeToken(T_Char);
    }

    int parseCharRef() throws SyntaxException {
	next();
	if(pick('#')) {
	    int code = 0, digit;
	    if(pick('x')) {
		while( (digit = Character.digit(curChar, 16)) >= 0 ) {
		    code = 16 * code + digit; next();
		}
	    }
	    else while( (digit = Character.digit(curChar, 10)) >= 0 ) {
		code = 10 * code + Character.digit(curChar, 10); next();
	    }
	    save( (char) code );
	}
	else if(pickName("lt"))
	    save('<');
	else if(pickName("gt"))
	    save('>');
	else if(pickName("amp"))
	    save('&');
	else if(pickName("quot"))
	    save('"');
	else if(pickName("apos"))
	    save('\'');
	else lexicalError("illegal character reference");
	pick(';');
	return storeToken(T_CharRef);
    }

    int parseNumber() throws SyntaxException {
	saveBuffer.setLength(0);
	int token = T_IntegerLiteral;
	while(Character.isDigit(curChar)) {
	    save(curChar); next();
	}
	if(curChar == '.') {
	    save(curChar); next();
	    while(Character.isDigit(curChar)) {
		save(curChar); next();
	    }
	    token = T_DecimalLiteral;
	}
	if(curChar == 'e' || curChar == 'E') {
	    save(curChar); next();
	    if(curChar == '+' || curChar == '-') {
		save(curChar); next();
	    }
	    if(!Character.isDigit(curChar))
		lexicalError("expecting digits in exponent");
	    while(Character.isDigit(curChar)) {
		save(curChar); next();
	    }
	    token = T_DoubleLiteral;
	}
	if(saveBuffer.length() == 1 && saveBuffer.charAt(0) == '.')
	    token = T_Dot;
	return storeToken(token);
    }

    // assumes curChar is " or '
    boolean pickStringLiteral() throws SyntaxException {
	if(curChar != '"' && curChar != '\'')
	    return false;
	saveBuffer.setLength(0);
	char delim = curChar;
	next();
	for( ; ; ) {
	    if(curChar == 0) {
		lexicalError("unclosed string literal");
		return true;
	    }
	    else if(curChar == delim) {
		next();
		if(curChar != delim)
		    break;
		else save(delim);
	    }
	    else if(curChar == '&') {	// char refs: new in may2003
		parseCharRef();
		continue; // dont do next()
	    }
	    else save(curChar);
	    next();
	}
	return true;
    }

    boolean pickQName() {
	if(!pickName())
	    return false;
	prefixValue = "";
	if(pick(':')) {
	    prefixValue = saveBuffer.toString();
	    if(!pickName()) {
		backChar(); prefixValue = ""; return true;
	    }
	}
	return true;
    }

    boolean pickName( String s ) {
	int save = curPtr;
	if(!pick(s)) {
	    return false;
	}
	// check that there is no namechar:
	if(isNameChar(curChar)) {
	    curPtr = save - 1; next();
	    return false;
	}
	return true;
    }

    boolean pickName() {
	if(!isNameStart(curChar))
	    return false;
	saveBuffer.setLength(0);
	do {
	    save(curChar);
	    next();
	} while(curChar > ' ' && isNameChar(curChar));
	return true;
    }

    boolean pick( char c ) {
	if(curChar != c)
	    return false;
	next();
	return true;
    }

    boolean pick( String s ) {
	
	if(curChar != s.charAt(0) || curPtr + s.length() - 1 > inputLength)
	    return false;
	int save = curPtr;
	for(int i = s.length(); --i >= 1; )
	    if(input.charAt(curPtr + i - 1) != s.charAt(i)) {
		curPtr = save - 1; next();
		return false;
	    }
	curPtr += s.length() - 1;
	next();
	
	return true;
    }

    boolean isNameStart(char c) {
	return c == '_' || Character.isLetter(c);
    }

    boolean isNameChar(char c) {
	return Character.isUnicodeIdentifierPart(c) || c == '.' || c == '-';
    }

    boolean back() {
	curPtr = tokenStart;
	curChar = input.charAt(curPtr ++);
	return true;
    }

    void backMark() {
	tokenStart = curPtr - 1;
    }

    void next() {
	if(curPtr < inputLength)
	     curChar = input.charAt(curPtr ++);
	else {
	    curChar = 0;
	    curPtr = inputLength + 1;	// as if there were a EOF char
	}
    }

    void backChar() {
	-- curPtr;
	curChar = curPtr == 0 ? '\n' : input.charAt(curPtr - 1);	
    }

    private int parseCommentPragmaExt() throws SyntaxException
    {
	if(pick(":extension")) {
	    int where = curPtr;
	    String locName = parsePragmaOrExt("extension");
	    parsedExtension(where, prefixValue, locName, saveBuffer.toString());
	    if(showComments)
		return storeToken(T_Extension);
	}
	else if(pick(":pragma")) {
	    int where = curPtr;
	    String locName = parsePragmaOrExt("pragma");
	    parsedPragma(where, prefixValue, locName, saveBuffer.toString());
	    if(showComments)
		return storeToken(T_Pragma);
	}
	else {
	    skipExprComment();
	    if(showComments)
		return storeToken(T_Comment);
	}
	return 0;
    }

    private String parsePragmaOrExt(String kind) throws SyntaxException {
	while(Character.isWhitespace(curChar))
	    next();
	if(!pickQName())
	    lexicalError(kind + " should begin with a QName");
	String locName = saveBuffer.toString();
	saveBuffer.setLength(0);
	for(;; next()) {
	    if(curChar == 0)
		lexicalError("unclosed " + kind);
	    else if(pick("::)"))
		break;
	    save(curChar);
	}
	return locName;
    }

    private void skipExprComment() throws SyntaxException {
	for(;;) {
	    if(curChar == 0)
		lexicalError("unclosed comment");
	    else if(pick(":)"))
		return;
	    else if(pick("(:"))
		skipExprComment();	// embedding allowed (May 2003)
	    else next();
	}
    }

    private void skipOldComment() throws SyntaxException {
	for(;;) {
	    if(curChar == 0)
		lexicalError("unclosed comment");
	    else if(pick("--}"))
		return;
	    else next();
	}
    }

    boolean optSkip() throws SyntaxException {
	for(;;) {
	    while(Character.isWhitespace(curChar))
		next();
	    if(pick("{--")) {	// keep old comments for compatibility
		skipOldComment();
	    }
	    else if(!showComments && pick("(:"))
		parseCommentPragmaExt();
	    else return true;
	}
    }

    boolean reqSkip() throws SyntaxException {
	if(!Character.isWhitespace(curChar)) {
	    if(pick("{--"))  // keep old comments for compatibility
		skipOldComment();
	    else if(!showComments && pick("(:"))
		parseCommentPragmaExt();
	    else return false;
	}
	return optSkip();	// always returns true
    }

    int storeToken( int token ) {
	tokenEnd = curPtr - 1;
	if(debug) 
	    System.err.println("storeToken "+tokenNames[token]+" at "+
			       curPtr+" >"+tokenStart+" new state "+lexState);
	return token;
    }

    void save( char c ) {
	saveBuffer.append(c);
    }

    void pushState() {
	pushState( lexState );
    }

    void pushState( int state ) {
	if(stateSP >= states.length) {
	    int[] old = states;
	    states = new int[ 2 * old.length ];
	    System.arraycopy(old, 0, states, 0, old.length);
	}
	states[stateSP ++] = state;
	if(debug) { System.err.print("push "+state+" -> "); dumpStates(); }
    }

    void popState() {
	if(debug) { System.err.print("pop "); dumpStates(); }
	if(stateSP > 0)
	    lexState = states[-- stateSP];
	else if(debug) System.err.println("*** sp=0");
    }

    // What the hell is that ?
    void resetParenStateOrSwitch( int state ) {
	lexState = state;
    }

    void dumpStates() {
	System.err.print("in state "+lexState); 
	System.err.print("  stack "); 
	for(int s = 0; s < stateSP; s++)
	    System.err.print(" "+states[s]); System.err.println();
    }

    void lexicalWarning( String msg ) {
	if(log != null)
	    log.warning(currentModule, curPtr - 1, "lexical warning: %1 ", msg);
    }

    void lexicalError( ) throws SyntaxException {
	lexicalError("illegal character");
    }

    void lexicalError( String msg ) throws SyntaxException {
	String cc = curChar == 0 ? "<end-of-text>"
	    : curChar <= ' ' ? ("#"+(int)curChar) : ("'"+curChar+"'");
	if(log != null)
	    log.error(currentModule, curPtr - 1,
		      "lexical error on character %1: %2", cc, msg);
	throw new SyntaxException(msg + " " + cc, curPtr);
    }

    

    void parsedExtension(int location, String prefix, String localName, String body) {
	System.err.println("Extension "+prefix+":"+localName+" |"+body+"|");
    }

    void parsedPragma(int location, String prefix, String localName, String body) {
	System.err.println("Pragma "+prefix+":"+localName+" |"+body+"|");
    }

}
