/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:string.
 */
public class _String extends Function {

    static Prototype[] protos = { 
        Prototype.fn("string", Type.STRING, Exec.class),
        Prototype.fn("string", Type.STRING, Exec.class) .arg("op", Type.ITEM.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item item;
	    if(args.length == 0) {
		checkFocus(focus, context);
		return focus.getItem().asString();
	    }
	    else {
		Value v = args[0].eval(focus, context);
		context.at(this);
		if(!v.next())
		    return "";
		return v.asString();
	    }
        }
    }

    
}
