/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.util.*;


/**
 *  Implementation of function fn:sum.
 */
public class Sum extends Function {

    static Prototype[] protos = { 
        Prototype.fn("sum", Type.DOUBLE.opt, Exec.class)
            .arg("srcval", Type.ITEM.star)
    };
    public Prototype[] getProtos() { return protos; }

    static Prototype[] protoI = { 
        Prototype.fn("sum", Type.INTEGER.opt, ExecI.class).arg("args", Type.INTEGER.star)
    };

    public Expression staticCheck( StaticContext context, Expression[] arguments,
				   Expression subject )	{
	Exec rt = (Exec) super.staticCheck(context, arguments, subject);
	// change the result type to the type of the argument (may be empty -> optional)
	if(rt.args.length > 0) {	// error protection
	    ItemType argType = rt.args[0].getType().getItemType();
	    if(argType == Type.INTEGER)
		return context.resolve(protoI, arguments, subject);
	}	
        return rt;
    }

    public static class Exec extends Function.DoubleCall
    {
        public double evalAsDouble(Focus focus, EvalContext context)
	    throws XQueryException {
	    double S = 0;
            context.at(this);
	    Value v = args[0].eval(focus, context);
	    try {
		for( ; v.next(); )
		    S += v.asDouble();
	    }
	    catch (EvalException e) {
		context.error(this, e);
	    }
	    return S;
        }
    }

    public static class ExecI extends Function.IntegerCall
    {
        public long evalAsInteger(Focus focus, EvalContext context)
	    throws XQueryException {
	    long S = 0;
	    Value v = args[0].eval(focus, context);
            context.at(this);
	    try {
		for( ; v.next(); )
		    S += v.asInteger();
	    }
	    catch (EvalException e) {
		context.error(this, e);
	    }
	    return S;
        }
    }
}
