/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.IntegerValue;

/**
 *  Implementation of function fn:string-to-codepoints.
 */
public class StringToCodepoints extends Function {

    static Prototype[] protos = { 
        Prototype.fn("string-to-codepoints", Type.INTEGER.star, Exec.class)
            .arg("srcval", Type.STRING)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    return new Sequence( args[0].evalAsString(focus, context) );
        }
    }

    static class Sequence  extends IntegerValue {

	String source;
	int position = 0;

	Sequence( String source ) {
	    this.source = source;
	}

	public boolean next() throws XQueryException {
	    return ++ position <= source.length();
	}

	public long   asInteger() throws TypeException {
	    return position < 1 || position > source.length() ? 0 : source.charAt(position-1);
	}

	public Value  bornAgain() {
	    return new Sequence(source);
	}
    }
}
