/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleString;
import java.net.URI;

/**
 *  Implementation of function fn:resolve-uri.
 */
public class ResolveUri extends Function {

    static Prototype[] protos = { 
        Prototype.fn("resolve-uri", Type.STRING, Exec.class)
            .arg("relative", Type.STRING),
        Prototype.fn("resolve-uri", Type.STRING, Exec.class)
            .arg("relative", Type.STRING) .arg("base", Type.ANYURI)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String relative = args[0].evalAsString(focus, context);
	    String base = args.length > 1 ? args[1].evalAsString(focus, context)
		: context.getStaticContext().getBaseURI();
	    try {
		URI result = new URI(base).resolve(relative);
		return new SingleString( result.toString(), Type.ANYURI );
	    }
	    catch (java.net.URISyntaxException e) {
		context.error(this, e.getMessage()); return null;
	    }
        }
    }
}
