/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.SingleQName;

/**
 *  Implementation of function fn:resolve-QName.
 */
public class ResolveQName extends Function {

    static Prototype[] protos = { 
        Prototype.fn("resolve-QName", Type.QNAME, Exec.class)
            .arg("qname", Type.STRING) .arg("element", Type.ELEMENT)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    try {
		QName result = null;
		String name = args[0].evalAsString(focus, context);
		Node element = args[1].evalAsNode(focus, context);
		String prefix = NSPrefixMapping.extractPrefix(name);
		String ncname = NSPrefixMapping.extractLocalName(name);
		if(prefix.length() == 0)
		    return new SingleQName(QName.get(Namespace.NONE, ncname));
		String uri = element.getNsUri(prefix);
		if(uri != null) 
		    result = QName.get(uri, ncname);
		/// dont look in static context
		///else result = context.getStaticContext().getInScopeNS().expandName( name );
		if(result == null)
		    context.error(this, "no namespace found for prefix "+prefix);
		return new SingleQName(result);
	    }
	    catch (IllegalArgumentException e) {
		context.error(this, e.getMessage()); return null;
	    }
        }
    }
}
