/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.xquery.dt.SingleDuration;

/**
 *  Implementation of function fn:implicit-timezone.
 */
public class ImplicitTimezone extends Function {

    static Prototype[] protos = { 
        Prototype.fn("implicit-timezone", Type.DAY_TIME_DURATION.opt, Exec.class)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    return new SingleDuration( new Duration( 0, 60 * context.getImplicitTimezone()) );
        }
    }
}
