/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.QNameValue;

/**
 *  Implementation of function fn:get-namespace-from-QName.
 */
public class GetNamespaceFromQName extends Function {

    static Prototype[] protos = { 
        Prototype.fn("get-namespace-from-QName", Type.STRING.opt, Exec.class)
            .arg("srcval", Type.QNAME.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item item = args[0].evalAsOptItem(focus, context);
	    if(item == null)
		return Value.empty;
	    return new SingleString(((QNameValue) item).getValue().getURI());
        }
    }
}
