/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:empty.
 */
public class Empty extends Function {

    static Prototype[] protos = { 
        Prototype.fn("empty", Type.BOOLEAN, Exec.class) .arg("srcval", Type.ITEM.star)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.BoolCall {

        public boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    return ! args[0].eval(focus, context).next();
        }
    }
}
