/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;

/**
 *  Implementation of function fn:count. TODO unordered
 */
public class Count extends Function {

    static Prototype[] protos = { 
        Prototype.fn("count", Type.INTEGER, Exec.class).arg("srcval", Type.ITEM.star),
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.IntegerCall {

	public long evalAsInteger(Focus focus, EvalContext context)
	    throws XQueryException {
	    try {
		Value v = args[0].eval(focus, context);
		v.setLazy(true);
		long cnt = 0;
		for( ; v.next(); ) {
		    if((cnt & 31) == 0)
			context.at(this);
		    ++ cnt;
		}
		return cnt;
	    }
	    catch (EmptyException e) {
		return 0;
	    }
	}
    }
}
