/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:concat.
 */
public class Concat extends Function {

    static Prototype[] protos = { 
        Prototype.varfn("concat", Type.STRING, Exec.class) .arg("op", Type.STRING.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    StringBuffer buf = new StringBuffer();
	    for(int s = 0; s < args.length; s++) {
		Value v = args[s].eval(focus, context);
		context.at(this);
		// this seems to be an extension: each arg can be a sequence of strings
		for(; v.next(); )
		    buf.append(v.asString());
	    }
	    return buf.toString();
        }
    }
}
