/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:avg.
 */
public class Avg extends Function {

    static Prototype[] protos = { 
        Prototype.fn("avg", Type.ATOM.opt, Exec.class).
	arg("op", Type.ITEM.star)   // wider than definition to avoid boring type problems
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.DoubleCall {

        public double evalAsDouble(Focus focus, EvalContext context)
	    throws XQueryException {
	    context.at(this);
	    Value v = args[0].eval(focus, context);
	    double S = 0;
	    int N = 0;
	    try {
		for( ; v.next();) {
		    S += v.asDouble();
		    ++ N;
		}
	    }
	    catch (EvalException e) {
		e.setContext(context); throw e;	// necessary for proper backtrace
	    }
	    if(N == 0)
		throw EmptyException.allowed();
	    return S / N;
	}
    }
}
