/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Namespace;

/**
 *	External (Java) object wrapped as extension type xdt:object.
 */
public class WrappedObjectType extends AtomicType
{
    public QName getName() {
	return QName.get(Namespace.XDT, getShortName());
    }

    public String toString() {
	return "xdt:" + getShortName();
    }

    public String getShortName() {
        return "object";
    }

    public boolean accepts( Type valueType ) {
	return Type.OBJECT == valueType.getItemType()
	    || Type.STRING.accepts(valueType.getItemType());
    }

} // end of class WrappedObjectType
