/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;

public class StringType extends AtomicType {

    public String getShortName() {
        return "string";
    }

    protected boolean checkValue( String value ) {
	return true;
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	String result = null;
	try {
	    result = value.asString();
	} catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:string: "+ e.getMessage());
        }
	if( !checkValue(result) )
	    throw new TypeException("cannot cast to xs:"+ getShortName() +
				    ": value does not conform to facets");
	return new SingleString( result, this );
    }
}
