/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import net.xfra.qizxopen.xquery.*;

/**
 *	Scalar typed Decimal value. 
 *	
 */
public class SingleDecimal extends DecimalValue
{
    private BigDecimal value;
    private boolean started = false;

    public SingleDecimal( BigDecimal value ) {
	this.value = value;
	this.itemType = Type.DECIMAL;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleDecimal(value);
    }

    public BigDecimal getValue() {
	return value;
    }

    public BigDecimal  asDecimal() throws TypeException {
	return value;
    }

} // end of class SingleDecimal

