/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.util.QName;

import java.math.BigDecimal;
import java.text.Collator;

/**
 *	Generic Value implementation. <p>Abstract class for variant values, like those
 *	returned by Sequence or Flower expressions. Holds a current item and delegates
 *	all methods to this current item.
 */
public abstract class GenericValue extends BaseValue
{
    protected Item item;
    protected boolean lazy = false;	// trick used to boost count()

    public ItemType  getType() {
	return item != null ? item.getType() : Type.ITEM;
    }

    public Item asItem() throws TypeException {
	return  item;
    }

    public Item    asAtom() throws TypeException {
	if(item.isNode())
	    // this is OK for XQ Basic: improve it later
	    item = new SingleString(item.asNode().getStringValue(), Type.UNTYPED_ATOMIC);
	return item;
    }

    public boolean  asBoolean() throws TypeException {
	return item.asBoolean();
    }

    public long     asInteger() throws TypeException {
	return item.asInteger();
    }

    public BigDecimal  asDecimal() throws TypeException {
	return item.asDecimal();
    }

    public double   asDouble() throws TypeException {
	return item.asDouble();
    }

    public String   asString()  throws TypeException {
	return item.asString();
    }

    public Node     asNode() throws TypeException {
	if(item == null) { System.err.println("null item in "+this); return null; }
	return item.asNode();
    }

    public boolean  isNode() {
	return item.isNode();
    }

    public int compareTo( Item that, Collator coll, int implicitTimeZone ) throws TypeException {
	return item.compareTo(that, coll, implicitTimeZone);
    }

    public boolean equals( Object that ) {
	return item.equals(that);
    }

    public int hashCode() {
	return item == null ? 0 : item.hashCode();
    }

    public void setLazy(boolean value) {
        lazy = value;
    }
} // end of class AnyValue

