/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	
 */
public abstract class FloatValue extends BaseValue
{
    public FloatValue() {
	itemType = Type.FLOAT;
    }

    public Item  asItem() throws TypeException {
	return new SingleFloat( asFloat() );
    }

    public boolean  asBoolean() throws TypeException {
	float d = asFloat();
	return d == d && d != 0;	// d==d tests NaN
    }

    public long    asInteger() throws TypeException {
	return (long) Math.round( asFloat() );
    }

    public double  asDouble() throws TypeException {
	return asFloat();
    }

    public String  asString( )  throws TypeException {
        return Conversion.toString( asFloat() ); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof Item) )
	    return false;
        try {
	    Item thatItem = (Item) that;
	    return thatItem.getType() == Type.FLOAT && asFloat() == thatItem.asFloat();
        }
        catch (TypeException e) { return false; }
    }

    public int hashCode() {
	try {
	    return Float.floatToIntBits(asFloat());
        }
        catch (Exception e) { return 0; }	// cannot happen
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone ) throws TypeException {
	if( !Type.DOUBLE.accepts( that.getType() ) )
	    return INCOMPARABLE;
	//TODO? subtle difference in comparing double or float
	return Util.comparison( asDouble() - that.asDouble() );
    }
} 

