/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;

public class FloatType extends NumericType {

    public String getShortName() {
        return "float";
    }

    public boolean accepts( Type that ) {
	return Type.NUMERIC.accepts(that) && that != Type.DOUBLE;
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
        try {
	    return new SingleFloat( (float) value.asDouble() );	// ???
        }
        catch (TypeException err) {
	    err = new TypeException("cannot cast to float: "+err.getMessage());
	    err.setContext(context);
	    throw err;
        }
    }
}
