/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Binary;
import net.xfra.qizxopen.xquery.*;

/**
 *	Abstract Binary value (hex & base64).
 */
public abstract class BinaryValue extends BaseValue
{
    public Item asItem() {
	return this;
    }

    public abstract Binary getValue();

    public String  asString()  throws TypeException {
        return itemType == Type.HEX_BINARY ? 
	    getValue().toHexString() : getValue().toBase64String(); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof BinaryValue) )
	    return false;
	return getValue().equals( ((BinaryValue) that).getValue() );
    }

    public int hashCode() {
	return getValue().hashCode();
    }
    
    public int compareTo( Item that, java.text.Collator c, int implicitTimeZone ) {
	if( !(that instanceof BinaryValue) )
	    return INCOMPARABLE;
	return getValue().compareTo( ((BinaryValue) that).getValue() );
    }

} // end of class BinaryValue
