/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Util;

import java.text.Collator;

/**
 *	Root of all atomic types. Undocumented internal class.
 */
public class AtomicType extends ItemType
{
    public AtomicType() {
    }

    public void dump( ExprDump d ) {
	d.println("AtomicType "+getShortName());
    }

    public String getShortName() {
	return "atom";
    }

    public QName getName() {
	return QName.get(Namespace.XSD, getShortName());
    }

    public boolean accepts( Type valueType ) {
	// a SequenceType must be reduced, because the occ can be checked only at run-time
	ItemType itemType = valueType.getItemType();
	// atomization: accepts any node // FIXME schema import
	if(Type.NODE.accepts(itemType) || Type.UNTYPED_ATOMIC == itemType)
	    return true;
	// the usual trick
	return isSuperType( itemType );
    }

} // end of class AtomicType
