/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.op.Expression;

public interface LibraryLink
{
    // return Library as wrapped object (empty sequence if not found)
    Value openLibrary( String uri, EvalContext context )
	throws XQueryException;

    // find collection by absolute path (seen as a node sequence)
    Value findCollection( String uri, EvalContext context )
	throws XQueryException;

    // find document by absolute path (seen as a document node)
    Value findDocument( String uri, EvalContext context )
	throws XQueryException;

    Value evalPath( Expression path, Focus focus, EvalContext context )
	throws XQueryException;

    String PROP = ":liblink";
}
