/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *  Analyzes text chunks to extract and normalize words.
 *  Used in full-text indexation and search.
 *	
 */
public interface WordExtractor
{ 
    /**
     *  Starts the analysis of a new text chunk.
     */
    void start(char[] text, int length);

    /**
     *  Gets the next normalized word, or null if no more words.
     *  Must return a new char array for each word.
     */
    char[] nextWord();

    /**
     *	Returns the offset of the last word returned by nextWord.
     */
    int wordOffset();

    /**
     *	Returns the original length of the last word returned by nextWord.
     *	(Most often equal to the length of the returned token).
     */
    int wordLength();

    /**
     *	Returns the character at current position + ahead, or 0 if after end.
     */
    char charAt(int ahead);

    /**
     *	Moves to next character and return it, returns 0 if at end.
     */
    char nextChar();

    /**
     *  Normalizes a character (belonging to a word)
     */
    char mapChar(char c);

    /**
     *	Returns true if the char can be at start of a word.
     */
    boolean isWordStart(char c);
    /**
     *	Returns true if the char can be part of a word.
     */
    boolean isWordPart(char c);
}
