/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *  	Matches a string with a pattern.
 *  	This superclass implements the identity comparison.
 */
public class StringMatcher
{
    char[] pattern;
    boolean exact = true;

    public StringMatcher(char[] pattern, int length) {
	this.pattern = pattern;
	if(pattern.length != length) {
	    this.pattern = new char[length];
            System.arraycopy(pattern, 0, this.pattern, 0, length);
        }
    }

    public boolean exactMatch() {
	return exact;
    }

    public String toString() {
	return "Word "+new String(pattern);
    }

    public char[] getPattern() {
        return pattern;
    }
    /**
     *	Redefinable matching method.
     */
    public boolean matches(char[] string) {
	if(string.length != pattern.length)
	    return false;
	for(int i = string.length; --i >= 0; )
	    if(string[i] != pattern[i])
		return false;
	return true;
    }
} // end of class StringMatcher
