/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util;

/**
 *	
 */
public class IntersectionIdSet extends IdSet 
{
    IdSet set1, set2;

    public IntersectionIdSet(IdSet set1, IdSet set2) {
        this.set1 = set1;
	this.set2 = set2;
    }

    public boolean test( int id ) {
	return set1.test(id) && set2.test(id);
    }

    public int getNext( int id ) {
	return getNext(id, set1, set2);
    }

    public static int getNext( int id, IdSet set1, IdSet set2) {
	for(;;) {
	    int nxt1 = set1.getNext(id);
	    int nxt2 = set2.getNext(id);
	    if(nxt1 < 0 || nxt2 < 0)
		return -1;
	    if(nxt1 == nxt2)
		return nxt1;
	    id = Math.max(nxt1, nxt2);
	}
    }

    public IdSet copy() {
	return new IntersectionIdSet(set1.copy(), set2.copy());
    }

    public boolean intersects( IdSet that ) {
	return IntersectionIdSet.getNext(0, this, that) >= 0;
    }
} // end of class IntersectionIdSet
