/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.dm.Node;

import net.xfra.qizxopen.dm.FulltextQuery;
import net.xfra.qizxopen.util.*;

/**
 *  Implementation of function qizx:fulltext:
 *    low-efficiency fallback implementation used in absence of fulltext indexing.
 */
public class QizxFulltext extends Function {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "fulltext");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	.arg("query", Type.STRING).arg("context", Type.NODE.star),
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	    .arg("query", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    // get word extractor from context: may have been set as a system property
    static WordExtractor getWordExtractor(EvalContext context) {
	WordExtractor extr = (WordExtractor) context.getProperty("word-extractor");
	return extr != null? extr : new DefaultWordExtractor();
    }

    public static class Exec extends Function.BoolCall {

	FulltextQuery previousCompiled;
	String previousQuery;
	EvalContext previousContext;

	public synchronized FulltextQuery preparedQuery( Focus focus, EvalContext context )
	    throws XQueryException {
// 	    if(precompiled != null)
// 		return precompiled;
	    String q = args[0].evalAsString(focus, context);
	    if(context == previousContext && q.equals(previousQuery))
		return previousCompiled;
	    try {
		previousCompiled = FulltextQuery.parseQuery(q, getWordExtractor(context));
		previousQuery = q;
		previousContext = context;
		return previousCompiled;
	    }
	    catch (FulltextQuery.ParseException e) {
		context.error(args[0], "full-text query error: "+e.getMessage());
	    }
	    return null;
	}

// 	// precompile expression if constant
// 	public void compilationHook() {
// 	    Expression q = args[1];
// 	    if(q instanceof StringLiteral) {
// 		String query = ((StringLiteral) q).value;
// 		try {
// 		    precompiled = FulltextQuery.parseQuery(query);
// 		}
// 		catch (FulltextQuery.ParseException e) { } // just keep silent
// 	    }
// 	}

        public boolean evalAsBoolean(Focus focus, EvalContext context)
	    throws XQueryException {
	    FulltextQuery query = preparedQuery(focus, context);
	    if(args.length > 1) {
		Value seq = args[1].eval(focus, context);
		// stop on first matching node:
		for(; seq.next(); ) {
		    Node node = seq.asNode();
		    if(query.matches(node))
			return true;
		}
		return false;
	    }
	    else {
		checkFocus(focus, context);
		return query.matches( focus.getItem().asNode() );
	    }
	}
    }
}
