/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.*;
import java.io.*;

/**
 *	
 */
public class FONIDumper
{
    FONIDocument doc;
    StringBuffer sb = new StringBuffer();
    int maxDepth = 1000000;
    boolean tagStyle = true;

    public FONIDumper( FONIDocument doc ) {
	setDocument(doc);
    }

    public void setDocument(FONIDocument doc) {
	this.doc = doc;
    }

    public void setMaxDepth(int value) {
        maxDepth = value;
    }

    public void dump(PrintStream out, int depth) {
	dumpTree(out, doc.getRootNode(), depth);
    }

    public boolean dumpNode( PrintStream out, int nodeId, boolean dummy ) {

	int type = doc.getKind(nodeId);
	if (type == FONIDocument.ELEMENT || type == FONIDocument.DOCUMENT) {
	    int gi = doc.getNameId(nodeId), attC = doc.getAttrCount(nodeId);
	    QName name = doc.getElementName(gi);
	    if (!dummy) {
		out.print("Element "+ name + " ");
		if(attC > 0)
		    out.print(attC + " attr:"); 
	    }
	    StringBuffer buf = new StringBuffer();
	    FONIDocument.NodeIterator attrIter = doc.attrIterator(nodeId);
	    while(attrIter.next()) {
		int attrNode = attrIter.currentId();
		name = doc.getOtherName(doc.pnGetNameId(attrNode));
		buf.append(' ').append(name);
		buf.append("='").append(doc.pnGetStringValue(attrNode)).append('\'');
	    }
	    FONIDocument.NodeIterator nsit = doc.namespaceIterator(nodeId, false);
	    while(nsit.next()) {
		int nsNode = nsit.currentId();
		
		name = doc.getOtherName(doc.pnGetNameId(nsNode));
		buf.append("xmlns:").append(name).append("='").
		    append(doc.pnGetStringValue(nsNode)).append('\'');
	    }
	    if (!dummy)
		out.println(buf);
	    return true;
	}
	else {
	    sb.setLength(0);
	    switch(type) {
	    case FONIDocument.TEXT:
		if (!dummy) out.print("|");
		break;
	    case FONIDocument.PROCESSING_INSTRUCTION:
		if (!dummy) out.print("PI "+doc.getName(nodeId)+" |");
		break;
	    case FONIDocument.COMMENT:
		if (!dummy) out.print("Comment |");
		break;
	    }
	    if (!dummy) {
		out.print(doc.getStringValue(nodeId));
		out.println('|');
	    }
	}
	return false;
    }

    public void dumpTree(PrintStream out, int nodeId, int depth ) {
	boolean dummy = maxDepth < 0;
	if (!dummy && depth > maxDepth)
	    return;
	if(!dummy) {
	    out.print(nodeId);
	    for(int d = 0; d < depth; d++) out.print("  ");
	}
	if(dumpNode(out, nodeId, dummy) && (dummy || depth < maxDepth)) {
	    int kid = doc.getFirstChild(nodeId), next;
	    int rank = 0;
	    for( ; kid != 0; kid = next, ++ rank) {
		next = doc.getNextSibling(kid);   // anticipating is more cache-efficient
		//if (next == NULL_ID && rank == 0 && getKind(kid) == FONIDocument.TEXT)
		//    ++ nTextSingle;
		dumpTree(out, kid, depth + 1);
	    }
	}
    }

    public int adjust(int nodeId) {
	int container = doc.getRootNode();
	for(int depth = 0; ; depth++) {
	    int span = doc.getNodeSpan(container), kind = doc.getKind(container);
	    if(kind != FONIDocument.ELEMENT && kind != FONIDocument.DOCUMENT) 
		break;
	    int kid = doc.getFirstChild(container), next;
	    int rank = 0;
	    for( ; kid != 0; kid = next, ++ rank) {
		next = doc.getNextSibling(kid);
		if(kid > nodeId)
		    return container;
		if(kid + doc.getNodeSpan(kid) > nodeId) {
		    container = kid;
		    break;
		}
	    }
	}
	return container;
    }

    public void locateInside(int container, int nodeId) {
	for(int depth = 0; ; depth++) {
	    int span = doc.getNodeSpan(container);
	    System.out.print(container+"["+span+"]	");
	    for(int d = 0; d < depth; d++) System.out.print("  ");
	    dumpNode(System.out, container, maxDepth < 0);
	    if(doc.getKind(container) != FONIDocument.ELEMENT) 
		break;
	    int kid = doc.getFirstChild(container), next;
	    int rank = 0;
	    for( ; kid != 0; kid = next, ++ rank) {
		next = doc.getNextSibling(kid);
		if(kid > nodeId)
		    return;
		if(kid + doc.getNodeSpan(kid) > nodeId) {
		    container = kid;
		    break;
		}
	    }
	}
    }

} // end of class Dumper

