/*
 * Decompiled with CFR 0.152.
 */
package com.sun.resolver;

import com.sun.resolver.CatalogEntry;
import com.sun.resolver.CatalogException;
import com.sun.resolver.CatalogManager;
import com.sun.resolver.helpers.Debug;
import com.sun.resolver.helpers.PublicId;
import com.sun.resolver.readers.CatalogReader;
import com.sun.resolver.readers.SAXCatalogReader;
import com.sun.resolver.readers.TR9401CatalogReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;

public class Catalog {
    public static final int BASE = CatalogEntry.addEntryType("BASE", 1);
    public static final int CATALOG = CatalogEntry.addEntryType("CATALOG", 1);
    public static final int DOCUMENT = CatalogEntry.addEntryType("DOCUMENT", 1);
    public static final int OVERRIDE = CatalogEntry.addEntryType("OVERRIDE", 1);
    public static final int SGMLDECL = CatalogEntry.addEntryType("SGMLDECL", 1);
    public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType("DELEGATE_PUBLIC", 2);
    public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType("DELEGATE_SYSTEM", 2);
    public static final int DELEGATE_URI = CatalogEntry.addEntryType("DELEGATE_URI", 2);
    public static final int DOCTYPE = CatalogEntry.addEntryType("DOCTYPE", 2);
    public static final int DTDDECL = CatalogEntry.addEntryType("DTDDECL", 2);
    public static final int ENTITY = CatalogEntry.addEntryType("ENTITY", 2);
    public static final int LINKTYPE = CatalogEntry.addEntryType("LINKTYPE", 2);
    public static final int NOTATION = CatalogEntry.addEntryType("NOTATION", 2);
    public static final int PUBLIC = CatalogEntry.addEntryType("PUBLIC", 2);
    public static final int SYSTEM = CatalogEntry.addEntryType("SYSTEM", 2);
    public static final int URI = CatalogEntry.addEntryType("URI", 2);
    public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType("REWRITE_SYSTEM", 2);
    public static final int REWRITE_URI = CatalogEntry.addEntryType("REWRITE_URI", 2);
    protected URL base;
    protected URL catalogCwd;
    protected Vector catalogEntries = new Vector();
    protected boolean default_override = true;
    protected Vector catalogFiles = new Vector();
    protected Vector localCatalogFiles = new Vector();
    protected Vector catalogs = new Vector();
    protected Vector localDelegate = new Vector();
    protected Hashtable readerMap = new Hashtable();
    protected Vector readerArr = new Vector();

    public void setupReaders() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXCatalogReader saxReader = new SAXCatalogReader(spf);
        saxReader.setCatalogParser(null, "XMLCatalog", "com.sun.resolver.readers.XCatalogReader");
        saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "com.sun.resolver.readers.OASISXMLCatalogReader");
        this.addReader("application/xml", saxReader);
        TR9401CatalogReader textReader = new TR9401CatalogReader();
        this.addReader("text/plain", textReader);
    }

    public void addReader(String mimeType, CatalogReader reader) {
        if (this.readerMap.contains(mimeType)) {
            Integer pos = (Integer)this.readerMap.get(mimeType);
            this.readerArr.set(pos, reader);
        } else {
            this.readerArr.add(reader);
            Integer pos = new Integer(this.readerArr.size() - 1);
            this.readerMap.put(mimeType, pos);
        }
    }

    protected void copyReaders(Catalog newCatalog) {
        Vector<String> mapArr = new Vector<String>(this.readerMap.size());
        int count = 0;
        while (count < this.readerMap.size()) {
            mapArr.add(null);
            ++count;
        }
        Enumeration enumeration = this.readerMap.keys();
        while (enumeration.hasMoreElements()) {
            String mimeType = (String)enumeration.nextElement();
            Integer pos = (Integer)this.readerMap.get(mimeType);
            mapArr.set(pos, mimeType);
        }
        int count2 = 0;
        while (count2 < mapArr.size()) {
            String mimeType = (String)mapArr.get(count2);
            Integer pos = (Integer)this.readerMap.get(mimeType);
            newCatalog.addReader(mimeType, (CatalogReader)this.readerArr.get(pos));
            ++count2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Catalog newCatalog() {
        String catalogClass = this.getClass().getName();
        try {
            void cnfe;
            Catalog c = (Catalog)Class.forName(catalogClass).newInstance();
            this.copyReaders(c);
            return cnfe;
        }
        catch (ClassNotFoundException cnfe) {
            Debug.message(1, "Class Not Found Exception: " + catalogClass);
        }
        catch (IllegalAccessException iae) {
            Debug.message(1, "Illegal Access Exception: " + catalogClass);
        }
        catch (InstantiationException ie) {
            Debug.message(1, "Instantiation Exception: " + catalogClass);
        }
        catch (ClassCastException cce) {
            Debug.message(1, "Class Cast Exception: " + catalogClass);
        }
        catch (Exception e) {
            Debug.message(1, "Other Exception: " + catalogClass);
        }
        Catalog c = new Catalog();
        this.copyReaders(c);
        return c;
    }

    public Catalog() {
        this.default_override = CatalogManager.preferPublic();
    }

    public String getCurrentBase() {
        return this.base.toString();
    }

    public String getDefaultOverride() {
        if (this.default_override) {
            return "yes";
        }
        return "no";
    }

    public void loadSystemCatalogs() throws MalformedURLException, IOException {
        Vector catalogs = CatalogManager.catalogFiles();
        if (catalogs != null) {
            int count = 0;
            while (count < catalogs.size()) {
                this.catalogFiles.addElement(catalogs.elementAt(count));
                ++count;
            }
        }
        if (this.catalogFiles.size() > 0) {
            String catfile = (String)this.catalogFiles.lastElement();
            this.catalogFiles.removeElement(catfile);
            this.parseCatalog(catfile);
        }
    }

    public synchronized void parseCatalog(String fileName) throws MalformedURLException, IOException {
        Debug.message(4, "Parse catalog: " + fileName);
        this.catalogFiles.addElement(fileName);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(String mimeType, InputStream is) throws IOException, CatalogException {
        Debug.message(4, "Parse " + mimeType + " catalog on input stream");
        CatalogReader reader = null;
        if (this.readerMap.containsKey(mimeType)) {
            int arrayPos = (Integer)this.readerMap.get(mimeType);
            reader = (CatalogReader)this.readerArr.get(arrayPos);
        }
        if (reader == null) {
            String msg = "No CatalogReader for MIME type: " + mimeType;
            Debug.message(2, msg);
            throw new CatalogException(6, msg);
        }
        reader.readCatalog(this, is);
        this.parsePendingCatalogs();
    }

    protected synchronized void parsePendingCatalogs() throws MalformedURLException, IOException {
        if (!this.localCatalogFiles.isEmpty()) {
            Vector newQueue = new Vector();
            Enumeration q = this.localCatalogFiles.elements();
            while (q.hasMoreElements()) {
                newQueue.addElement(q.nextElement());
            }
            int curCat = 0;
            while (curCat < this.catalogFiles.size()) {
                String catfile = (String)this.catalogFiles.elementAt(curCat);
                newQueue.addElement(catfile);
                ++curCat;
            }
            this.catalogFiles = newQueue;
            this.localCatalogFiles.clear();
        }
        if (this.catalogFiles.isEmpty() && !this.localDelegate.isEmpty()) {
            Enumeration e = this.localDelegate.elements();
            while (e.hasMoreElements()) {
                this.catalogEntries.addElement(e.nextElement());
            }
            this.localDelegate.clear();
        }
        while (!this.catalogFiles.isEmpty()) {
            String catfile = (String)this.catalogFiles.elementAt(0);
            try {
                this.catalogFiles.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (this.catalogEntries.size() == 0 && this.catalogs.size() == 0) {
                try {
                    this.parseCatalogFile(catfile);
                }
                catch (CatalogException ce) {
                    System.out.println("FIXME: " + ce.toString());
                }
            } else {
                this.catalogs.addElement(catfile);
            }
            if (!this.localCatalogFiles.isEmpty()) {
                Vector newQueue = new Vector();
                Enumeration q = this.localCatalogFiles.elements();
                while (q.hasMoreElements()) {
                    newQueue.addElement(q.nextElement());
                }
                int curCat = 0;
                while (curCat < this.catalogFiles.size()) {
                    catfile = (String)this.catalogFiles.elementAt(curCat);
                    newQueue.addElement(catfile);
                    ++curCat;
                }
                this.catalogFiles = newQueue;
                this.localCatalogFiles.clear();
            }
            if (this.localDelegate.isEmpty()) continue;
            Enumeration e = this.localDelegate.elements();
            while (e.hasMoreElements()) {
                this.catalogEntries.addElement(e.nextElement());
            }
            this.localDelegate.clear();
        }
        this.catalogFiles.clear();
    }

    protected synchronized void parseCatalogFile(String fileName) throws MalformedURLException, IOException, CatalogException {
        try {
            String userdir = this.fixSlashes(System.getProperty("user.dir"));
            this.catalogCwd = new URL("file:///" + userdir + "/basename");
        }
        catch (MalformedURLException e) {
            String userdir = this.fixSlashes(System.getProperty("user.dir"));
            Debug.message(1, "Malformed URL on cwd", userdir);
            this.catalogCwd = null;
        }
        try {
            this.base = new URL(this.catalogCwd, this.fixSlashes(fileName));
        }
        catch (MalformedURLException e) {
            try {
                this.base = new URL("file:///" + this.fixSlashes(fileName));
            }
            catch (MalformedURLException e2) {
                Debug.message(1, "Malformed URL on catalog filename", this.fixSlashes(fileName));
                this.base = null;
            }
        }
        Debug.message(2, "Loading catalog", fileName);
        Debug.message(4, "Default BASE", this.base.toString());
        fileName = this.base.toString();
        DataInputStream inStream = null;
        boolean parsed = false;
        boolean notFound = false;
        int count = 0;
        while (!parsed && count < this.readerArr.size()) {
            CatalogReader reader = (CatalogReader)this.readerArr.get(count);
            try {
                notFound = false;
                inStream = new DataInputStream(this.base.openStream());
            }
            catch (FileNotFoundException fnfe) {
                notFound = true;
                break;
            }
            try {
                reader.readCatalog(this, inStream);
                parsed = true;
            }
            catch (CatalogException ce) {
                if (ce.getExceptionType() == 7) break;
            }
            try {
                inStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            ++count;
        }
        if (!parsed) {
            if (notFound) {
                Debug.message(3, "Catalog does not exist", fileName);
            } else {
                Debug.message(1, "Failed to parse catalog", fileName);
            }
        }
    }

    public void addEntry(CatalogEntry entry) {
        int type = entry.getEntryType();
        if (type == BASE) {
            String value = entry.getEntryArg(0);
            URL newbase = null;
            Debug.message(5, "BASE CUR", this.base.toString());
            Debug.message(4, "BASE STR", value);
            try {
                value = this.fixSlashes(value);
                newbase = new URL(this.base, value);
            }
            catch (MalformedURLException e) {
                try {
                    newbase = new URL("file:///" + value);
                }
                catch (MalformedURLException e2) {
                    Debug.message(1, "Malformed URL on base", value);
                    newbase = null;
                }
            }
            if (newbase != null) {
                this.base = newbase;
            }
            Debug.message(5, "BASE NEW", this.base.toString());
        } else if (type == CATALOG) {
            String fsi = this.makeAbsolute(entry.getEntryArg(0));
            Debug.message(4, "CATALOG", fsi);
            this.localCatalogFiles.addElement(fsi);
        } else if (type == PUBLIC) {
            String publicid = PublicId.normalize(entry.getEntryArg(0));
            String systemid = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(0, publicid);
            entry.setEntryArg(1, systemid);
            Debug.message(4, "PUBLIC", publicid, systemid);
            this.catalogEntries.addElement(entry);
        } else if (type == SYSTEM) {
            String systemid = this.normalizeURI(entry.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, fsi);
            Debug.message(4, "SYSTEM", systemid, fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == URI) {
            String uri = this.normalizeURI(entry.getEntryArg(0));
            String altURI = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, altURI);
            Debug.message(4, "URI", uri, altURI);
            this.catalogEntries.addElement(entry);
        } else if (type == DOCUMENT) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(0)));
            entry.setEntryArg(0, fsi);
            Debug.message(4, "DOCUMENT", fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == OVERRIDE) {
            Debug.message(4, "OVERRIDE", entry.getEntryArg(0));
            this.catalogEntries.addElement(entry);
        } else if (type == SGMLDECL) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(0)));
            entry.setEntryArg(0, fsi);
            Debug.message(4, "SGMLDECL", fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == DELEGATE_PUBLIC) {
            String ppi = PublicId.normalize(entry.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(0, ppi);
            entry.setEntryArg(1, fsi);
            Debug.message(4, "DELEGATE_PUBLIC", ppi, fsi);
            this.addDelegate(entry);
        } else if (type == DELEGATE_SYSTEM) {
            String psi = this.normalizeURI(entry.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(0, psi);
            entry.setEntryArg(1, fsi);
            Debug.message(4, "DELEGATE_SYSTEM", psi, fsi);
            this.addDelegate(entry);
        } else if (type == DELEGATE_URI) {
            String pui = this.normalizeURI(entry.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(0, pui);
            entry.setEntryArg(1, fsi);
            Debug.message(4, "DELEGATE_URI", pui, fsi);
            this.addDelegate(entry);
        } else if (type == REWRITE_SYSTEM) {
            String psi = this.normalizeURI(entry.getEntryArg(0));
            String rpx = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(0, psi);
            entry.setEntryArg(1, rpx);
            Debug.message(4, "REWRITE_SYSTEM", psi, rpx);
            this.catalogEntries.addElement(entry);
        } else if (type == REWRITE_URI) {
            String pui = this.normalizeURI(entry.getEntryArg(0));
            String upx = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(0, pui);
            entry.setEntryArg(1, upx);
            Debug.message(4, "REWRITE_URI", pui, upx);
            this.catalogEntries.addElement(entry);
        } else if (type == DOCTYPE) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, fsi);
            Debug.message(4, "DOCTYPE", entry.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == DTDDECL) {
            String fpi = PublicId.normalize(entry.getEntryArg(0));
            entry.setEntryArg(0, fpi);
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, fsi);
            Debug.message(4, "DTDDECL", fpi, fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == ENTITY) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, fsi);
            Debug.message(4, "ENTITY", entry.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == LINKTYPE) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, fsi);
            Debug.message(4, "LINKTYPE", entry.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry);
        } else if (type == NOTATION) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry.getEntryArg(1)));
            entry.setEntryArg(1, fsi);
            Debug.message(4, "NOTATION", entry.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry);
        } else {
            this.catalogEntries.addElement(entry);
        }
    }

    public void unknownEntry(Vector strings) {
        if (strings != null && strings.size() > 0) {
            String keyword = (String)strings.elementAt(0);
            Debug.message(2, "Unrecognized token parsing catalog", keyword);
        }
    }

    public void parseAllCatalogs() throws MalformedURLException, IOException {
        int catPos = 0;
        while (catPos < this.catalogs.size()) {
            Catalog c = null;
            try {
                c = (Catalog)this.catalogs.elementAt(catPos);
            }
            catch (ClassCastException e) {
                String catfile = (String)this.catalogs.elementAt(catPos);
                c = this.newCatalog();
                c.parseCatalog(catfile);
                this.catalogs.setElementAt(c, catPos);
                c.parseAllCatalogs();
            }
            ++catPos;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() != DELEGATE_PUBLIC && e.getEntryType() != DELEGATE_SYSTEM && e.getEntryType() != DELEGATE_URI) continue;
            Catalog dcat = this.newCatalog();
            dcat.parseCatalog(e.getEntryArg(1));
        }
    }

    public String resolveDoctype(String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        Debug.message(3, "resolveDoctype(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                Debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(DOCTYPE, entityName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == OVERRIDE) {
                over = e.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e.getEntryType() != DOCTYPE || !e.getEntryArg(0).equals(entityName) || !over && systemId != null) continue;
            return e.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCTYPE, entityName, publicId, systemId);
    }

    public String resolveDocument() throws MalformedURLException, IOException {
        Debug.message(3, "resolveDocument");
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() != DOCUMENT) continue;
            return e.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCUMENT, null, null, null);
    }

    public String resolveEntity(String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        Debug.message(3, "resolveEntity(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                Debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(ENTITY, entityName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == OVERRIDE) {
                over = e.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e.getEntryType() != ENTITY || !e.getEntryArg(0).equals(entityName) || !over && systemId != null) continue;
            return e.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(ENTITY, entityName, publicId, systemId);
    }

    public String resolveNotation(String notationName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        Debug.message(3, "resolveNotation(" + notationName + "," + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                Debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(NOTATION, notationName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == OVERRIDE) {
                over = e.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e.getEntryType() != NOTATION || !e.getEntryArg(0).equals(notationName) || !over && systemId != null) continue;
            return e.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(NOTATION, notationName, publicId, systemId);
    }

    public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved;
        Debug.message(3, "resolvePublic(" + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                Debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        resolved = this.resolveLocalPublic(PUBLIC, null, publicId, systemId);
        if (resolved != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(PUBLIC, null, publicId, systemId);
    }

    protected synchronized String resolveLocalPublic(int entityType, String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved;
        publicId = PublicId.normalize(publicId);
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == OVERRIDE) {
                over = e.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e.getEntryType() != PUBLIC || !e.getEntryArg(0).equals(publicId) || !over && systemId != null) continue;
            return e.getEntryArg(1);
        }
        over = this.default_override;
        enumeration = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String p;
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == OVERRIDE) {
                over = e.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e.getEntryType() != DELEGATE_PUBLIC || !over && systemId != null || (p = e.getEntryArg(0)).length() > publicId.length() || !p.equals(publicId.substring(0, p.length()))) continue;
            delCats.addElement(e.getEntryArg(1));
        }
        if (delCats.size() > 0) {
            Enumeration enumCats = delCats.elements();
            if (Debug.getDebug() > 1) {
                Debug.message(2, "Switching to delegated catalog(s):");
                while (enumCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enumCats.nextElement();
                    Debug.message(2, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = this.newCatalog();
            enumCats = delCats.elements();
            while (enumCats.hasMoreElements()) {
                String delegatedCatalog = (String)enumCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolvePublic(publicId, null);
        }
        return null;
    }

    public String resolveSystem(String systemId) throws MalformedURLException, IOException {
        String resolved;
        Debug.message(3, "resolveSystem(" + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            return this.resolvePublic(systemId, null);
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(SYSTEM, null, null, systemId);
    }

    protected String resolveLocalSystem(String systemId) throws MalformedURLException, IOException {
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() != SYSTEM || !e.getEntryArg(0).equals(systemId) && (!windows || !e.getEntryArg(0).equalsIgnoreCase(systemId))) continue;
            return e.getEntryArg(1);
        }
        enumeration = this.catalogEntries.elements();
        String startString = null;
        String prefix = null;
        while (enumeration.hasMoreElements()) {
            String p;
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == REWRITE_SYSTEM && (p = e.getEntryArg(0)).length() <= systemId.length() && p.equals(systemId.substring(0, p.length())) && (startString == null || p.length() > startString.length())) {
                startString = p;
                prefix = e.getEntryArg(1);
            }
            if (prefix == null) continue;
            return prefix + systemId.substring(startString.length());
        }
        enumeration = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String p;
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() != DELEGATE_SYSTEM || (p = e.getEntryArg(0)).length() > systemId.length() || !p.equals(systemId.substring(0, p.length()))) continue;
            delCats.addElement(e.getEntryArg(1));
        }
        if (delCats.size() > 0) {
            Enumeration enumCats = delCats.elements();
            if (Debug.getDebug() > 1) {
                Debug.message(2, "Switching to delegated catalog(s):");
                while (enumCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enumCats.nextElement();
                    Debug.message(2, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = this.newCatalog();
            enumCats = delCats.elements();
            while (enumCats.hasMoreElements()) {
                String delegatedCatalog = (String)enumCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolveSystem(systemId);
        }
        return null;
    }

    public String resolveURI(String uri) throws MalformedURLException, IOException {
        String resolved;
        Debug.message(3, "resolveURI(" + uri + ")");
        uri = this.normalizeURI(uri);
        if (uri != null && uri.startsWith("urn:publicid:")) {
            uri = PublicId.decodeURN(uri);
            return this.resolvePublic(uri, null);
        }
        if (uri != null && (resolved = this.resolveLocalURI(uri)) != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(URI, null, null, uri);
    }

    protected String resolveLocalURI(String uri) throws MalformedURLException, IOException {
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() != URI || !e.getEntryArg(0).equals(uri)) continue;
            return e.getEntryArg(1);
        }
        enumeration = this.catalogEntries.elements();
        String startString = null;
        String prefix = null;
        while (enumeration.hasMoreElements()) {
            String p;
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() == REWRITE_URI && (p = e.getEntryArg(0)).length() <= uri.length() && p.equals(uri.substring(0, p.length())) && (startString == null || p.length() > startString.length())) {
                startString = p;
                prefix = e.getEntryArg(1);
            }
            if (prefix == null) continue;
            return prefix + uri.substring(startString.length());
        }
        enumeration = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String p;
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.getEntryType() != DELEGATE_URI || (p = e.getEntryArg(0)).length() > uri.length() || !p.equals(uri.substring(0, p.length()))) continue;
            delCats.addElement(e.getEntryArg(1));
        }
        if (delCats.size() > 0) {
            Enumeration enumCats = delCats.elements();
            if (Debug.getDebug() > 1) {
                Debug.message(2, "Switching to delegated catalog(s):");
                while (enumCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enumCats.nextElement();
                    Debug.message(2, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = this.newCatalog();
            enumCats = delCats.elements();
            while (enumCats.hasMoreElements()) {
                String delegatedCatalog = (String)enumCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolveURI(uri);
        }
        return null;
    }

    protected synchronized String resolveSubordinateCatalogs(int entityType, String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        int catPos = 0;
        while (catPos < this.catalogs.size()) {
            Catalog c = null;
            try {
                c = (Catalog)this.catalogs.elementAt(catPos);
            }
            catch (ClassCastException e) {
                String catfile = (String)this.catalogs.elementAt(catPos);
                c = this.newCatalog();
                try {
                    c.parseCatalog(catfile);
                }
                catch (MalformedURLException mue) {
                    Debug.message(1, "Malformed Catalog URL", catfile);
                }
                catch (FileNotFoundException fnfe) {
                    Debug.message(1, "Failed to load catalog, file not found", catfile);
                }
                catch (IOException ioe) {
                    Debug.message(1, "Failed to load catalog, I/O error", catfile);
                }
                this.catalogs.setElementAt(c, catPos);
            }
            String resolved = null;
            if (entityType == DOCTYPE) {
                resolved = c.resolveDoctype(entityName, publicId, systemId);
            } else if (entityType == DOCUMENT) {
                resolved = c.resolveDocument();
            } else if (entityType == ENTITY) {
                resolved = c.resolveEntity(entityName, publicId, systemId);
            } else if (entityType == NOTATION) {
                resolved = c.resolveNotation(entityName, publicId, systemId);
            } else if (entityType == PUBLIC) {
                resolved = c.resolvePublic(publicId, systemId);
            } else if (entityType == SYSTEM) {
                resolved = c.resolveSystem(systemId);
            } else if (entityType == URI) {
                resolved = c.resolveURI(systemId);
            }
            if (resolved != null) {
                return resolved;
            }
            ++catPos;
        }
        return null;
    }

    protected String fixSlashes(String sysid) {
        return sysid.replace('\\', '/');
    }

    protected String makeAbsolute(String sysid) {
        URL local = null;
        sysid = this.fixSlashes(sysid);
        try {
            local = new URL(this.base, sysid);
        }
        catch (MalformedURLException e) {
            Debug.message(1, "Malformed URL on system identifier", sysid);
        }
        if (local != null) {
            return local.toString();
        }
        return sysid;
    }

    protected String normalizeURI(String uriref) {
        byte[] bytes;
        String newRef = "";
        if (uriref == null) {
            return null;
        }
        try {
            bytes = uriref.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Debug.message(1, "UTF-8 is an unsupported encoding!?");
            return uriref;
        }
        int count = 0;
        while (count < bytes.length) {
            int ch = bytes[count] & 0xFF;
            newRef = ch <= 32 || ch > 127 || ch == 34 || ch == 60 || ch == 62 || ch == 92 || ch == 94 || ch == 96 || ch == 123 || ch == 124 || ch == 125 || ch == 127 ? newRef + this.encodedByte(ch) : newRef + (char)bytes[count];
            ++count;
        }
        return newRef;
    }

    protected String encodedByte(int b) {
        String hex = Integer.toHexString(b).toUpperCase();
        if (hex.length() < 2) {
            return "%0" + hex;
        }
        return "%" + hex;
    }

    protected void addDelegate(CatalogEntry entry) {
        int pos = 0;
        String partial = entry.getEntryArg(0);
        Enumeration local = this.localDelegate.elements();
        while (local.hasMoreElements()) {
            CatalogEntry dpe = (CatalogEntry)local.nextElement();
            String dp = dpe.getEntryArg(0);
            if (dp.equals(partial)) {
                return;
            }
            if (dp.length() > partial.length()) {
                ++pos;
            }
            if (dp.length() < partial.length()) break;
        }
        if (this.localDelegate.size() == 0) {
            this.localDelegate.addElement(entry);
        } else {
            this.localDelegate.insertElementAt(entry, pos);
        }
    }
}

