/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.GlobalVariable;
import net.xfra.qizxopen.xquery.op.LocalVariable;

public class VarReference
extends Expression {
    public QName name;

    public VarReference(QName qName) {
        this.name = qName;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "VarReference");
        exprDump.display("name", this.name);
    }

    public boolean visit(Expression.Visitor visitor) {
        return visitor.examine(this);
    }

    public Expression staticCheck(StaticContext staticContext) {
        LocalVariable localVariable = staticContext.lookforLocalVariable(this.name);
        if (localVariable != null) {
            return new Local(localVariable).atSamePlaceAs(this);
        }
        GlobalVariable globalVariable = staticContext.lookforGlobalVariable(this.name);
        if (globalVariable != null) {
            return new Global(globalVariable).atSamePlaceAs(this);
        }
        staticContext.getLog().error(this.module, this.location, "variable %1 not declared", staticContext.prefixedName(this.name));
        return this;
    }

    static class Local
    extends VarReference {
        LocalVariable decl;

        Local(LocalVariable localVariable) {
            super(localVariable.name);
            this.decl = localVariable;
            this.type = localVariable.type;
        }

        public void dump(ExprDump exprDump) {
            exprDump.header(this, "LocalRef $" + this.name + " addr " + this.decl.address);
        }

        public int getFlags() {
            return Type.isRepeatable(this.type.getOccurrence()) ? 0 : 12;
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return evalContext.loadLocal(this.decl.address);
        }

        public long evalAsInteger(Focus focus, EvalContext evalContext) throws XQueryException {
            return evalContext.loadLocalInteger(this.decl.address);
        }

        public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            return evalContext.loadLocalDouble(this.decl.address);
        }

        public String evalAsString(Focus focus, EvalContext evalContext) throws XQueryException {
            return evalContext.loadLocalString(this.decl.address);
        }

        public Item evalAsItem(Focus focus, EvalContext evalContext) throws XQueryException {
            return evalContext.loadLocalItem(this.decl.address);
        }
    }

    static class Global
    extends VarReference {
        GlobalVariable address;

        Global(GlobalVariable globalVariable) {
            super(globalVariable.name);
            this.address = globalVariable;
            this.type = globalVariable.getType();
        }

        public void dump(ExprDump exprDump) {
            exprDump.header(this, "GlobalRef $" + this.address.name + " addr " + this.address);
        }

        public int getFlags() {
            return this.address.getFlags();
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return evalContext.loadGlobal(this.address);
            }
            catch (EvalException evalException) {
                return evalContext.error((Expression)this, evalException);
            }
        }
    }
}

